/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.other;

import moonfather.workshop_for_handsome_adventurer.block_entities.BaseContainerBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.BookShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;

public class InWorldTooltip
implements LayeredDraw.Layer {
    private static final InWorldTooltip instance = new InWorldTooltip();

    public static InWorldTooltip getInstance() {
        return instance;
    }

    public void render(@NotNull GuiGraphics guiGraphics, @NotNull DeltaTracker deltaTracker) {
        BlockHitResult hitResult;
        if (Minecraft.getInstance().player == null || Minecraft.getInstance().level == null || Minecraft.getInstance().screen != null) {
            return;
        }
        HitResult hitResult2 = Minecraft.getInstance().hitResult;
        if (hitResult2 instanceof BlockHitResult && (hitResult = (BlockHitResult)hitResult2).getType().equals((Object)HitResult.Type.BLOCK)) {
            BaseContainerBlockEntity blockEntity;
            BlockPos pos;
            Block block;
            BlockState blockState = Minecraft.getInstance().level.getBlockState(hitResult.getBlockPos());
            int slot = -5;
            boolean above = false;
            if (blockState.getBlock() instanceof PotionShelf) {
                if (!((Direction)blockState.getValue((Property)PotionShelf.FACING)).equals((Object)hitResult.getDirection().getOpposite())) {
                    return;
                }
                slot = PotionShelf.getPotionShelfSlot(hitResult);
            } else {
                block = blockState.getBlock();
                if (block instanceof BookShelf) {
                    BookShelf bookShelf = (BookShelf)block;
                    if (!((Direction)blockState.getValue((Property)BookShelf.FACING)).equals((Object)hitResult.getDirection().getOpposite())) {
                        return;
                    }
                    slot = BookShelf.getBookShelfSlot(bookShelf, hitResult);
                } else {
                    block = blockState.getBlock();
                    if (block instanceof ToolRack) {
                        ToolRack toolRack = (ToolRack)block;
                        if (!((Direction)blockState.getValue((Property)BookShelf.FACING)).equals((Object)hitResult.getDirection().getOpposite())) {
                            return;
                        }
                        if (Minecraft.getInstance().level.getBlockEntity(hitResult.getBlockPos()) != null) {
                            slot = ToolRack.getToolRackSlot(toolRack, hitResult);
                        } else {
                            above = true;
                            slot = ToolRack.getToolRackSlot(toolRack, new BlockHitResult(hitResult.getLocation(), hitResult.getDirection(), hitResult.getBlockPos().above(), false));
                        }
                    }
                }
            }
            if (slot >= 0 && (block = Minecraft.getInstance().level.getBlockEntity(pos = above ? hitResult.getBlockPos().above() : hitResult.getBlockPos())) instanceof BaseContainerBlockEntity && !(blockEntity = (BaseContainerBlockEntity)block).GetItem(slot).isEmpty()) {
                guiGraphics.renderTooltip(Minecraft.getInstance().font, blockEntity.GetItem(slot), Minecraft.getInstance().getWindow().getGuiScaledWidth() / 2 - 30, Minecraft.getInstance().getWindow().getGuiScaledHeight() / 2 + 20);
            }
        }
    }
}

