/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.other;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;

@EventBusSubscriber
public class TableLockManager {
    private static final Map<Long, UUID> map = new HashMap<Long, UUID>();
    private static final Map<Integer, Long> indexMap = new HashMap<Integer, Long>();
    private static final Map<Integer, UUID> protoMap = new HashMap<Integer, UUID>();

    public static boolean isLocked(Level level, BlockPos pos) {
        if (level == null || pos == null) {
            return false;
        }
        Long key = TableLockManager.makeKey(level, pos);
        return map.getOrDefault(key, null) != null;
    }

    private static Long makeKey(Level level, BlockPos pos) {
        return Long.rotateLeft(level.hashCode(), 32) + (long)pos.hashCode();
    }

    public static void register(int containerId, Level level, BlockPos pos) {
        if (level == null || pos == null || level.isClientSide()) {
            return;
        }
        Long key = TableLockManager.makeKey(level, pos);
        indexMap.put(containerId, key);
        if (protoMap.containsKey(containerId)) {
            map.put(key, protoMap.get(containerId));
        }
    }

    public static Component getPlayerName(Level level, BlockPos pos) {
        Player player;
        Long key;
        UUID id;
        if (level != null && pos != null && !level.isClientSide() && (id = (UUID)map.getOrDefault(key = TableLockManager.makeKey(level, pos), null)) != null && (player = level.getPlayerByUUID(id)) != null) {
            return player.getDisplayName();
        }
        return Component.literal((String)"--");
    }

    @SubscribeEvent
    public static void onOpenGUI(PlayerContainerEvent.Open event) {
        if (event.getContainer() instanceof SimpleTableMenu) {
            int containerId = event.getContainer().containerId;
            protoMap.put(containerId, event.getEntity().getUUID());
            if (indexMap.containsKey(containerId)) {
                Long key = indexMap.get(containerId);
                map.put(key, event.getEntity().getUUID());
            }
        }
    }

    @SubscribeEvent
    public static void onCloseGUI(PlayerContainerEvent.Close event) {
        if (event.getContainer() instanceof SimpleTableMenu && indexMap.containsKey(event.getContainer().containerId)) {
            long key = indexMap.get(event.getContainer().containerId);
            indexMap.remove(event.getContainer().containerId);
            map.remove(key);
            protoMap.remove(event.getContainer().containerId);
        }
    }
}

