/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import moonfather.workshop_for_handsome_adventurer.OptionsHolder;
import moonfather.workshop_for_handsome_adventurer.block_entities.DualTableBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import moonfather.workshop_for_handsome_adventurer.blocks.DualTableBaseBlock;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.integration.PolymorphAccessorClient;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;

public class DualTableMenu
extends SimpleTableMenu {
    public static final int CRAFT_SECONDARY_SLOT_START = 136;
    public static final int CRAFT_SECONDARY_SLOT_END = 144;
    public static final int SECONDARY_RESULT_SLOT = 145;
    private final CraftingContainer craftSlotsSecondary = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer resultSlotsSecondary = new ResultContainer();

    public DualTableMenu(int containerId, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(containerId, inventory, ContainerLevelAccess.f_39287_, (MenuType)Registration.CRAFTING_DUAL_MENU_TYPE.get());
    }

    public DualTableMenu(int containerId, Inventory inventory, ContainerLevelAccess levelAccess, @Nullable MenuType<?> menuType) {
        super(containerId, inventory, levelAccess, menuType);
        int k;
        this.initialLoading = true;
        this.DataSlots.setSlotValue(5, 1);
        this.access.m_39292_(this::loadFromWorldPartTwo);
        for (int ver = 0; ver < 3; ++ver) {
            for (int hor = 0; hor < 3; ++hor) {
                this.m_38897_(new Slot((Container)this.craftSlotsSecondary, hor + ver * 3, 26 + hor * 18, -33 + ver * 18));
            }
        }
        this.m_38897_((Slot)new ResultSlot(inventory.f_35978_, this.craftSlotsSecondary, (Container)this.resultSlotsSecondary, 0, 120, 53));
        int y0 = 0;
        for (k = 10; k <= 45; ++k) {
            Slot current = (Slot)this.f_38839_.get(k);
            current.f_40221_ += 67;
        }
        for (k = 46; k <= 49; ++k) {
            Slot current = (Slot)this.f_38839_.get(k);
            ((SimpleTableMenu.CustomizationSlot)current).setAcceptsLanterns(true);
            if (k == 46) {
                y0 = current.f_40221_ - 9;
            }
            if (k - 46 >= this.getCustomizationSlotCount()) continue;
            current.f_40221_ = y0 + (k - 46) * 22;
        }
        for (k = 136; k <= 144; ++k) {
            Slot primary = (Slot)this.f_38839_.get(k - 136 + 1);
            Slot current = (Slot)this.f_38839_.get(k);
            current.f_40221_ = primary.f_40221_;
            primary.f_40221_ = primary.f_40221_ + 54 + 13;
        }
        Slot primary = (Slot)this.f_38839_.get(0);
        ((Slot)this.f_38839_.get((int)145)).f_40221_ = primary.f_40221_;
        primary.f_40221_ = primary.f_40221_ + 54 + 13;
        this.initialLoading = false;
    }

    @Override
    public int getCustomizationSlotCount() {
        return (Integer)OptionsHolder.COMMON.DualTableNumberOfSlots.get();
    }

    @Override
    public void m_6199_(Container container) {
        if (container.equals(this.craftSlots)) {
            this.setActiveResultSlotForPolymorph(1);
            this.access.m_39292_((level, pos) -> DualTableMenu.slotChangedCraftingGrid(this, level, pos, this.player, this.craftSlots, this.resultSlots, 0));
        } else if (container.equals(this.craftSlotsSecondary)) {
            this.setActiveResultSlotForPolymorph(2);
            this.access.m_39292_((level, pos) -> DualTableMenu.slotChangedCraftingGrid(this, level, pos, this.player, this.craftSlotsSecondary, this.resultSlotsSecondary, 145));
        }
    }

    @Override
    public void handleCraftingUpdateRequest(int resultSlotIndex) {
        this.m_6199_((Container)(resultSlotIndex != 145 ? this.craftSlots : this.craftSlotsSecondary));
    }

    public int getRecipeTargetGrid() {
        return this.DataSlots.getSlotValue(5);
    }

    public void registerClientHandlerForRecipeTargetChange(Consumer<Integer> eventForJEI) {
        this.DataSlots.registerClientHandlerForDataSlot(5, eventForJEI);
        this.DataSlots.registerClientHandlerForDataSlot(6, this::recipeTargetChangeHandler);
    }

    public void changeRecipeTargetGridTo(int grid) {
        if (grid >= 1 && grid <= 2) {
            this.DataSlots.setSlotValue(5, grid);
            this.m_150440_(5, grid);
        }
    }

    private void recipeTargetChangeHandler(Integer value) {
        if (ModList.get().isLoaded("polymorph")) {
            Slot slot = this.m_38853_(0);
            if (value == 2) {
                slot = this.m_38853_(145);
            }
            PolymorphAccessorClient.setTargetSlot(slot);
        }
    }

    @Override
    protected void clearAdditional() {
        this.m_150411_(this.player, (Container)this.craftSlotsSecondary);
    }

    @Override
    public boolean m_6875_(Player player) {
        return (Boolean)this.access.m_39299_((level, pos) -> {
            if (!(level.m_8055_(pos).m_60734_() instanceof DualTableBaseBlock)) {
                return false;
            }
            return player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0;
        }, (Object)true);
    }

    @Override
    protected boolean isSlotACraftingResultSlot(int index) {
        return index == 0 || index == 145;
    }

    @Override
    protected boolean isSlotACraftingGridSlot(int index) {
        return index >= 1 && index <= 9 || index >= 136 && index <= 144;
    }

    @Override
    protected boolean moveItemStackToCraftingGrid(ItemStack itemstack1) {
        return this.moveItemStackToOccupiedSlotsOnly(itemstack1, 1, 10, false) || this.moveItemStackToOccupiedSlotsOnly(itemstack1, 136, 145, false);
    }

    @Override
    public boolean m_5882_(ItemStack p_39381_, Slot slot) {
        return slot.f_40218_ != this.resultSlotsSecondary && super.m_5882_(p_39381_, slot);
    }

    @Override
    protected int getSlotOffsetInDataStorage(Container container) {
        if (container.equals(this.craftSlots)) {
            return 0;
        }
        if (container.equals(this.craftSlotsSecondary)) {
            return 13;
        }
        return 101;
    }

    protected void loadFromWorldPartTwo(Level level, BlockPos pos) {
        DualTableBlockEntity be = (DualTableBlockEntity)level.m_7702_(pos);
        assert (be != null);
        for (int i = 0; i < this.craftSlotsSecondary.m_6643_(); ++i) {
            this.craftSlotsSecondary.m_6836_(i, be.GetItem(this.getSlotOffsetInDataStorage((Container)this.craftSlotsSecondary) + i));
        }
        this.craftSlotsSecondary.m_6596_();
        this.changeRecipeTargetGridTo(be.GetIntegerData(0));
    }

    @Override
    protected void storeDataValues(Level level, BlockPos pos) {
        DualTableBlockEntity be = (DualTableBlockEntity)level.m_7702_(pos);
        if (be != null) {
            be.StoreIntegerData(0, this.getRecipeTargetGrid());
        }
    }

    public static class DataSlotWithNotification
    extends DataSlot {
        private int value = 0;
        private Consumer<Integer> event = null;

        public DataSlotWithNotification(int startingValue) {
            this.value = startingValue;
        }

        public int m_6501_() {
            return this.value;
        }

        public void m_6422_(int v) {
            this.value = v;
            if (this.event != null) {
                this.event.accept(v);
            }
        }

        public void setEvent(Consumer<Integer> newEvent) {
            this.event = newEvent;
        }
    }
}

