/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.messaging;

import java.util.Optional;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.ChestRenameMessage;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.ClientRequestMessage;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.CraftingUpdateRequestMessage;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.GridChangeMessage;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.PacketHandler;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.TabChangeMessage;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketSender {
    private static final String PROTOCOL_VERSION = "wfha1";
    private static final SimpleChannel CHANNEL_INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("workshop_for_handsome_adventurer", "main"), () -> "wfha1", "wfha1"::equals, "wfha1"::equals);
    private static int discriminator = 123;

    public static void sendTabChangeToServer(int newTab) {
        TabChangeMessage message = new TabChangeMessage(newTab);
        CHANNEL_INSTANCE.sendToServer((Object)message);
    }

    public static void sendDestinationGridChangeToServer(int newDestination) {
        GridChangeMessage message = new GridChangeMessage(newDestination);
        CHANNEL_INSTANCE.sendToServer((Object)message);
    }

    public static void sendRemoteUpdateRequestToServer() {
        ClientRequestMessage message = new ClientRequestMessage(5);
        CHANNEL_INSTANCE.sendToServer((Object)message);
    }

    public static void sendRenameRequestToServer(String newName) {
        ChestRenameMessage message = new ChestRenameMessage(newName);
        CHANNEL_INSTANCE.sendToServer((Object)message);
    }

    public static void sendCraftingResultUpdateRequestToServer(int slotIndex) {
        CraftingUpdateRequestMessage message = new CraftingUpdateRequestMessage(slotIndex);
        CHANNEL_INSTANCE.sendToServer((Object)message);
    }

    public static void registerMessage() {
        CHANNEL_INSTANCE.registerMessage(discriminator++, TabChangeMessage.class, TabChangeMessage::encode, TabChangeMessage::decode, PacketHandler::handleTabChange, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL_INSTANCE.registerMessage(discriminator++, GridChangeMessage.class, GridChangeMessage::encode, GridChangeMessage::decode, PacketHandler::handleGridChange, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL_INSTANCE.registerMessage(discriminator++, ChestRenameMessage.class, ChestRenameMessage::encode, ChestRenameMessage::decode, PacketHandler::handleChestRename, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL_INSTANCE.registerMessage(discriminator++, ClientRequestMessage.class, ClientRequestMessage::encode, ClientRequestMessage::decode, PacketHandler::handleClientRequest, Optional.of(NetworkDirection.PLAY_TO_SERVER));
        CHANNEL_INSTANCE.registerMessage(discriminator++, CraftingUpdateRequestMessage.class, CraftingUpdateRequestMessage::encode, CraftingUpdateRequestMessage::decode, PacketHandler::handleCraftingUpdateRequest, Optional.of(NetworkDirection.PLAY_TO_SERVER));
    }
}

