/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.blocks;

import moonfather.workshop_for_handsome_adventurer.Constants;
import moonfather.workshop_for_handsome_adventurer.block_entities.BookShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class BookShelf
extends ToolRack {
    private static final int INITIAL_BOOK_COUNT = 12;
    private final MutableComponent NotABookMessage = Component.m_237115_((String)"message.workshop_for_handsome_adventurer.invalid_item_for_book_shelf");
    public static final BooleanProperty[] SLOT_OCCUPIED = new BooleanProperty[20];

    public BookShelf(String subType) {
        super(12, "book_shelf", subType);
        this.registedDefaultState();
    }

    public BookShelf(String subType, BlockBehaviour.Properties properties) {
        super(12, "book_shelf", subType, properties);
        this.registedDefaultState();
    }

    protected int numberOfBooksInARow() {
        return 4;
    }

    protected int numberOfRows() {
        return 2;
    }

    protected boolean singleRowIsTop() {
        return true;
    }

    public static int getBookShelfSlot(BookShelf block, BlockHitResult blockHitResult) {
        return block.getTargetedSlot(blockHitResult);
    }

    @Override
    protected int getTargetedSlot(BlockHitResult blockHitResult) {
        int aboveThisRow;
        double frac = blockHitResult.m_82450_().f_82480_ - (double)blockHitResult.m_82425_().m_123342_();
        if (this.numberOfRows() == 2) {
            aboveThisRow = frac >= 0.5 ? 0 : this.numberOfBooksInARow();
        } else {
            aboveThisRow = 0;
            if (frac > 0.5 && !this.singleRowIsTop() || frac < 0.5 && this.singleRowIsTop()) {
                return -1;
            }
        }
        int integral = (int)blockHitResult.m_82450_().f_82481_;
        frac = (blockHitResult.m_82450_().f_82481_ - (double)integral) * (double)blockHitResult.m_82434_().m_122429_();
        integral = (int)blockHitResult.m_82450_().f_82479_;
        frac -= (blockHitResult.m_82450_().f_82479_ - (double)integral) * (double)blockHitResult.m_82434_().m_122431_();
        while (frac < 0.0) {
            frac += 1.0;
        }
        while (frac > 1.0) {
            frac -= 1.0;
        }
        int horizontal = this.numberOfBooksInARow() - 1 - (int)Math.floor(frac * (double)this.numberOfBooksInARow());
        return aboveThisRow + horizontal;
    }

    @Override
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        int slot = this.getTargetedSlot(blockHitResult);
        if (slot >= this.itemCount) {
            slot -= this.itemCount;
        }
        if (slot == -1) {
            return InteractionResult.CONSUME;
        }
        BookShelfBlockEntity BE = (BookShelfBlockEntity)level.m_7702_(pos);
        ItemStack existing = BE.GetItem(slot);
        ItemStack itemInMainHand = player.m_21205_();
        ItemStack itemInOffHand = player.m_21206_();
        if (existing.m_41619_()) {
            if (this.canDepositItem(itemInMainHand)) {
                BookShelf.doPlaceBookOntoShelf(player, itemInMainHand, slot, BE, level, pos, blockState);
            } else if (this.canDepositItem(itemInOffHand)) {
                BookShelf.doPlaceBookOntoShelf(player, itemInOffHand, slot, BE, level, pos, blockState);
            } else if (!itemInMainHand.m_41619_() || !itemInOffHand.m_41619_()) {
                player.m_5661_((Component)this.NotABookMessage, true);
            }
        } else if (!existing.m_41619_() && itemInMainHand.m_41619_()) {
            BookShelf.doPickBookFromShelf(player, InteractionHand.MAIN_HAND, existing, slot, BE, level, pos, blockState);
        } else if (!existing.m_41619_() && !itemInMainHand.m_41619_() && itemInOffHand.m_41619_()) {
            BookShelf.doPickBookFromShelf(player, InteractionHand.OFF_HAND, existing, slot, BE, level, pos, blockState);
        }
        return InteractionResult.CONSUME;
    }

    private static void doPickBookFromShelf(Player player, InteractionHand hand, ItemStack bookInShelfSlot, int slot, BookShelfBlockEntity BE, Level level, BlockPos pos, BlockState blockState) {
        player.m_21008_(hand, bookInShelfSlot);
        BE.ClearItem(slot);
        player.m_5496_(SoundEvents.f_12019_, 0.5f, 1.0f);
        level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)BookShelf.getSlotProperty(slot), (Comparable)Boolean.valueOf(false)));
    }

    private static void doPlaceBookOntoShelf(Player player, ItemStack itemToStore, int slot, BookShelfBlockEntity BE, Level level, BlockPos pos, BlockState blockState) {
        ItemStack toStore = itemToStore.m_41777_();
        toStore.m_41764_(1);
        BE.DepositItem(slot, toStore);
        itemToStore.m_41774_(1);
        player.m_5496_(SoundEvents.f_11714_, 0.5f, 0.7f);
        level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)BookShelf.getSlotProperty(slot), (Comparable)Boolean.valueOf(true)));
    }

    @Override
    protected boolean canDepositItem(ItemStack mainHandItem) {
        return mainHandItem.m_204117_(ItemTags.f_244646_) || mainHandItem.m_204117_(Constants.Tags.FORGE_BOOKS);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState blockState) {
        BookShelfBlockEntity BE = (BookShelfBlockEntity)((BlockEntityType)Registration.BOOK_SHELF_BE.get()).m_155264_(pos, blockState);
        BE.setCapacity(this.getBookCapacity());
        return BE;
    }

    private int getBookCount() {
        return this.numberOfRows() * this.numberOfBooksInARow();
    }

    private int getBookCapacity() {
        return Math.max(this.numberOfRows() * this.numberOfBooksInARow(), 8);
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 20;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        if (SLOT_OCCUPIED[0] == null) {
            int slot_count = this.getBookCapacity();
            for (int i = 0; i < slot_count; ++i) {
                BookShelf.SLOT_OCCUPIED[i] = BooleanProperty.m_61465_((String)("slot_" + i + "_occupied"));
            }
        }
        for (int i = 0; i < this.getBookCount(); ++i) {
            builder.m_61104_(new Property[]{SLOT_OCCUPIED[i]});
        }
    }

    private static BooleanProperty getSlotProperty(int slot) {
        return SLOT_OCCUPIED[slot];
    }

    private void registedDefaultState() {
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH);
        for (int i = 0; i < this.getBookCount(); ++i) {
            state = (BlockState)state.m_61124_((Property)BookShelf.getSlotProperty(i), (Comparable)Boolean.valueOf(false));
        }
        this.m_49959_(state);
    }

    public static class TopWithLanterns
    extends BookShelf {
        public static final BooleanProperty LIGHTS_ON = BooleanProperty.m_61465_((String)"is_lit");
        private static final VoxelShape SHAPE_FRAME1N = Block.m_49796_((double)0.0, (double)7.5, (double)0.0, (double)16.0, (double)16.0, (double)7.0);
        private static final VoxelShape SHAPE_FRAME1E = Block.m_49796_((double)9.0, (double)7.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        private static final VoxelShape SHAPE_FRAME1S = Block.m_49796_((double)0.0, (double)7.5, (double)9.0, (double)16.0, (double)16.0, (double)16.0);
        private static final VoxelShape SHAPE_FRAME1W = Block.m_49796_((double)0.0, (double)7.5, (double)0.0, (double)7.0, (double)16.0, (double)16.0);
        private static final VoxelShape SHAPE_LAMPS1N = Block.m_49796_((double)2.5, (double)3.0, (double)0.0, (double)13.5, (double)7.5, (double)4.0);
        private static final VoxelShape SHAPE_LAMPS1E = Block.m_49796_((double)12.0, (double)3.0, (double)2.5, (double)16.0, (double)7.5, (double)13.5);
        private static final VoxelShape SHAPE_LAMPS1S = Block.m_49796_((double)2.5, (double)3.0, (double)12.0, (double)13.5, (double)7.5, (double)16.0);
        private static final VoxelShape SHAPE_LAMPS1W = Block.m_49796_((double)0.0, (double)3.0, (double)2.5, (double)4.0, (double)7.5, (double)13.5);

        public TopWithLanterns(String type) {
            super(type, BlockBehaviour.Properties.m_284310_().m_60913_(2.0f, 3.0f).m_60918_(SoundType.f_56736_).m_278183_().m_284180_(MapColor.f_283748_).m_278166_(PushReaction.DESTROY).m_60953_(TopWithLanterns::getLightLevel));
        }

        private static int getLightLevel(BlockState state) {
            return (Boolean)state.m_61143_((Property)LIGHTS_ON) != false ? 12 : 0;
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
            builder.m_61104_(new Property[]{LIGHTS_ON});
        }

        @Override
        protected int numberOfRows() {
            return 1;
        }

        @Override
        protected void PrepareListOfShapes() {
            this.shapes.clear();
            this.shapes.put(Direction.NORTH, Shapes.m_83110_((VoxelShape)SHAPE_FRAME1N, (VoxelShape)SHAPE_LAMPS1N));
            this.shapes.put(Direction.EAST, Shapes.m_83110_((VoxelShape)SHAPE_FRAME1E, (VoxelShape)SHAPE_LAMPS1E));
            this.shapes.put(Direction.SOUTH, Shapes.m_83110_((VoxelShape)SHAPE_FRAME1S, (VoxelShape)SHAPE_LAMPS1S));
            this.shapes.put(Direction.WEST, Shapes.m_83110_((VoxelShape)SHAPE_FRAME1W, (VoxelShape)SHAPE_LAMPS1W));
        }

        @Override
        public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockHitResult) {
            if (hand == InteractionHand.OFF_HAND) {
                return InteractionResult.PASS;
            }
            if (level.f_46443_) {
                return InteractionResult.SUCCESS;
            }
            int slot = this.getTargetedSlot(blockHitResult);
            if (slot == -1) {
                level.m_46597_(pos, (BlockState)blockState.m_61124_((Property)LIGHTS_ON, (Comparable)Boolean.valueOf((Boolean)blockState.m_61143_((Property)LIGHTS_ON) == false)));
                return InteractionResult.CONSUME;
            }
            return super.m_6227_(blockState, level, pos, player, hand, blockHitResult);
        }
    }

    public static class TopSimple
    extends BookShelf {
        private static final VoxelShape SHAPE_FRAME1N = Block.m_49796_((double)0.0, (double)7.5, (double)0.0, (double)16.0, (double)16.0, (double)7.0);
        private static final VoxelShape SHAPE_FRAME1E = Block.m_49796_((double)9.0, (double)7.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
        private static final VoxelShape SHAPE_FRAME1S = Block.m_49796_((double)0.0, (double)7.5, (double)9.0, (double)16.0, (double)16.0, (double)16.0);
        private static final VoxelShape SHAPE_FRAME1W = Block.m_49796_((double)0.0, (double)7.5, (double)0.0, (double)7.0, (double)16.0, (double)16.0);

        public TopSimple(String type) {
            super(type);
        }

        @Override
        protected int numberOfRows() {
            return 1;
        }

        @Override
        protected void PrepareListOfShapes() {
            this.shapes.clear();
            this.shapes.put(Direction.NORTH, SHAPE_FRAME1N);
            this.shapes.put(Direction.EAST, SHAPE_FRAME1E);
            this.shapes.put(Direction.SOUTH, SHAPE_FRAME1S);
            this.shapes.put(Direction.WEST, SHAPE_FRAME1W);
        }
    }

    public static class Dual
    extends BookShelf {
        private static final VoxelShape SHAPE_FRAME1N = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.99, (double)7.0);
        private static final VoxelShape SHAPE_FRAME1E = Block.m_49796_((double)9.0, (double)0.0, (double)0.0, (double)16.0, (double)15.99, (double)16.0);
        private static final VoxelShape SHAPE_FRAME1S = Block.m_49796_((double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)15.99, (double)16.0);
        private static final VoxelShape SHAPE_FRAME1W = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)7.0, (double)15.99, (double)16.0);

        public Dual(String type) {
            super(type);
        }

        @Override
        protected void PrepareListOfShapes() {
            this.shapes.clear();
            this.shapes.put(Direction.NORTH, SHAPE_FRAME1N);
            this.shapes.put(Direction.EAST, SHAPE_FRAME1E);
            this.shapes.put(Direction.SOUTH, SHAPE_FRAME1S);
            this.shapes.put(Direction.WEST, SHAPE_FRAME1W);
        }
    }
}

