/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.dynamic_resources;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.CustomTripletSupport;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.SecondCreativeTab;
import net.minecraftforge.fml.loading.FMLConfig;

public class DynamicAssetConfig {
    private static InstantConfigServer common = null;
    private static InstantConfigClient client = null;
    private static final Map<String, String> plankPathList = new HashMap<String, String>();
    private static final Map<String, String> subRecipeList = new HashMap<String, String>();
    private static final Map<String, String> subTextureList = new HashMap<String, String>();
    private static final Map<String, String> logPathList = new HashMap<String, String>();
    private static List<String> blackList = null;
    private static final Collection<WoodSet> woodSetsWithDumbassNames = new ArrayList<WoodSet>();

    public static boolean separateCreativeTab() {
        return SecondCreativeTab.items_table1.size() >= DynamicAssetConfig.getClient().minimum_number_of_sets_for_separate_creative_tab;
    }

    public static boolean masterLeverOn() {
        return DynamicAssetConfig.getCommon().generate_blocks_for_mod_added_woods;
    }

    public static boolean autoSearchEnabled() {
        return !DynamicAssetConfig.getClient().disable_autosearching_for_textures.equals("true") && !DynamicAssetConfig.getClient().disable_autosearching_for_textures.equals("yes");
    }

    private static InstantConfigServer getCommon() {
        if (common == null) {
            Gson gson2;
            Path configPath = Path.of(FMLConfig.defaultConfigPath(), "../config", "workshop_for_handsome_adventurer-special-common.json");
            boolean readingFailed = false;
            if (configPath.toFile().exists()) {
                try {
                    gson2 = new Gson();
                    common = (InstantConfigServer)gson2.fromJson(Files.readString(configPath), InstantConfigServer.class);
                }
                catch (IOException gson2) {
                    // empty catch block
                }
            }
            if (common == null) {
                common = new InstantConfigServer();
            }
            if (readingFailed || !configPath.toFile().exists()) {
                try {
                    gson2 = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                    String text = gson2.toJson((Object)common, InstantConfigServer.class);
                    Files.writeString(configPath, (CharSequence)text, StandardCharsets.US_ASCII, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                }
                catch (IOException e) {
                    boolean bl = true;
                }
            }
        }
        return common;
    }

    private static InstantConfigClient getClient() {
        if (client == null) {
            Gson gson;
            Path configPath = Path.of(FMLConfig.defaultConfigPath(), "..", "config", "workshop_for_handsome_adventurer-special-client.json");
            boolean readingFailed = false;
            if (configPath.toFile().exists()) {
                try {
                    gson = new Gson();
                    client = (InstantConfigClient)gson.fromJson(Files.readString(configPath), InstantConfigClient.class);
                }
                catch (IOException e) {
                    readingFailed = true;
                }
            }
            if (client == null) {
                client = new InstantConfigClient();
            }
            if (readingFailed || !configPath.toFile().exists()) {
                try {
                    gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
                    String text = gson.toJson((Object)client, InstantConfigClient.class);
                    Files.writeString(configPath, (CharSequence)text, StandardCharsets.US_ASCII, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return client;
    }

    public static String getLogRecipeSubstitution(String wood) {
        Object input = subRecipeList.isEmpty() ? "crimson=minecraft:stripped_crimson_stem, warped=minecraft:stripped_warped_stem, " + DynamicAssetConfig.getCommon().stripped_log_substitution_list_for_recipes : "";
        return DynamicAssetConfig.getFromSplitConfig((String)input, subRecipeList, wood);
    }

    public static String getLogTexSubstitution(String wood) {
        return DynamicAssetConfig.getFromSplitConfig(DynamicAssetConfig.getClient().stripped_log_substitution_list_for_textures, subTextureList, wood);
    }

    public static String getPlankPath(String modId) {
        return DynamicAssetConfig.getFromSplitConfig(DynamicAssetConfig.getClient().texture_template1_list, plankPathList, modId);
    }

    public static String getLogPath(String modId) {
        return DynamicAssetConfig.getFromSplitConfig(DynamicAssetConfig.getClient().texture_template2_list, logPathList, modId);
    }

    public static boolean isUsingDarkerWorkstation(String wood) {
        return DynamicAssetConfig.getClient().use_darker_workstation_model.contains(wood);
    }

    public static boolean isBlackListed(String modId, String wood) {
        if (blackList == null) {
            blackList = Arrays.asList(DynamicAssetConfig.getCommon().blacklist.split(", *"));
        }
        return blackList.contains(modId + ":" + wood) || blackList.contains(modId + ":*");
    }

    private static String getFromSplitConfig(String input, Map<String, String> list, String wood) {
        if (list.isEmpty()) {
            String[] temp1;
            for (String s : temp1 = input.split(", *")) {
                String[] temp2 = s.split(" *= *");
                if (temp2.length != 2) continue;
                list.put(temp2[0], temp2[1]);
            }
        }
        return list.getOrDefault(wood, null);
    }

    public static Collection<WoodSet> getWoodSetsWithDumbassNames() {
        if (woodSetsWithDumbassNames.isEmpty()) {
            String[] temp1;
            for (String s : temp1 = DynamicAssetConfig.getCommon().blocks_with_dumbass_names.split(", *")) {
                String[] temp3;
                String[] temp2 = s.split(":");
                if (temp2.length != 2 || (temp3 = temp2[1].split("/")).length != 3) continue;
                woodSetsWithDumbassNames.add(new WoodSet(temp2[0], temp3[0], temp3[1], temp3[2]));
            }
        }
        return woodSetsWithDumbassNames;
    }

    public static WoodSet getWoodSet(String wood) {
        for (WoodSet set : woodSetsWithDumbassNames) {
            if (!CustomTripletSupport.addPrefixTo(set.planks).equals(wood)) continue;
            return set;
        }
        return null;
    }

    private static class InstantConfigClient {
        public String minimum_number_of_sets_comment = "How many wood sets are needed for this mod to use a second tab in creative mode for dynamically created blocks. Set to a high number to disable second tab and shove everything into first.";
        public int minimum_number_of_sets_for_separate_creative_tab = 4;
        public String disable_autosearching_for_textures_comment = "No reason to disable this. If you do, you need to set texture paths like in this file. While this is enabled, settings here that are texture paths are unused and unneeded.";
        public String disable_autosearching_for_textures = "false";
        public String stripped_log_substitution_comment = "For wood types that do not have stripped logs, you can specify table top block here. If you do not, we are skipping that wood type.";
        public String stripped_log_substitution_list_for_textures = "embur=embur, sythian=sythian, bamboo=stripped_bamboo_block, bulbis=bulbis,  edelwood=edelwood";
        public String texture_template1_comment = "Tells us where to find plank textures, in case mod uses subdirectories (like byg) or different file names. Second %s below is the wood type. Separate using commas.";
        public String texture_template1_list = "byg=%s:block/%s/planks, aether=%s:block/construction/%s_planks";
        public String texture_template2_comment = "Tells us where to find stripped log textures, in case mod uses subdirectories (like byg) or different file names. Second %s below is the wood type. Separate using commas.";
        public String texture_template2_list = "byg=%s:block/%s/stripped_log,  aether=%s:block/natural/stripped_%s_log";
        public String use_darker_workstation_comment = "Slightly different model. Do not worry about this. Or just list dark woods here.";
        public String use_darker_workstation_model = "embur,hellbark,bulbis,cika,lament,dead,blackwood";

        private InstantConfigClient() {
        }
    }

    private static class InstantConfigServer {
        public String generate_blocks_comment1 = "Unicorn-magic-powered system that automatically adds tables/racks/shelves for all wood types in the game (yes, modded ones too, that is the point of this system). If you turn this off (does not work? please report!), workshop blocks will only be added in vanilla wood types.";
        public String generate_blocks_comment2 = "Option requires game restart. Will synchronize it in future versions, for now users need to be careful.";
        public boolean generate_blocks_for_mod_added_woods = true;
        public String blacklist_comment = "First and obvious use is to blacklist wood types that you really, really hate to see. Second and non-obvious use: say you have a duplicate wood type; normally it just gets recipes that give blocks of other type of same name; but if you really, really wish to have blocks of this type, black-list them here so that they are not added to dupes list and in blocks_with_dumbass_names setting in this file, add them in format modid:planks/slab/strippedlog; good example is Vinery mod which insists on cherry wood even in 1.20; if you do this, you get workshop blocks in vanilla cherry (light pink) and Vinery's cherry (dark red) separately. Oh, and asterisk after the colon works.";
        public String blacklist = "vinery:cherry";
        public String stripped_log_substitution_comment = "For wood types that do not have stripped logs, you can specify table top block here. If you do not, we are skipping that wood type.";
        public String stripped_log_substitution_list_for_recipes = "bamboo=minecraft:smooth_stone, treated_wood_horizontal=minecraft:polished_blackstone,  embur=byg:stripped_embur_pedu,  sythian=byg:stripped_sythian_stem, bulbis=minecraft:smooth_stone, crimson=minecraft:stripped_crimson_stem, warped=minecraft:stripped_warped_stem,  edelwood=forbidden_arcanus:edelwood_planks";
        public String blocks_with_dumbass_names_comment = "This is a list of blocks that do not follow usual naming scheme. Set consists of planks, slab and log, separated by slashes. Separate all sets with comma. You can use stripped_log_substitution for these. Example is IE's treated wood as it has no logs.";
        public String blocks_with_dumbass_names = "immersiveengineering:treated_wood_horizontal/slab_treated_wood_horizontal/no_log_for_this_one, growthcraft_apples:apple_plank/apple_plank_slab/apple_wood_log_stripped,   growthcraft_cellar:cork_plank/cork_plank_slab/cork_wood_log_stripped,   vinery:cherry_planks/cherry_slab/stripped_cherry_log,   quark:azalea_planks/azalea_planks_slab/stripped_azalea_log";

        private InstantConfigServer() {
        }
    }

    public record WoodSet(String modId, String planks, String slab, String log) {
    }
}

