/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.integration;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import moonfather.workshop_for_handsome_adventurer.block_entities.ToolRackBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import moonfather.workshop_for_handsome_adventurer.integration.TetraCompatibleDualToolRack;
import moonfather.workshop_for_handsome_adventurer.integration.TetraCompatibleToolRack;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.common.ToolAction;
import se.mickelus.tetra.module.ItemUpgradeRegistry;
import se.mickelus.tetra.properties.IToolProvider;

public class TetraCompatibleToolRackHelper {
    public static ToolRack create(boolean dual, int itemCount, String subType) {
        if (dual) {
            return new TetraCompatibleDualToolRack(itemCount, subType);
        }
        return new TetraCompatibleToolRack(itemCount, subType);
    }

    public static ToolRack create(boolean dual, int itemCount, String mainType, String subType) {
        if (dual) {
            return new TetraCompatibleDualToolRack(itemCount, subType);
        }
        return new TetraCompatibleToolRack(itemCount, mainType, subType);
    }

    public static ToolRack create(boolean dual, int itemCount, String mainType, String subType, BlockBehaviour.Properties properties) {
        if (dual) {
            return new TetraCompatibleDualToolRack(itemCount, subType);
        }
        return new TetraCompatibleToolRack(itemCount, mainType, subType, properties);
    }

    public static Collection<ToolAction> getTools(Level world, BlockPos pos, int itemCount) {
        HashSet<ToolAction> result = new HashSet<ToolAction>();
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof ToolRackBlockEntity) {
            ToolRackBlockEntity be = (ToolRackBlockEntity)blockEntity;
            for (int slot = 0; slot < itemCount; ++slot) {
                Item item;
                ItemStack tool = be.GetItem(slot);
                if (tool.m_41619_()) continue;
                ItemStack replacement = ItemUpgradeRegistry.instance.getReplacement(tool);
                if (!replacement.m_41619_()) {
                    tool = replacement;
                }
                if (!((item = tool.m_41720_()) instanceof IToolProvider)) continue;
                IToolProvider tp = (IToolProvider)item;
                Map map = tp.getToolLevels(tool);
                for (Map.Entry entry : map.entrySet()) {
                    if ((Integer)entry.getValue() <= 0) continue;
                    result.add((ToolAction)entry.getKey());
                }
            }
        }
        return result;
    }

    public static int getToolLevel(Level world, BlockPos pos, int itemCount, ToolAction toolAction) {
        int result = -1;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof ToolRackBlockEntity) {
            ToolRackBlockEntity be = (ToolRackBlockEntity)blockEntity;
            for (int slot = 0; slot < itemCount; ++slot) {
                IToolProvider tp;
                Map map;
                int level;
                Item item;
                ItemStack tool = be.GetItem(slot);
                if (tool.m_41619_()) continue;
                ItemStack replacement = ItemUpgradeRegistry.instance.getReplacement(tool);
                if (!replacement.m_41619_()) {
                    tool = replacement;
                }
                if (!((item = tool.m_41720_()) instanceof IToolProvider) || (level = (map = (tp = (IToolProvider)item).getToolLevels(tool)).getOrDefault(toolAction, -1).intValue()) <= result) continue;
                result = level;
            }
        }
        return result;
    }

    public static ItemStack onCraftConsumeTool(Level world, BlockPos pos, int itemCount, ItemStack targetStack, Player player, ToolAction requiredTool, int requiredLevel, boolean consumeResources) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof ToolRackBlockEntity) {
            ToolRackBlockEntity be = (ToolRackBlockEntity)blockEntity;
            for (int slot = 0; slot < itemCount; ++slot) {
                IToolProvider tp;
                Map map;
                int level;
                Item item;
                ItemStack tool = be.GetItem(slot);
                if (tool.m_41619_()) continue;
                ItemStack replacement = ItemUpgradeRegistry.instance.getReplacement(tool);
                if (!replacement.m_41619_()) {
                    tool = replacement;
                }
                if (!((item = tool.m_41720_()) instanceof IToolProvider) || (level = (map = (tp = (IToolProvider)item).getToolLevels(tool)).getOrDefault(requiredTool, -1).intValue()) < requiredLevel) continue;
                return ((IToolProvider)tool.m_41720_()).onCraftConsume(tool, targetStack, player, requiredTool, requiredLevel, consumeResources);
            }
        }
        return null;
    }

    public static ItemStack onActionConsumeTool(Level world, BlockPos pos, int itemCount, ItemStack targetStack, Player player, ToolAction requiredTool, int requiredLevel, boolean consumeResources) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof ToolRackBlockEntity) {
            ToolRackBlockEntity be = (ToolRackBlockEntity)blockEntity;
            for (int slot = 0; slot < itemCount; ++slot) {
                IToolProvider tp;
                Map map;
                int level;
                Item item;
                ItemStack tool = be.GetItem(slot);
                if (tool.m_41619_()) continue;
                ItemStack replacement = ItemUpgradeRegistry.instance.getReplacement(tool);
                if (!replacement.m_41619_()) {
                    tool = replacement;
                }
                if (!((item = tool.m_41720_()) instanceof IToolProvider) || (level = (map = (tp = (IToolProvider)item).getToolLevels(tool)).getOrDefault(requiredTool, -1).intValue()) < requiredLevel) continue;
                return ((IToolProvider)tool.m_41720_()).onActionConsume(tool, targetStack, player, requiredTool, requiredLevel, consumeResources);
            }
        }
        return null;
    }
}

