/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items;

import java.util.List;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomPrimary;
import moonfather.workshop_for_handsome_adventurer.initialization.ExternalWoodSupport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class WorkstationPlacerItem
extends Item {
    private final String woodType;
    private final MutableComponent Tooltip1 = Component.m_237115_((String)"item.workshop_for_handsome_adventurer.workstation_placer.tooltip1").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9966CC));
    private final MutableComponent Tooltip2 = Component.m_237115_((String)"item.workshop_for_handsome_adventurer.workstation_placer.tooltip2").m_130948_(Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_178520_(0x9966CC));

    public WorkstationPlacerItem(String wood, Item.Properties properties) {
        super(properties);
        this.woodType = wood;
    }

    public WorkstationPlacerItem(String wood) {
        this(wood, new Item.Properties().m_41487_(1));
    }

    public void m_7373_(ItemStack itemStack, @Nullable Level level, List<Component> list, TooltipFlag advanced) {
        super.m_7373_(itemStack, level, list, advanced);
        list.add((Component)this.Tooltip1);
        list.add((Component)this.Tooltip2);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        if (context.m_43725_().f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos position = context.m_8083_().m_121945_(context.m_43719_());
        boolean canPlace = this.checkCanPlace(context.m_43725_(), position, context.m_8125_());
        if (!canPlace) {
            position = position.m_121945_(context.m_8125_().m_122428_());
            canPlace = this.checkCanPlace(context.m_43725_(), position, context.m_8125_());
        }
        if (!canPlace) {
            context.m_43723_().m_5661_((Component)Component.m_237115_((String)"message.workshop_for_handsome_adventurer.no_room_for_workstation"), true);
            return InteractionResult.FAIL;
        }
        Direction facingToSet = context.m_8125_().m_122424_();
        Direction right = context.m_8125_().m_122427_();
        String hostModId = ExternalWoodSupport.getHostMod(this.woodType);
        String prefix = ExternalWoodSupport.getPrefix(this.woodType);
        Block bottomLeft = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(hostModId, prefix + "dual_table_bottom_left_" + this.woodType));
        Block bottomRight = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(hostModId, prefix + "dual_table_bottom_right_" + this.woodType));
        Block topLeft = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(hostModId, prefix + "dual_table_top_left_" + this.woodType));
        Block topRight = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(hostModId, prefix + "dual_table_top_right_" + this.woodType));
        context.m_43725_().m_7731_(position, (BlockState)((BlockState)bottomLeft.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facingToSet)).m_61124_((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(true)), 0);
        context.m_43725_().m_7731_(position.m_7494_(), (BlockState)((BlockState)topLeft.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facingToSet)).m_61124_((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(true)), 0);
        context.m_43725_().m_7731_(position.m_121945_(right), (BlockState)((BlockState)bottomRight.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facingToSet)).m_61124_((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(true)), 0);
        context.m_43725_().m_7731_(position.m_7494_().m_121945_(right), (BlockState)((BlockState)topRight.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facingToSet)).m_61124_((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(true)), 0);
        context.m_43725_().m_46597_(position, (BlockState)((BlockState)bottomLeft.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facingToSet)).m_61124_((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(false)));
        context.m_43725_().m_46597_(position.m_7494_(), (BlockState)((BlockState)topLeft.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facingToSet)).m_61124_((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(false)));
        context.m_43725_().m_46597_(position.m_121945_(right), (BlockState)((BlockState)bottomRight.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facingToSet)).m_61124_((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(false)));
        context.m_43725_().m_46597_(position.m_7494_().m_121945_(right), (BlockState)((BlockState)topRight.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facingToSet)).m_61124_((Property)AdvancedTableBottomPrimary.BEING_PLACED, (Comparable)Boolean.valueOf(false)));
        if (!context.m_43723_().m_7500_()) {
            stack.m_41774_(1);
        }
        return InteractionResult.SUCCESS;
    }

    private boolean checkCanPlace(Level level, BlockPos position, Direction horizontalDirection) {
        BlockState current = level.m_8055_(position);
        if (!current.m_60795_() && !current.m_247087_()) {
            return false;
        }
        current = level.m_8055_(position.m_7494_());
        if (!current.m_60795_() && !current.m_247087_()) {
            return false;
        }
        current = level.m_8055_(position.m_121945_(horizontalDirection.m_122427_()));
        if (!current.m_60795_() && !current.m_247087_()) {
            return false;
        }
        current = level.m_8055_(position.m_7494_().m_121945_(horizontalDirection.m_122427_()));
        return current.m_60795_() || current.m_247087_();
    }
}

