/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.items.screens;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import moonfather.workshop_for_handsome_adventurer.OptionsHolder;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListMessageSender;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListMessaging;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.screens.TaskListEditBox;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.screens.TaskListPageButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;

public class TaskListScreen
extends Screen {
    private static final ResourceLocation BG_LOCATION = new ResourceLocation("workshop_for_handsome_adventurer", "textures/gui/gui_task_list_bg.png");
    private final int imageWidth = 179;
    private final int imageHeight = 209;
    protected int leftPos;
    protected int topPos;
    private int page;
    private String footer = null;
    private int topMarginMain = 24;
    private TaskListMessaging.TaskPageDTO initialContent;
    private final boolean isFireImmune;
    private final int pageCount;
    private final TaskListMessaging.TaskListExtraDTO extraOriginal;
    private final String itemName;
    private final List<TaskListMessaging.TaskPageDTO> pagesFromItem;
    private final List<EditBox> editBoxes = new ArrayList<EditBox>();
    private EditBox header;
    private final List<String> checkBoxValues = new ArrayList<String>(6);
    private final HashMap<String, ResourceLocation> checkBoxImages = new HashMap(4);
    private AbstractWidget arrowPrev1;
    private AbstractWidget arrowPrev2;
    private AbstractWidget arrowNext1;
    private AbstractWidget arrowNext2;
    private static final ResourceLocation VAN_BOOK = new ResourceLocation("textures/gui/book.png");
    private static final ResourceLocation CHECKBOX_EMPTY = new ResourceLocation("workshop_for_handsome_adventurer", "textures/gui/task_list_check1.png");
    private static final ResourceLocation CHECKBOX_DONE = new ResourceLocation("workshop_for_handsome_adventurer", "textures/gui/task_list_check2.png");
    private static final ResourceLocation CHECKBOX_MOPE = new ResourceLocation("workshop_for_handsome_adventurer", "textures/gui/task_list_check3.png");
    private static final ResourceLocation CHECKBOX_QMARK = new ResourceLocation("workshop_for_handsome_adventurer", "textures/gui/task_list_check4.png");
    private static final int NORMAL_TEXT_COLOR = 0x886666;
    private static final int DIM_TEXT_COLOR = 0xBBAAAA;
    private static final Component PAPER = Component.m_237115_((String)Items.f_42516_.m_5524_()).m_130948_(Style.f_131099_.m_178520_(0xFFDDAA));
    private static final Component PAPER_TOOLTIP = Component.m_237110_((String)"message.workshop_for_handsome_adventurer.task_list_ex", (Object[])new Object[]{PAPER});
    private static final Component CREAM = Component.m_237115_((String)Items.f_42542_.m_5524_()).m_130948_(Style.f_131099_.m_178520_(0xDDBB77));
    private static final Component CREAM_TOOLTIP = Component.m_237110_((String)"message.workshop_for_handsome_adventurer.task_list_cream", (Object[])new Object[]{CREAM});
    private static final List<Component> DUAL_TOOLTIP = new ArrayList<Component>(3);
    private static final Component KWYBOARD_TOOLTIP_RAW = Component.m_237115_((String)"message.workshop_for_handsome_adventurer.keyboard");
    private static final List<Component> KEYBOARD_TOOLTIP = new ArrayList<Component>(6);
    private int tooltipTicks = -1;
    private List<Component> currentTooltip = null;
    private final Random randomProvider = new Random();
    private int untapsToSkip = 5;
    private static final int K_ESC = 256;
    private static final int K_DN = 264;
    private static final int K_UP = 265;
    private static final int K_ENT = 257;
    private static final int K_ENT_NP = 335;
    private static final int K_PLU = 334;
    private static final int K_MIN = 333;
    private static final int K_STR = 332;
    private static final int K_PG_DN = 267;
    private static final int K_PG_UP = 266;

    public TaskListScreen(List<TaskListMessaging.TaskPageDTO> pagesFromItem, int pageCount, TaskListMessaging.TaskListExtraDTO extraInfo, boolean isFireImmune) {
        super((Component)Component.m_237113_((String)"task list"));
        this.extraOriginal = extraInfo;
        this.page = extraInfo.lastPage();
        this.pageCount = pageCount;
        this.initialContent = pagesFromItem.get(extraInfo.lastPage() - 1);
        this.pagesFromItem = pagesFromItem;
        this.itemName = extraInfo.itemName();
        this.isFireImmune = isFireImmune;
    }

    protected void m_7856_() {
        int i;
        this.leftPos = (this.f_96543_ - this.imageWidth) / 2;
        this.topPos = 0;
        if (this.editBoxes.size() == 0) {
            int y = this.topMarginMain = 42;
            int height = 12;
            for (int i2 = 0; i2 < 12; ++i2) {
                TaskListEditBox eb1 = new TaskListEditBox(Minecraft.m_91087_().f_91062_, 140, height, (Component)Component.m_237119_());
                eb1.m_94199_(22);
                eb1.m_94182_(false);
                eb1.m_94194_(true);
                eb1.m_94202_(0x886666);
                eb1.m_252865_(this.leftPos + 26);
                eb1.m_253211_(this.topPos + y);
                y += height - 1;
                this.editBoxes.add(eb1);
                this.f_169369_.add(eb1);
                if (i2 % 2 != 1) continue;
                y += 2;
            }
            this.header = new TaskListEditBox(Minecraft.m_91087_().f_91062_, 150, height, (Component)Component.m_237113_((String)"Item name"));
            this.header.m_94199_(32);
            this.header.m_94182_(false);
            this.header.m_94194_(true);
            this.header.m_94202_(0x555088);
            this.header.m_252865_(this.leftPos + 16);
            this.header.m_253211_(this.topPos + 16);
            this.f_169369_.add(this.header);
            this.header.m_94144_(this.itemName);
            int arrowHeight = 13;
            int arrowWidth = 23;
            int hmargin = 10;
            int vmargin = 10;
            MutableComponent buttonHint = Component.m_237113_((String)"paging");
            this.arrowPrev1 = new TaskListPageButton(0, 0, arrowWidth, arrowHeight, (Component)buttonHint, VAN_BOOK, 0, 206, 256, 256);
            this.arrowPrev1.m_264152_(this.leftPos + hmargin, this.topPos + this.imageHeight - arrowHeight - vmargin);
            this.arrowPrev2 = new TaskListPageButton(0, 0, arrowWidth, arrowHeight, (Component)buttonHint, VAN_BOOK, 23, 206, 256, 256);
            this.arrowPrev2.m_264152_(this.arrowPrev1.m_252754_(), this.arrowPrev1.m_252907_());
            this.arrowNext1 = new TaskListPageButton(0, 0, arrowWidth, arrowHeight, (Component)buttonHint, VAN_BOOK, 0, 193, 256, 256);
            this.arrowNext1.m_264152_(this.leftPos + this.imageWidth - arrowWidth - hmargin, this.topPos + this.imageHeight - arrowHeight - vmargin);
            this.arrowNext2 = new TaskListPageButton(0, 0, arrowWidth, arrowHeight, (Component)buttonHint, VAN_BOOK, 23, 193, 256, 256);
            this.arrowNext2.m_264152_(this.arrowNext1.m_252754_(), this.arrowNext1.m_252907_());
            this.m_169394_((Renderable)this.arrowPrev1);
            this.m_169394_((Renderable)this.arrowPrev2);
            this.m_169394_((Renderable)this.arrowNext1);
            this.m_169394_((Renderable)this.arrowNext2);
            this.setArrowVisibilityInitial();
            this.checkBoxImages.put("e", CHECKBOX_EMPTY);
            this.checkBoxImages.put("y", CHECKBOX_DONE);
            this.checkBoxImages.put("n", CHECKBOX_MOPE);
            this.checkBoxImages.put("q", CHECKBOX_QMARK);
        }
        for (i = 0; i < this.editBoxes.size(); ++i) {
            this.editBoxes.get(i).m_94144_(i % 2 == 0 ? this.initialContent.items().get(i / 2).line1() : this.initialContent.items().get(i / 2).line2());
        }
        this.checkBoxValues.clear();
        for (i = 0; i < this.editBoxes.size() / 2; ++i) {
            this.checkBoxValues.add(this.initialContent.items().get(i).status());
        }
        this.greyOutDoneAndAbandoned();
    }

    private void greyOutDoneAndAbandoned() {
        this.greyOutDoneAndAbandoned(false, 15);
    }

    private void greyOutDoneAndAbandoned(boolean oneItemOnly, int index) {
        if (((Boolean)OptionsHolder.CLIENT.TaskListColoringForFinishedItems.get()).booleanValue()) {
            int loopEnd;
            if (!oneItemOnly) {
                startIndex = 0;
                loopEnd = this.editBoxes.size();
            } else {
                startIndex = index * 2;
                loopEnd = startIndex + 2;
            }
            for (int i = startIndex; i < loopEnd; ++i) {
                String status = this.checkBoxValues.get(i / 2);
                if (status.equals("y") || status.equals("n")) {
                    this.editBoxes.get(i).m_94202_(0xBBAAAA);
                    continue;
                }
                this.editBoxes.get(i).m_94202_(0x886666);
            }
        }
    }

    private void setArrowVisibilityInitial() {
        this.arrowPrev1.f_93624_ = true;
        this.arrowNext1.f_93624_ = true;
        this.arrowPrev2.f_93624_ = false;
        this.arrowNext2.f_93624_ = false;
    }

    private void setArrowVisibilityOnHover(int mouseX, int mouseY) {
        boolean hover = mouseX >= this.arrowPrev1.m_252754_() && mouseX <= this.arrowPrev1.m_252754_() + this.arrowPrev1.m_5711_() && mouseY >= this.arrowPrev1.m_252907_() && mouseY <= this.arrowPrev1.m_252907_() + this.arrowPrev1.m_93694_();
        this.arrowPrev2.f_93624_ = this.page > 1 && hover;
        this.arrowPrev1.f_93624_ = !this.arrowPrev2.f_93624_;
        hover = mouseX >= this.arrowNext1.m_252754_() && mouseX <= this.arrowNext1.m_252754_() + this.arrowNext1.m_5711_() && mouseY >= this.arrowNext1.m_252907_() && mouseY <= this.arrowNext1.m_252907_() + this.arrowNext1.m_93694_();
        this.arrowNext2.f_93624_ = this.page < this.pageCount && hover;
        this.arrowNext1.f_93624_ = !this.arrowNext2.f_93624_;
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        boolean hover;
        boolean bl = hover = mouseX >= this.arrowNext1.m_252754_() && mouseX <= this.arrowNext1.m_252754_() + this.arrowNext1.m_5711_() && mouseY >= this.arrowNext1.m_252907_() && mouseY <= this.arrowNext1.m_252907_() + this.arrowNext1.m_93694_();
        if (!hover) {
            this.tooltipTicks = 400;
            this.currentTooltip = null;
            return;
        }
        if (this.tooltipTicks < 0) {
            return;
        }
        --this.tooltipTicks;
        if (this.currentTooltip == null) {
            if (DUAL_TOOLTIP.size() == 0) {
                DUAL_TOOLTIP.add(PAPER_TOOLTIP);
                DUAL_TOOLTIP.add((Component)Component.m_237113_((String)" "));
                DUAL_TOOLTIP.add(CREAM_TOOLTIP);
            }
            if (KEYBOARD_TOOLTIP.size() == 0) {
                boolean firstRow = true;
                for (String s : KWYBOARD_TOOLTIP_RAW.getString().split("<br>")) {
                    if (!firstRow) {
                        KEYBOARD_TOOLTIP.add((Component)Component.m_237113_((String)s));
                        continue;
                    }
                    KEYBOARD_TOOLTIP.add((Component)Component.m_237113_((String)s).m_130948_(Style.f_131099_.m_178520_(9811455)));
                    firstRow = false;
                }
            }
            int random = this.randomProvider.nextInt(5);
            if (this.page == this.pageCount && this.pageCount < 4) {
                this.currentTooltip = random == 0 && !this.isFireImmune ? DUAL_TOOLTIP : (random == 1 ? KEYBOARD_TOOLTIP : List.of(PAPER_TOOLTIP));
            }
            if (this.page == this.pageCount && this.pageCount == 4) {
                this.currentTooltip = random < 2 && !this.isFireImmune ? List.of(CREAM_TOOLTIP) : KEYBOARD_TOOLTIP;
            }
        }
        if (this.currentTooltip == null) {
            return;
        }
        guiGraphics.m_280677_(Minecraft.m_91087_().f_91062_, this.currentTooltip, Optional.empty(), mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean foundEditBox = false;
        for (int i = 0; i < this.editBoxes.size(); ++i) {
            if (!this.editBoxes.get(i).m_6375_(mouseX, mouseY, button)) continue;
            this.m_7522_((GuiEventListener)this.editBoxes.get(i));
            foundEditBox = true;
            break;
        }
        if (!foundEditBox && this.header.m_6375_(mouseX, mouseY, button)) {
            this.m_7522_((GuiEventListener)this.header);
            foundEditBox = true;
        }
        if (foundEditBox) {
            return true;
        }
        int y = this.topPos + this.topMarginMain + 3;
        int x = this.leftPos + 10;
        int size = 13;
        if (mouseX >= (double)(x - 1) && mouseX <= (double)(x + size + 1)) {
            for (int i = 0; i < this.checkBoxValues.size(); ++i) {
                if (mouseY >= (double)(y - 1) && mouseY <= (double)(y + size + 1)) {
                    String current = this.checkBoxValues.get(i);
                    if (current.equals("e")) {
                        this.checkBoxValues.set(i, "y");
                    } else if (current.equals("y")) {
                        this.checkBoxValues.set(i, "n");
                    } else if (current.equals("n")) {
                        this.checkBoxValues.set(i, "q");
                    } else if (current.equals("q")) {
                        this.checkBoxValues.set(i, "e");
                    }
                    this.greyOutDoneAndAbandoned(true, i);
                    break;
                }
                y = y + 12 + 12;
            }
        }
        if (mouseY >= (double)this.arrowNext1.m_252907_() && mouseY <= (double)(this.arrowNext1.m_252907_() + this.arrowNext1.m_93694_())) {
            int offset = 0;
            if (mouseX >= (double)this.arrowNext1.m_252754_() && mouseX <= (double)(this.arrowNext1.m_252754_() + this.arrowNext1.m_5711_()) && this.page < this.pageCount) {
                offset = 1;
            }
            if (mouseX >= (double)this.arrowPrev1.m_252754_() && mouseX <= (double)(this.arrowPrev1.m_252754_() + this.arrowPrev1.m_5711_()) && this.page > 1) {
                offset = -1;
            }
            if (offset != 0) {
                this.changePage(offset);
            }
        }
        return true;
    }

    private void changePage(int offset) {
        assert (offset * offset == 1);
        TaskListMessaging.TaskPageDTO finishedPage = this.makeDTO();
        TaskListMessageSender.sendTaskPageToServer(finishedPage, this.makeExtra());
        this.pagesFromItem.set(this.page - 1, finishedPage);
        this.footer = null;
        this.page += offset;
        this.initialContent = this.pagesFromItem.get(this.page - 1);
        this.m_7856_();
        this.tooltipTicks = -1;
    }

    private void checkByKeyboard(int keyCode) {
        for (int i = 0; i < this.editBoxes.size(); ++i) {
            if (!this.editBoxes.get(i).m_93696_()) continue;
            int index = i / 2;
            String current = this.checkBoxValues.get(index);
            String newValue = "e";
            if (keyCode == 334) {
                newValue = current.equals("y") ? "e" : "y";
            } else if (keyCode == 333) {
                newValue = current.equals("n") ? "e" : "n";
            } else if (keyCode == 332) {
                String string = newValue = current.equals("q") ? "e" : "q";
            }
            if (newValue.equals(current)) continue;
            this.checkBoxValues.set(index, newValue);
            this.greyOutDoneAndAbandoned(true, index);
        }
    }

    protected boolean hasClickedOutside(double mouseX, double mouseY, int guiLeft, int guiTop, int mouseButton) {
        return mouseX < (double)guiLeft || mouseY < (double)guiTop || mouseX >= (double)(guiLeft + this.imageWidth) || mouseY >= (double)(guiTop + this.imageHeight);
    }

    public final void m_86600_() {
        super.m_86600_();
        if (!this.f_96541_.f_91074_.m_6084_() || this.f_96541_.f_91074_.m_213877_()) {
            this.m_7379_();
        }
    }

    public void m_7379_() {
        TaskListMessageSender.sendTaskPageToServer(this.makeDTO(), this.makeExtra());
        this.f_96541_.f_91074_.m_6915_();
        super.m_7379_();
    }

    private TaskListMessaging.TaskPageDTO makeDTO() {
        TaskListMessaging.TaskPageDTO storedPage = new TaskListMessaging.TaskPageDTO(this.page, null);
        for (int i = 0; i < 6; ++i) {
            if (2 * i < this.editBoxes.size()) {
                storedPage.items().set(i, new TaskListMessaging.TaskItemDTO(this.checkBoxValues.get(i), this.editBoxes.get(2 * i).m_94155_(), this.editBoxes.get(2 * i + 1).m_94155_()));
                continue;
            }
            storedPage.items().set(i, TaskListMessaging.TaskItemDTO.empty());
        }
        return storedPage;
    }

    private TaskListMessaging.TaskListExtraDTO makeExtra() {
        return new TaskListMessaging.TaskListExtraDTO(this.extraOriginal, this.page, this.header.m_94155_());
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.untapsToSkip == 0) {
            this.setArrowVisibilityOnHover(mouseX, mouseY);
            this.untapsToSkip = 5;
        }
        --this.untapsToSkip;
        this.m_280273_(guiGraphics);
        for (Renderable renderable : this.f_169369_) {
            renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        int height = 12;
        for (int i = 0; i < 5; ++i) {
            guiGraphics.m_280656_(this.leftPos + 14, this.leftPos + this.imageWidth - 16, this.topPos + this.topMarginMain - 4 + (i + 1) * (height + height - 1 + 1), -8952218);
        }
        if (this.footer == null) {
            this.footer = String.format("%d/%d", this.page, this.pageCount);
        }
        guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, this.footer, this.leftPos + this.imageWidth / 2 - 12, this.topPos + this.imageHeight - 18, -8952218, false);
        int y = this.topPos + this.topMarginMain + 3;
        int x = this.leftPos + 10;
        int size = 13;
        for (int i = 0; i < this.checkBoxValues.size(); ++i) {
            guiGraphics.m_280411_(this.checkBoxImages.get(this.checkBoxValues.get(i)), x, y, size, size, 0.0f, 0.0f, size, size, 16, 16);
            y = y + 12 + 12;
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public void m_280273_(GuiGraphics guiGraphics) {
        super.m_280273_(guiGraphics);
        guiGraphics.m_280218_(BG_LOCATION, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && this.m_6913_()) {
            this.m_7379_();
            return true;
        }
        if ((keyCode == 264 || keyCode == 265) && (modifiers & 1) == 1) {
            this.m_7522_((GuiEventListener)this.header);
            return true;
        }
        if (keyCode == 264 || keyCode == 257 && (modifiers & 1) == 0 || keyCode == 335 && (modifiers & 1) == 0) {
            for (int i = 0; i < this.editBoxes.size(); ++i) {
                if (!this.editBoxes.get(i).equals(this.m_7222_())) continue;
                if (i < this.editBoxes.size() - 1) {
                    this.m_7522_((GuiEventListener)this.editBoxes.get(i + 1));
                } else {
                    this.m_7522_((GuiEventListener)this.editBoxes.get(0));
                }
                return true;
            }
            this.m_7522_((GuiEventListener)this.editBoxes.get(0));
            return true;
        }
        if (keyCode == 265 || keyCode == 257 && (modifiers & 1) == 1 || keyCode == 335 && (modifiers & 1) == 1) {
            for (int i = 0; i < this.editBoxes.size(); ++i) {
                if (!this.editBoxes.get(i).equals(this.m_7222_())) continue;
                if (i > 0) {
                    this.m_7522_((GuiEventListener)this.editBoxes.get(i - 1));
                } else {
                    this.m_7522_((GuiEventListener)this.editBoxes.get(this.editBoxes.size() - 1));
                }
                return true;
            }
            this.m_7522_((GuiEventListener)this.editBoxes.get(0));
            return true;
        }
        if ((keyCode == 334 || keyCode == 333 || keyCode == 332) && (modifiers & 1) == 0) {
            this.checkByKeyboard(keyCode);
            return true;
        }
        if (keyCode == 267 && this.page < this.pageCount) {
            this.changePage(1);
            return true;
        }
        if (keyCode == 266 && this.page > 1) {
            this.changePage(-1);
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7043_() {
        return (Boolean)OptionsHolder.CLIENT.TaskListPausesSingleplayer.get();
    }
}

