/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.other;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TableLockManager {
    private static final Map<Long, UUID> map = new HashMap<Long, UUID>();
    private static final Map<Integer, Long> indexMap = new HashMap<Integer, Long>();
    private static final Map<Integer, UUID> protoMap = new HashMap<Integer, UUID>();

    public static boolean isLocked(Level level, BlockPos pos) {
        if (level == null || pos == null) {
            return false;
        }
        Long key = TableLockManager.makeKey(level, pos);
        return map.getOrDefault(key, null) != null;
    }

    private static Long makeKey(Level level, BlockPos pos) {
        return Long.rotateLeft(level.hashCode(), 32) + (long)pos.hashCode();
    }

    public static void register(int containerId, Level level, BlockPos pos) {
        if (level == null || pos == null || level.m_5776_()) {
            return;
        }
        Long key = TableLockManager.makeKey(level, pos);
        indexMap.put(containerId, key);
        if (protoMap.containsKey(containerId)) {
            map.put(key, protoMap.get(containerId));
        }
    }

    public static Component getPlayerName(Level level, BlockPos pos) {
        Player player;
        Long key;
        UUID id;
        if (level != null && pos != null && !level.m_5776_() && (id = (UUID)map.getOrDefault(key = TableLockManager.makeKey(level, pos), null)) != null && (player = level.m_46003_(id)) != null) {
            return player.m_5446_();
        }
        return Component.m_237113_((String)"--");
    }

    @SubscribeEvent
    public static void onOpenGUI(PlayerContainerEvent.Open event) {
        if (event.getContainer() instanceof SimpleTableMenu) {
            int containerId = event.getContainer().f_38840_;
            protoMap.put(containerId, event.getEntity().m_20148_());
            if (indexMap.containsKey(containerId)) {
                Long key = indexMap.get(containerId);
                map.put(key, event.getEntity().m_20148_());
            }
        }
    }

    @SubscribeEvent
    public static void onCloseGUI(PlayerContainerEvent.Close event) {
        if (event.getContainer() instanceof SimpleTableMenu && indexMap.containsKey(event.getContainer().f_38840_)) {
            long key = indexMap.get(event.getContainer().f_38840_);
            indexMap.remove(event.getContainer().f_38840_);
            map.remove(key);
            protoMap.remove(event.getContainer().f_38840_);
        }
    }
}

