/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BaseContainerBlockEntity
extends BlockEntity {
    private final List<ItemStack> items = new ArrayList<ItemStack>(9);
    private int capacity = 9;

    public BaseContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int value) {
        if (value > this.capacity) {
            this.capacity = value;
        }
    }

    protected void VerifyCapacity() {
        for (int i = this.items.size(); i < this.capacity; ++i) {
            this.items.add(ItemStack.EMPTY);
        }
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(pTag, lookupProvider);
        this.VerifyCapacity();
        for (int i = 0; i < this.capacity; ++i) {
            CompoundTag tag = pTag.getCompound("item" + i);
            if (tag.contains("id")) {
                this.items.set(i, ItemStack.parseOptional((HolderLookup.Provider)lookupProvider, (CompoundTag)tag));
                continue;
            }
            this.items.set(i, ItemStack.EMPTY);
        }
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(pTag, lookupProvider);
        this.saveInternal(pTag, lookupProvider);
    }

    protected CompoundTag saveInternal(CompoundTag compoundTag, HolderLookup.Provider lookupProvider) {
        this.VerifyCapacity();
        for (int i = 0; i < this.capacity; ++i) {
            if (!this.items.get(i).isEmpty()) {
                compoundTag.put("item" + i, this.items.get(i).save(lookupProvider, (Tag)new CompoundTag()));
                continue;
            }
            compoundTag.put("item" + i, (Tag)new CompoundTag());
        }
        return compoundTag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadWithComponents(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveInternal(new CompoundTag(), lookupProvider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void DropAll() {
        this.VerifyCapacity();
        for (int i = 0; i < this.capacity; ++i) {
            Block.popResource((Level)this.level, (BlockPos)this.getBlockPos(), (ItemStack)this.items.get(i));
            this.ClearItem(i);
        }
    }

    public ItemStack GetItem(int slot) {
        this.VerifyCapacity();
        return this.items.get(slot);
    }

    public void DepositItem(int slot, ItemStack itemStack) {
        this.VerifyCapacity();
        this.items.set(slot, itemStack);
        this.setChanged();
    }

    public void ClearItem(int slot) {
        this.VerifyCapacity();
        this.items.set(slot, ItemStack.EMPTY);
        this.setChanged();
    }
}

