/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import moonfather.workshop_for_handsome_adventurer.CommonConfig;
import moonfather.workshop_for_handsome_adventurer.block_entities.BaseContainerBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.InventoryAccessHelper;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableBlockEntity;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableDataSlots;
import moonfather.workshop_for_handsome_adventurer.block_entities.containers.SimpleContainerEx;
import moonfather.workshop_for_handsome_adventurer.block_entities.containers.container_translators.BaseItemHandlerWrapper;
import moonfather.workshop_for_handsome_adventurer.block_entities.containers.container_translators.IExcessSlotManager;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.PacketSender;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomPrimary;
import moonfather.workshop_for_handsome_adventurer.blocks.SimpleTable;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.integration.PolymorphAccessorServer;
import moonfather.workshop_for_handsome_adventurer.other.TableLockManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.items.IItemHandler;

public class SimpleTableMenu
extends AbstractContainerMenu {
    public static final int CUST_CONTAINER_SIZE = 4;
    public static final int TAB_SMUGGLING_CONTAINER_SIZE = 32;
    public static final int TAB_SMUGGLING_SOFT_LIMIT = 16;
    public static final int LEFT_PANEL_WIDTH = 176;
    public static final int RESULT_SLOT = 0;
    public static final int CRAFT_SLOT_START = 1;
    public static final int CRAFT_SLOT_END = 9;
    public static final int INV_SLOT_START = 10;
    public static final int INV_SLOT_END = 36;
    public static final int HOTBAR_ROW_SLOT_START = 37;
    public static final int HOTBAR_ROW_SLOT_END = 45;
    public static final int CUST_SLOT_START = 46;
    public static final int CUST_SLOT_END = 49;
    public static final int TABS_SLOT_START = 50;
    public static final int TABS_SLOT_END = 81;
    public static final int ACCESS_SLOT_START = 82;
    public static final int ACCESS_SLOT_END = 135;
    protected final CraftingContainer craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    protected final ResultContainer resultSlots = new ResultContainer();
    protected final Player player;
    protected final ContainerLevelAccess access;
    private final SimpleContainer customizationSlots = new SimpleContainer(4);
    private final Container tabElements = new SimpleContainer(32);
    private Container chestSlots = null;
    protected boolean initialLoading = true;
    private boolean clientFlagScreenTooNarrow = false;
    private int lastInventoryAccessRange = 0;
    private int lastLanternCount = 0;
    private final InventoryAccessHelper inventoryAccessHelper = new InventoryAccessHelper();
    public int selectedTab = -1;
    protected SimpleTableDataSlots DataSlots = new SimpleTableDataSlots(this);

    public SimpleTableMenu(int containerId, Inventory inventory, FriendlyByteBuf friendlyByteBuf) {
        this(containerId, inventory, ContainerLevelAccess.NULL, Registration.CRAFTING_SINGLE_MENU_TYPE.get());
    }

    public SimpleTableMenu(int containerId, Inventory inventory, ContainerLevelAccess levelAccess, @Nullable MenuType<?> menuType) {
        super(menuType, containerId);
        int hor;
        int ver;
        this.access = levelAccess;
        this.player = inventory.player;
        this.DataSlots.addSlots();
        this.addSlot((Slot)new ResultSlot(inventory.player, this.craftSlots, (Container)this.resultSlots, 0, 120, 35));
        for (ver = 0; ver < 3; ++ver) {
            for (hor = 0; hor < 3; ++hor) {
                this.addSlot(new Slot((Container)this.craftSlots, hor + ver * 3, 26 + hor * 18, 17 + ver * 18));
            }
        }
        for (ver = 0; ver < 3; ++ver) {
            for (hor = 0; hor < 9; ++hor) {
                this.addSlot(new Slot((Container)inventory, hor + ver * 9 + 9, 8 + hor * 18, 84 + ver * 18));
            }
        }
        for (int hor2 = 0; hor2 < 9; ++hor2) {
            this.addSlot(new Slot((Container)inventory, hor2, 8 + hor2 * 18, 142));
        }
        int custSlotCount = this.getCustomizationSlotCount();
        this.addSlot(new CustomizationSlot((Container)this.customizationSlots, 0, 152, 17 + (0 < custSlotCount ? 0 : 9009)));
        this.addSlot(new CustomizationSlot((Container)this.customizationSlots, 1, 152, 39 + (1 < custSlotCount ? 0 : 9009)));
        this.addSlot(new CustomizationSlot((Container)this.customizationSlots, 2, 152, 61 + (2 < custSlotCount ? 0 : 9009)));
        this.addSlot(new CustomizationSlot((Container)this.customizationSlots, 3, 152, 83 + (3 < custSlotCount ? 0 : 9009)));
        this.access.execute(this::loadFromWorld);
        this.lastLanternCount = this.getLanternCount();
        if (!this.player.level().isClientSide) {
            this.customizationSlots.addListener((ContainerListener)new CustomizationListenerServer(this, this));
        } else {
            this.customizationSlots.addListener((ContainerListener)new CustomizationListenerClient(this, this));
        }
        for (int i = 0; i < this.tabElements.getContainerSize(); ++i) {
            this.addSlot(new TransferCheatSlot(this.tabElements, i, 9009, 9009 + i * 30));
        }
        this.storeAdjacentInventoriesInSlots();
        this.chestSlots = new DisabledContainer(54);
        this.setUpperContainerTrueSize(54);
        for (int ver2 = 0; ver2 < this.chestSlots.getContainerSize() / 9; ++ver2) {
            for (int hor3 = 0; hor3 < 9; ++hor3) {
                this.addSlot(new VariableSizeContainerSlot(this.chestSlots, ver2 * 9 + hor3, 5 + hor3 * 18 - 176, 30 + ver2 * 18, this::getUpperContainerTrueSize, this::isSlotSpecificallyDisabled));
            }
        }
        this.initialLoading = false;
        this.access.execute((level, pos) -> TableLockManager.register(this.containerId, level, pos));
    }

    public DataSlot addDataSlot(DataSlot slot) {
        return super.addDataSlot(slot);
    }

    public int getCustomizationSlotCount() {
        return (Integer)CommonConfig.SimpleTableNumberOfSlots.get();
    }

    protected static void slotChangedCraftingGrid(AbstractContainerMenu menu, Level level, BlockPos tablePos, Player player, CraftingContainer craftingContainer, ResultContainer resultContainer, int resultSlotIndex) {
        if (!level.isClientSide) {
            if (resultSlotIndex >= menu.slots.size()) {
                return;
            }
            CraftingInput craftinginput = craftingContainer.asCraftInput();
            Optional recipeHolder = ModList.get().isLoaded("polymorph") ? PolymorphAccessorServer.getRecipe(menu, craftingContainer, level, player) : level.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)craftinginput, level);
            ServerPlayer serverplayer = (ServerPlayer)player;
            ItemStack itemstack = ItemStack.EMPTY;
            if (recipeHolder.isPresent() && resultContainer.setRecipeUsed(level, serverplayer, (RecipeHolder)recipeHolder.get())) {
                itemstack = ((CraftingRecipe)((RecipeHolder)recipeHolder.get()).value()).assemble((RecipeInput)craftinginput, (HolderLookup.Provider)level.registryAccess());
            }
            resultContainer.setItem(0, itemstack);
            menu.setRemoteSlot(resultSlotIndex, itemstack);
            serverplayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(menu.containerId, menu.incrementStateId(), resultSlotIndex, itemstack));
            SimpleTableMenu.updateInventoryOnClientSide(level, tablePos);
        }
    }

    public void slotsChanged(Container container) {
        if (this.isCraftingGrid(container)) {
            this.access.execute((level, pos) -> SimpleTableMenu.slotChangedCraftingGrid(this, level, pos, this.player, this.craftSlots, this.resultSlots, 0));
        }
    }

    public void handleCraftingUpdateRequest(int resultSlotIndex) {
        this.slotsChanged((Container)this.craftSlots);
    }

    protected void setActiveResultSlotForPolymorph(int index) {
        if (this.player != null && !this.player.level().isClientSide) {
            this.DataSlots.setSlotValue(6, index);
        }
    }

    protected void clearAdditional() {
    }

    public void removed(Player player) {
        super.removed(player);
        boolean hasDrawer = this.hasChestInCustomizationSlots();
        this.clearContainer(player, (Container)this.craftSlots);
        this.clearAdditional();
        this.access.execute((level, pos) -> this.storeDataValues((Level)level, (BlockPos)pos));
        this.access.execute((level, pos) -> this.storeCustomizationsToWorld((Container)this.customizationSlots, (Level)level, (BlockPos)pos));
        this.access.execute((level, pos) -> this.updateDrawerInWorld((Level)level, (BlockPos)pos, hasDrawer));
        this.access.execute((level, pos) -> SimpleTableMenu.updateInventoryOnClientSide(level, pos));
    }

    private static void updateInventoryOnClientSide(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        level.sendBlockUpdated(pos, state, state, 2);
    }

    protected void storeDataValues(Level level, BlockPos pos) {
    }

    public boolean stillValid(Player player) {
        return (Boolean)this.access.evaluate((level, pos) -> {
            if (!(level.getBlockState(pos).getBlock() instanceof SimpleTable)) {
                return false;
            }
            return player.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= 64.0;
        }, (Object)true);
    }

    protected boolean isSlotACraftingResultSlot(int index) {
        return index == 0;
    }

    protected boolean isSlotACraftingGridSlot(int index) {
        return index >= 1 && index <= 9;
    }

    protected boolean moveItemStackToCraftingGrid(ItemStack itemstack1) {
        return this.moveItemStackToOccupiedSlotsOnly(itemstack1, 1, 10, false);
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (this.isSlotACraftingResultSlot(slotIndex)) {
                this.access.execute((level, p_39379_) -> itemstack1.getItem().onCraftedBy(itemstack1, level, player));
                if (!this.moveItemStackTo(itemstack1, 10, 46, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (slotIndex >= 10 && slotIndex <= 45 ? !this.moveItemStackToCraftingGrid(itemstack1) && (!this.showInventoryAccess() || !this.moveItemStackToOccupiedSlotsOnly(itemstack1, 82, 136, false)) && (slotIndex < 37 ? !this.moveItemStackTo(itemstack1, 37, 46, false) : !this.moveItemStackTo(itemstack1, 10, 37, false)) : (slotIndex >= 82 && slotIndex <= 135 ? !this.moveItemStackToCraftingGrid(itemstack1) && !this.moveItemStackToOccupiedSlotsOnly(itemstack1, 10, 37, false) && !this.moveItemStackTo(itemstack1, 37, 46, true) && !this.moveItemStackTo(itemstack1, 10, 37, false) : this.isSlotACraftingGridSlot(slotIndex) && (!this.showInventoryAccess() || !this.moveItemStackToOccupiedSlotsOnly(itemstack1, 82, 136, false)) && !this.moveItemStackTo(itemstack1, 10, 46, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.set(itemstack1);
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            if (slotIndex == 0) {
                player.drop(itemstack1, false);
            }
        }
        return itemstack;
    }

    protected boolean moveItemStackToOccupiedSlotsOnly(ItemStack itemStackBeingMoved, int startingSlot, int endingSlotPlus1, boolean reverse) {
        boolean result = false;
        int i = startingSlot;
        if (reverse) {
            i = endingSlotPlus1 - 1;
        }
        if (itemStackBeingMoved.isStackable()) {
            while (!itemStackBeingMoved.isEmpty() && !(reverse ? i < startingSlot : i >= endingSlotPlus1)) {
                ItemStack copy;
                int maxSize;
                ItemStack itemStackInDestination;
                Slot slot = (Slot)this.slots.get(i);
                i = reverse ? --i : ++i;
                if (!slot.isActive() || (itemStackInDestination = slot.getItem()).isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)itemStackBeingMoved, (ItemStack)itemStackInDestination)) continue;
                int j = itemStackInDestination.getCount() + itemStackBeingMoved.getCount();
                if (j <= (maxSize = slot.getMaxStackSize(itemStackInDestination))) {
                    itemStackBeingMoved.setCount(0);
                    copy = itemStackInDestination.copy();
                    copy.setCount(j);
                    slot.set(copy);
                    result = true;
                    continue;
                }
                if (itemStackInDestination.getCount() >= maxSize) continue;
                itemStackBeingMoved.shrink(maxSize - itemStackInDestination.getCount());
                copy = itemStackInDestination.copy();
                copy.setCount(maxSize);
                slot.set(copy);
                result = true;
            }
        }
        return result;
    }

    public boolean canTakeItemForPickAll(ItemStack p_39381_, Slot slot) {
        return slot.container != this.resultSlots && slot.container != this.tabElements && slot.container != this.customizationSlots && slot.isActive() && super.canTakeItemForPickAll(p_39381_, slot);
    }

    protected void clearContainer(Player player, Container container) {
        if (this.isCraftingGrid(container)) {
            this.access.execute((level, pos) -> {
                if (!(level.getBlockEntity(pos) instanceof SimpleTableBlockEntity)) {
                    super.clearContainer(player, container);
                    return;
                }
                if (!this.hasChestInCustomizationSlots()) {
                    if (this.showInventoryAccess()) {
                        this.clearContainerWithInventoryAccess(player, container);
                    }
                    super.clearContainer(player, container);
                    this.clearInWorld(container, (Level)level, (BlockPos)pos);
                    return;
                }
                this.storeCraftingGridToWorld(container, (Level)level, (BlockPos)pos);
            });
        }
    }

    protected void clearContainerWithInventoryAccess(Player player, Container container) {
        if (!player.isAlive() || player instanceof ServerPlayer && ((ServerPlayer)player).hasDisconnected()) {
            for (int j = 0; j < container.getContainerSize(); ++j) {
                player.drop(container.removeItemNoUpdate(j), false);
            }
        } else {
            for (int i = 0; i < container.getContainerSize(); ++i) {
                this.moveItemStackToOccupiedSlotsOnly(container.getItem(i), 82, 136, false);
            }
        }
    }

    private boolean isCraftingGrid(Container container) {
        return container instanceof CraftingContainer;
    }

    protected int getSlotOffsetInDataStorage(Container container) {
        return 0;
    }

    private void storeCraftingGridToWorld(Container container, Level level, BlockPos pos) {
        SimpleTableBlockEntity be = (SimpleTableBlockEntity)level.getBlockEntity(pos);
        if (be == null) {
            return;
        }
        for (int i = 0; i < container.getContainerSize(); ++i) {
            be.DepositItem(this.getSlotOffsetInDataStorage(container) + i, container.removeItemNoUpdate(i));
        }
    }

    private void storeCustomizationsToWorld(Container container, Level level, BlockPos pos) {
        SimpleTableBlockEntity be = (SimpleTableBlockEntity)level.getBlockEntity(pos);
        if (be == null) {
            return;
        }
        for (int i = 0; i < container.getContainerSize(); ++i) {
            be.DepositCustomizationItem(i, container.removeItemNoUpdate(i));
        }
    }

    protected void loadFromWorld(Level level, BlockPos pos) {
        int i;
        SimpleTableBlockEntity be = (SimpleTableBlockEntity)level.getBlockEntity(pos);
        if (be == null) {
            return;
        }
        for (i = 0; i < this.craftSlots.getContainerSize(); ++i) {
            this.craftSlots.setItem(i, be.GetItem(i));
        }
        this.craftSlots.setChanged();
        for (i = 0; i < this.customizationSlots.getContainerSize(); ++i) {
            this.customizationSlots.setItem(i, be.GetCustomizationItem(i));
        }
    }

    private void clearInWorld(Container container, Level level, BlockPos pos) {
        BaseContainerBlockEntity be = (BaseContainerBlockEntity)level.getBlockEntity(pos);
        for (int i = 0; i < container.getContainerSize(); ++i) {
            be.ClearItem(this.getSlotOffsetInDataStorage(container) + i);
        }
    }

    private void updateDrawerInWorld(Level level, BlockPos pos, boolean hasDrawer) {
        BlockState state = level.getBlockState(pos);
        if (!(state.getBlock() instanceof SimpleTable)) {
            return;
        }
        if (!((Boolean)state.getValue((Property)SimpleTable.HAS_INVENTORY)).booleanValue() && hasDrawer) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SimpleTable.HAS_INVENTORY, (Comparable)Boolean.valueOf(true)), 130);
        } else if (((Boolean)state.getValue((Property)SimpleTable.HAS_INVENTORY)).booleanValue() && !hasDrawer) {
            level.setBlock(pos, (BlockState)state.setValue((Property)SimpleTable.HAS_INVENTORY, (Comparable)Boolean.valueOf(false)), 130);
        }
    }

    private boolean hasChestInCustomizationSlots() {
        for (int i = 0; i < this.customizationSlots.getContainerSize(); ++i) {
            if (!this.customizationSlots.getItem(i).is(CustomizationSlot.ChestTag)) continue;
            return true;
        }
        return false;
    }

    public boolean showInventoryAccess() {
        if (this.tabElements.getItem(0).isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.customizationSlots.getContainerSize(); ++i) {
            if (!this.customizationSlots.getItem(i).is(CustomizationSlot.getAccessItem())) continue;
            return true;
        }
        return false;
    }

    public int getInventoryAccessRange() {
        int result = 0;
        for (int i = 0; i < this.customizationSlots.getContainerSize(); ++i) {
            if (!this.customizationSlots.getItem(i).is(CustomizationSlot.getAccessItem())) continue;
            ++result;
        }
        if (result > 2) {
            result = 2;
        }
        return result;
    }

    public int getLanternCount() {
        int result = 0;
        for (int i = 0; i < this.customizationSlots.getContainerSize(); ++i) {
            ItemStack stack = this.customizationSlots.getItem(i);
            if (!stack.is(CustomizationSlot.LanternTag) || stack.getCount() <= result) continue;
            result = stack.getCount();
        }
        return result;
    }

    private void setLanternState(Level level, BlockPos pos, boolean value) {
        Block block = level.getBlockState(pos).getBlock();
        if (block instanceof AdvancedTableBottomPrimary) {
            AdvancedTableBottomPrimary block2 = (AdvancedTableBottomPrimary)block;
            block2.setLanternState(level, pos, value);
        }
    }

    private void storeAdjacentInventoriesInSlots() {
        int range = this.getInventoryAccessRange();
        this.access.execute((level, pos) -> this.inventoryAccessHelper.loadAdjacentInventories((Level)level, (BlockPos)pos, this.player, range));
        this.lastInventoryAccessRange = range;
        this.inventoryAccessHelper.putInventoriesIntoAContainerForTransferToClient(this.tabElements, 16);
        this.tabElements.setChanged();
    }

    public void changeTabTo(int index) {
        Optional haveContainer = this.access.evaluate((level, pos) -> this.inventoryAccessHelper.tryInitializeInventoryAccess((Level)level, this.player, index));
        if (haveContainer.isPresent() && ((Boolean)haveContainer.get()).booleanValue()) {
            if (!this.chestSlots.equals((Object)this.inventoryAccessHelper.chosenContainer)) {
                this.chestSlots = this.inventoryAccessHelper.chosenContainer;
                this.setUpperContainerTrueSize(this.inventoryAccessHelper.chosenContainerTrueSize);
                for (int i = 82; i <= 135; ++i) {
                    this.getSlot((int)i).container = this.chestSlots;
                }
                this.initExcessSlotMap();
            }
        } else {
            if (!(this.chestSlots instanceof DisabledContainer)) {
                this.chestSlots = new DisabledContainer(54);
                this.setUpperContainerTrueSize(54);
                for (int i = 82; i <= 135; ++i) {
                    this.getSlot((int)i).container = this.chestSlots;
                }
            }
            this.clearExcessSlotMap();
        }
        this.selectedTab = index;
        this.DataSlots.resetDataSlotFlagForClientFlag(0);
        this.sendAllDataToRemote();
    }

    public void renameChest(String newName) {
        if (this.player.experienceLevel == 0 && !this.player.isCreative()) {
            return;
        }
        if (newName.equals("")) {
            return;
        }
        if (this.inventoryAccessHelper.currentType.equals("block")) {
            net.minecraft.world.level.block.entity.BaseContainerBlockEntity bcbe;
            BlockEntity blockEntity = this.inventoryAccessHelper.chosenContainerForRename;
            if (!(!(blockEntity instanceof net.minecraft.world.level.block.entity.BaseContainerBlockEntity) || (bcbe = (net.minecraft.world.level.block.entity.BaseContainerBlockEntity)blockEntity).hasCustomName() && bcbe.getCustomName().getString().equals(newName))) {
                bcbe.name = Component.literal((String)newName);
                this.player.giveExperienceLevels(-1);
            }
        } else if (this.inventoryAccessHelper.chosenContainerItem != null) {
            this.inventoryAccessHelper.chosenContainerItem.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)newName));
            this.player.giveExperienceLevels(-1);
        }
    }

    private int getUpperContainerTrueSize() {
        return this.DataSlots.getSlotValue(2);
    }

    private void setUpperContainerTrueSize(int value) {
        if (value != this.getUpperContainerTrueSize()) {
            this.DataSlots.setSlotValue(2, value);
            this.synchronizeDataSlotToRemote(2, value);
        }
    }

    private boolean isSlotSpecificallyDisabled(int slotIndex) {
        return slotIndex < 27 && (this.DataSlots.getSlotValue(3) & 1 << slotIndex) != 0 || slotIndex >= 27 && slotIndex < 54 && (this.DataSlots.getSlotValue(4) & 1 << slotIndex - 27) != 0;
    }

    private void initExcessSlotMap() {
        this.initExcessSlotMapInternal(3, 0);
        this.initExcessSlotMapInternal(4, 27);
    }

    private void clearExcessSlotMap() {
        this.DataSlots.setSlotValue(3, 0);
        this.synchronizeDataSlotToRemote(3, 0);
        this.DataSlots.setSlotValue(4, 0);
        this.synchronizeDataSlotToRemote(4, 0);
    }

    private void initExcessSlotMapInternal(int slot, int offset) {
        Container container = this.inventoryAccessHelper.chosenContainer;
        if (container instanceof IExcessSlotManager) {
            IExcessSlotManager esm = (IExcessSlotManager)container;
            int map = 0;
            int mask = 1;
            for (int k = 0; k < 27; ++k) {
                if (esm.isSlotSpecificallyDisabled(k + offset)) {
                    map |= mask;
                }
                mask <<= 1;
            }
            this.DataSlots.setSlotValue(slot, map);
            this.synchronizeDataSlotToRemote(slot, map);
        }
    }

    public void registerClientHandlerForDataSlot(int slotIndex, Consumer<Integer> event) {
        this.DataSlots.registerClientHandlerForDataSlot(slotIndex, event);
    }

    public void updateAccessSlotsOnClient() {
        int range;
        if (!this.initialLoading) {
            DisabledContainer dc;
            Container container;
            if (this.clientFlagScreenTooNarrow && this.chestSlots.getMaxStackSize() != 707 && (container = this.chestSlots) instanceof DisabledContainer) {
                dc = (DisabledContainer)container;
                dc.disabled = true;
            }
            if (this.showInventoryAccess() && this.chestSlots.getMaxStackSize() == 707 && !this.clientFlagScreenTooNarrow && (container = this.chestSlots) instanceof DisabledContainer) {
                dc = (DisabledContainer)container;
                dc.disabled = false;
            }
            if (!this.showInventoryAccess() && this.chestSlots.getMaxStackSize() != 707) {
                if (this.selectedTab != 0) {
                    this.changeTabTo(0);
                }
                if (this.chestSlots instanceof DisabledContainer && this.chestSlots.getMaxStackSize() != 707) {
                    ((DisabledContainer)this.chestSlots).disabled = true;
                }
                this.sendAllDataToRemote();
            }
        }
        if ((range = this.getInventoryAccessRange()) != this.lastInventoryAccessRange) {
            PacketSender.sendTabChangeToServer(0);
        }
        this.lastInventoryAccessRange = range;
    }

    public void setClientFlagScreenTooNarrow(boolean value) {
        this.clientFlagScreenTooNarrow = value;
    }

    public static class CustomizationSlot
    extends Slot {
        private static final TagKey<Item> ChestTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)"chests"));
        private static final TagKey<Item> LanternTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"lanterns"));
        private static final ResourceLocation EMPTY_SLOT_BG = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"gui/c_slot");
        private static Item accessItem = null;
        private boolean acceptsLanterns = false;

        public CustomizationSlot(Container p_39521_, int p_39522_, int p_39523_, int p_39524_) {
            super(p_39521_, p_39522_, p_39523_, p_39524_);
            this.setBackground(InventoryMenu.BLOCK_ATLAS, EMPTY_SLOT_BG);
        }

        public boolean mayPlace(ItemStack itemStack) {
            return itemStack.is(ChestTag) || itemStack.is(CustomizationSlot.getAccessItem()) || this.acceptsLanterns && itemStack.is(LanternTag);
        }

        public int getMaxStackSize(ItemStack itemStack) {
            return itemStack.is(LanternTag) ? 2 : 1;
        }

        private static Item getAccessItem() {
            if (accessItem == null && (accessItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)((String)CommonConfig.AccessCustomizationItem.get())))).equals(Items.AIR)) {
                accessItem = Items.NAME_TAG;
            }
            return accessItem;
        }

        public void setAcceptsLanterns(boolean value) {
            this.acceptsLanterns = value;
        }

        public boolean isFake() {
            return true;
        }
    }

    private class CustomizationListenerServer
    implements ContainerListener {
        private final SimpleTableMenu parent;

        public CustomizationListenerServer(SimpleTableMenu simpleTableMenu, SimpleTableMenu simpleTableMenu2) {
            this.parent = simpleTableMenu2;
        }

        public void containerChanged(Container container) {
            int lanternCount;
            int range = this.parent.getInventoryAccessRange();
            int lastRange = this.parent.lastInventoryAccessRange;
            if (range != this.parent.lastInventoryAccessRange) {
                this.parent.storeAdjacentInventoriesInSlots();
                this.parent.DataSlots.resetDataSlotFlagForClientFlag(0);
                this.parent.DataSlots.raiseDataSlotFlagForClientFlag(0);
                if (lastRange == 0) {
                    this.parent.sendAllDataToRemote();
                }
                this.parent.lastInventoryAccessRange = range;
            }
            if ((lanternCount = this.parent.getLanternCount()) == 2 && this.parent.lastLanternCount != 2) {
                this.parent.access.execute((l, p) -> this.parent.setLanternState((Level)l, (BlockPos)p, true));
                this.parent.lastLanternCount = lanternCount;
            } else if (lanternCount != 2 && this.parent.lastLanternCount == 2) {
                this.parent.access.execute((l, p) -> this.parent.setLanternState((Level)l, (BlockPos)p, false));
                this.parent.lastLanternCount = lanternCount;
            }
        }
    }

    private class CustomizationListenerClient
    implements ContainerListener {
        private final SimpleTableMenu parent;

        public CustomizationListenerClient(SimpleTableMenu simpleTableMenu, SimpleTableMenu simpleTableMenu2) {
            this.parent = simpleTableMenu2;
        }

        public void containerChanged(Container container) {
            this.parent.updateAccessSlotsOnClient();
        }
    }

    public static class TransferCheatSlot
    extends Slot {
        public TransferCheatSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean isFake() {
            return true;
        }

        public boolean isHighlightable() {
            return false;
        }

        public boolean mayPickup(Player player) {
            return false;
        }

        public boolean isActive() {
            return false;
        }

        public boolean mayPlace(ItemStack stack) {
            return false;
        }
    }

    private static class DisabledContainer
    extends SimpleContainer {
        private static final int MARKER_FOR_DISABLED = 707;
        private boolean disabled = true;

        public int getMaxStackSize() {
            return this.disabled ? 707 : 0x100000;
        }

        public int getMaxStackSize(ItemStack stack) {
            return 0x200000;
        }

        public boolean canPlaceItem(int p_18952_, ItemStack p_18953_) {
            return !this.disabled && super.canPlaceItem(p_18952_, p_18953_);
        }

        public DisabledContainer(int size) {
            super(size);
        }
    }

    public static class VariableSizeContainerSlot
    extends UnrestrainedSlot {
        private Supplier<Integer> containerTrueSizeGetter = null;
        private Function<Integer, Boolean> excessSettingGetter = null;

        public VariableSizeContainerSlot(Container p_40223_, int p_40224_, int p_40225_, int p_40226_, Supplier<Integer> containerTrueSize, Function<Integer, Boolean> excessSetting) {
            super(p_40223_, p_40224_, p_40225_, p_40226_);
            this.containerTrueSizeGetter = containerTrueSize;
            this.excessSettingGetter = excessSetting;
        }

        public boolean isActive() {
            return this.container.getMaxStackSize() != 707 && !this.isExcessSlot();
        }

        public boolean mayPlace(ItemStack itemStack) {
            return this.isActive() && this.container.canPlaceItem(this.getSlotIndex(), itemStack);
        }

        public ItemStack getItem() {
            if (!this.isExcessSlot()) {
                return super.getItem();
            }
            return ItemStack.EMPTY;
        }

        public void set(ItemStack stack) {
            if (this.getSlotIndex() < this.getContainerTrueSize()) {
                super.set(stack);
            }
        }

        public int getMaxStackSize() {
            return this.container.getMaxStackSize();
        }

        public int getMaxStackSize(ItemStack stack) {
            return this.container.getMaxStackSize(stack);
        }

        public int getContainerTrueSize() {
            return this.containerTrueSizeGetter.get();
        }

        public boolean isExcessSlot() {
            return this.getSlotIndex() >= this.getContainerTrueSize() || this.excessSettingGetter != null && this.excessSettingGetter.apply(this.getSlotIndex()) != false;
        }
    }

    public static class VariableSizeItemStackHandlerWrapper
    extends BaseItemHandlerWrapper {
        private final int slotCount;
        private final boolean allowPlaceContainers;

        public VariableSizeItemStackHandlerWrapper(IItemHandler wrapped, boolean allowPlaceContainers) {
            super(wrapped);
            this.allowPlaceContainers = allowPlaceContainers;
            this.slotCount = wrapped.getSlots();
        }

        @Override
        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            if (!this.allowPlaceContainers && !itemStack.getItem().canFitInsideContainerItems()) {
                return false;
            }
            return slot < this.slotCount && super.canPlaceItem(slot, itemStack);
        }

        @Override
        public ItemStack getItem(int slot) {
            return slot < this.slotCount ? super.getItem(slot) : ItemStack.EMPTY;
        }

        @Override
        public ItemStack removeItem(int slot, int count) {
            return slot < this.slotCount ? super.removeItem(slot, count) : ItemStack.EMPTY;
        }

        @Override
        public ItemStack removeItemNoUpdate(int slot) {
            return slot < this.slotCount ? super.removeItemNoUpdate(slot) : ItemStack.EMPTY;
        }

        @Override
        public void setItem(int slot, ItemStack itemStack) {
            if (slot < this.slotCount) {
                super.setItem(slot, itemStack);
            }
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty();
        }

        @Override
        public void setChanged() {
        }

        @Override
        public int getMaxStackSize() {
            return super.getMaxStackSize();
        }

        @Override
        public int getMaxStackSize(ItemStack itemStack) {
            return super.getMaxStackSize(itemStack);
        }
    }

    public static class VariableSizeContainerWrapper
    extends SimpleContainerEx
    implements IExcessSlotManager {
        private IExcessSlotManager excessManager = null;
        private final Container internal;
        private final boolean allowPlaceContainers;

        public VariableSizeContainerWrapper(Container wrapped, boolean allowPlaceContainers) {
            super(54);
            this.internal = wrapped;
            this.allowPlaceContainers = allowPlaceContainers;
            Container container = this.internal;
            if (container instanceof IExcessSlotManager) {
                IExcessSlotManager esm;
                this.excessManager = esm = (IExcessSlotManager)container;
            }
        }

        @Override
        public boolean canPlaceItem(int slot, ItemStack itemStack) {
            if (!this.allowPlaceContainers && !itemStack.getItem().canFitInsideContainerItems()) {
                return false;
            }
            return slot < this.internal.getContainerSize() && this.internal.canPlaceItem(slot, itemStack);
        }

        public ItemStack getItem(int slot) {
            return slot < this.internal.getContainerSize() ? this.internal.getItem(slot) : ItemStack.EMPTY;
        }

        public ItemStack removeItem(int slot, int count) {
            return slot < this.internal.getContainerSize() ? this.internal.removeItem(slot, count) : ItemStack.EMPTY;
        }

        public ItemStack removeItemNoUpdate(int slot) {
            return slot < this.internal.getContainerSize() ? this.internal.removeItemNoUpdate(slot) : ItemStack.EMPTY;
        }

        public void setItem(int slot, ItemStack itemStack) {
            if (slot < this.internal.getContainerSize()) {
                this.internal.setItem(slot, itemStack);
            }
        }

        public boolean isEmpty() {
            return this.internal.isEmpty();
        }

        public void setChanged() {
            this.internal.setChanged();
        }

        public int getMaxStackSize() {
            return this.internal.getMaxStackSize();
        }

        public int getMaxStackSize(ItemStack stack) {
            return this.internal.getMaxStackSize(stack);
        }

        @Override
        public boolean isSlotSpecificallyDisabled(int slotIndex) {
            return this.excessManager != null && this.excessManager.isSlotSpecificallyDisabled(slotIndex);
        }
    }

    public static class UnrestrainedSlot
    extends Slot {
        public UnrestrainedSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public Optional<ItemStack> tryRemove(int count, int decrement, Player player) {
            return super.tryRemove(count, decrement, player);
        }

        public ItemStack safeInsert(ItemStack stack, int increment) {
            if (stack.isEmpty() || !this.mayPlace(stack)) {
                return stack;
            }
            ItemStack itemstack = this.getItem();
            int i = Math.min(Math.min(increment, stack.getCount()), this.getMaxStackSize(stack) - itemstack.getCount());
            if (itemstack.isEmpty()) {
                this.setByPlayer(stack.split(i));
            } else if (ItemStack.isSameItemSameComponents((ItemStack)itemstack, (ItemStack)stack)) {
                stack.shrink(i);
                ItemStack copy = itemstack.copy();
                copy.grow(i);
                this.setByPlayer(copy);
            }
            return stack;
        }
    }

    public static class OptionallyDrawnSlot
    extends Slot {
        private final Supplier<Boolean> condition;

        public OptionallyDrawnSlot(Container p_40223_, int p_40224_, int p_40225_, int p_40226_, Supplier<Boolean> condition) {
            super(p_40223_, p_40224_, p_40225_, p_40226_);
            this.condition = condition;
        }

        public boolean shouldRender() {
            return this.condition != null && this.condition.get() != false;
        }

        public boolean isActive() {
            return this.shouldRender();
        }
    }
}

