/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.containers;

import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public class ItemContainerContentsWrapper
implements Container {
    private final ItemStack containerStack;
    private final ItemContainerContents wrapped;
    private final NonNullList<ItemStack> list = NonNullList.withSize((int)54, (Object)ItemStack.EMPTY);
    private final int maxSize;

    public ItemContainerContentsWrapper(ItemContainerContents container, ItemStack backpack, int maxSize) {
        this.containerStack = backpack;
        this.wrapped = container;
        container.copyInto(this.list);
        this.maxSize = maxSize;
    }

    public int getContainerSize() {
        return this.maxSize;
    }

    public boolean isEmpty() {
        return this.wrapped.getSlots() < 1;
    }

    public ItemStack getItem(int slot) {
        return slot < this.maxSize ? (ItemStack)this.list.get(slot) : ItemStack.EMPTY;
    }

    public ItemStack removeItem(int slot, int count) {
        ItemStack result = ItemStack.EMPTY;
        if (slot < this.maxSize) {
            result = this.getItem(slot).copy();
            if (count < result.getCount()) {
                result.shrink(result.getCount() - count);
            }
            ((ItemStack)this.list.get(slot)).shrink(result.getCount());
            this.containerStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.list));
        }
        return result;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack result = this.getItem(slot);
        if (slot < this.maxSize) {
            this.list.set(slot, (Object)ItemStack.EMPTY);
        }
        return result;
    }

    public void setItem(int slot, ItemStack itemStack) {
        if (slot < this.maxSize) {
            this.list.set(slot, (Object)ItemStack.EMPTY);
        }
        this.containerStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.list));
    }

    public int getMaxStackSize() {
        return super.getMaxStackSize();
    }

    public int getMaxStackSize(ItemStack stack) {
        return super.getMaxStackSize(stack);
    }

    public void setChanged() {
        this.containerStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.list));
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot >= 0 && slot < this.maxSize;
    }

    public boolean canTakeItem(Container target, int slot, ItemStack stack) {
        return slot >= 0 && slot < this.maxSize && target.canTakeItem(target, slot, stack);
    }

    public void clearContent() {
        for (int i = 0; i < this.maxSize; ++i) {
            this.list.set(i, (Object)ItemStack.EMPTY);
        }
        this.containerStack.set(DataComponents.CONTAINER, (Object)ItemContainerContents.fromItems(this.list));
    }
}

