/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.containers.container_translators;

import moonfather.workshop_for_handsome_adventurer.block_entities.containers.SimpleContainerEx;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public abstract class BaseItemHandlerWrapper
extends SimpleContainerEx {
    protected final IItemHandler internal;

    public BaseItemHandlerWrapper(IItemHandler wrapped, int totalSize) {
        super(totalSize);
        this.internal = wrapped;
    }

    public BaseItemHandlerWrapper(IItemHandler wrapped) {
        super(wrapped.getSlots());
        this.internal = wrapped;
    }

    @Override
    public boolean canPlaceItem(int slot, ItemStack itemStack) {
        return this.internal.isItemValid(slot, itemStack);
    }

    public ItemStack getItem(int slot) {
        return this.internal.getStackInSlot(slot);
    }

    public ItemStack removeItem(int slot, int count) {
        int formalStackSize = this.getItem(slot).getMaxStackSize();
        count = Math.min(count, formalStackSize);
        return this.internal.extractItem(slot, count, false);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.internal.extractItem(slot, 5555555, false);
    }

    public void setItem(int slot, ItemStack itemStack) {
        IItemHandler iItemHandler = this.internal;
        if (iItemHandler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable i2 = (IItemHandlerModifiable)iItemHandler;
            i2.setStackInSlot(slot, itemStack);
        } else {
            ItemStack old = this.internal.getStackInSlot(slot);
            if (old.isEmpty()) {
                ItemStack resto = this.internal.insertItem(slot, itemStack, false);
            } else if (itemStack.isEmpty()) {
                ItemStack resto = this.internal.extractItem(slot, old.getCount(), false);
            } else if (ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)old)) {
                if (itemStack.getCount() > old.getCount()) {
                    itemStack.shrink(old.getCount());
                    ItemStack resto = this.internal.insertItem(slot, itemStack, false);
                } else {
                    ItemStack resto = this.internal.extractItem(slot, old.getCount() - itemStack.getCount(), false);
                }
            } else {
                ItemStack resto = this.internal.extractItem(slot, old.getCount(), false);
                resto = this.internal.insertItem(slot, itemStack, false);
            }
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.internal.getSlots(); ++i) {
            if (this.internal.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setChanged() {
    }

    public int getMaxStackSize() {
        return this.internal.getSlots() > 1 ? this.internal.getSlotLimit(1) : 64;
    }

    public int getMaxStackSize(ItemStack itemStack) {
        for (int i = 0; i < this.internal.getSlots(); ++i) {
            ItemStack old = this.getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)itemStack, (ItemStack)old)) continue;
            return this.internal.getSlotLimit(i);
        }
        return this.getMaxStackSize();
    }
}

