/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.block_entities.screens;

import moonfather.workshop_for_handsome_adventurer.CommonConfig;
import moonfather.workshop_for_handsome_adventurer.block_entities.DualTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.SimpleTableMenu;
import moonfather.workshop_for_handsome_adventurer.block_entities.messaging.PacketSender;
import moonfather.workshop_for_handsome_adventurer.block_entities.screens.SimpleTableCraftingScreen;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StateSwitchingButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;

@OnlyIn(value=Dist.CLIENT)
public class DualTableCraftingScreen
extends SimpleTableCraftingScreen {
    private static final ResourceLocation[] BACKGROUND_LOCATION = new ResourceLocation[5];
    private StateSwitchingButton jeiButton = null;
    private int lastDestinationGrid = 1;
    private static final WidgetSprites spritesJEI = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/jei_up_normal.png"), ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/jei_down_normal.png"), ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/jei_up_hovered.png"), ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/jei_down_hovered.png"));
    private static final WidgetSprites spritesREI = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/rei_up_normal.png"), ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/rei_down_normal.png"), ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/rei_up_hovered.png"), ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/rei_down_hovered.png"));
    private static final WidgetSprites spritesEMI = new WidgetSprites(ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/emi_up_normal.png"), ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/emi_down_normal.png"), ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/emi_up_hovered.png"), ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"textures/gui/emi_down_hovered.png"));

    public DualTableCraftingScreen(SimpleTableMenu p_98448_, Inventory p_98449_, Component p_98450_) {
        super(p_98448_, p_98449_, p_98450_);
        this.imageHeight = 233;
    }

    @Override
    protected String getCustomizationTooltipPath() {
        return "message.workshop_for_handsome_adventurer.extension_slot2";
    }

    @Override
    protected ResourceLocation getBackgroundImage() {
        if (BACKGROUND_LOCATION[0] == null) {
            for (int i = 0; i <= 4; ++i) {
                DualTableCraftingScreen.BACKGROUND_LOCATION[i] = ResourceLocation.parse((String)"workshop_for_handsome_adventurer:textures/gui/gui_dual_table_%d_slots.png".formatted(i));
            }
        }
        if (this.backgroundImageLocation == null) {
            this.backgroundImageLocation = BACKGROUND_LOCATION[(Integer)CommonConfig.DualTableNumberOfSlots.get()];
        }
        return this.backgroundImageLocation;
    }

    protected void renderLabels(GuiGraphics graphics, int p_97809_, int p_97810_) {
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        graphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY + 54 + 13, 0x404040, false);
        graphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY + 54 + 13, 0x404040, false);
    }

    @Override
    protected void init() {
        super.init();
        ((DualTableMenu)this.menu).registerClientHandlerForRecipeTargetChange(this::recipeTargetButtonChangeHandler);
        this.createJeiButton();
    }

    private void recipeTargetButtonChangeHandler(Integer value) {
        this.lastDestinationGrid = value;
        if (this.jeiButton != null) {
            this.jeiButton.setStateTriggered(value == 2);
        }
    }

    @Override
    public void setPositionsX() {
        super.setPositionsX();
        if (this.jeiButton != null) {
            this.jeiButton.setPosition(80 + this.renderLeftPos, 62 + this.topPos);
        }
    }

    private void createJeiButton() {
        if (ModList.get().isLoaded("jei") || ModList.get().isLoaded("roughlyenoughitems") || ModList.get().isLoaded("emi")) {
            this.jeiButton = new DestinationPickerButton(0, 0, 40, 28, false);
            if (ModList.get().isLoaded("roughlyenoughitems")) {
                this.jeiButton.initTextureValues(spritesREI);
            } else if (ModList.get().isLoaded("emi")) {
                this.jeiButton.initTextureValues(spritesEMI);
            } else {
                this.jeiButton.initTextureValues(spritesJEI);
            }
            this.jeiButton.setPosition(80 + this.renderLeftPos, 62 + this.topPos);
            this.jeiButton.setStateTriggered(((DualTableMenu)this.menu).getRecipeTargetGrid() == 2);
            this.addRenderableWidget((GuiEventListener)this.jeiButton);
        }
    }

    private class DestinationPickerButton
    extends StateSwitchingButton {
        private static final int JEI_BUTTON_WIDTH = 40;
        private static final int JEI_BUTTON_HEIGTH = 28;
        private static final int JEI_BUTTON_MARGIN = 0;
        private static final int JEI_BUTTON_RENDERX = 80;
        private static final int JEI_BUTTON_RENDERY = 62;

        public DestinationPickerButton(int p_94615_, int p_94616_, int p_94617_, int p_94618_, boolean p_94619_) {
            super(p_94615_, p_94616_, p_94617_, p_94618_, p_94619_);
        }

        public boolean mouseClicked(double x, double y, int p_93643_) {
            double localX = x - (double)this.getX();
            double localY = y - (double)this.getY();
            if (localX >= 10.0 && localX <= 20.0 && localY >= 4.0 && localY <= 14.0) {
                if (DualTableCraftingScreen.this.lastDestinationGrid != 2) {
                    PacketSender.sendDestinationGridChangeToServer(2);
                    DualTableCraftingScreen.this.lastDestinationGrid = 2;
                    this.setStateTriggered(true);
                }
                return true;
            }
            if (localX >= 10.0 && localX <= 20.0 && localY >= 14.0 && localY <= 24.0) {
                if (DualTableCraftingScreen.this.lastDestinationGrid != 1) {
                    PacketSender.sendDestinationGridChangeToServer(1);
                    DualTableCraftingScreen.this.lastDestinationGrid = 1;
                    this.setStateTriggered(false);
                }
                return true;
            }
            return super.mouseClicked(x, y, p_93643_);
        }

        public boolean isFocused() {
            return false;
        }

        public void renderWidget(GuiGraphics guiGraphics, int p_283010_, int p_281379_, float p_283453_) {
            int localX = p_283010_ - this.getX();
            int localY = p_281379_ - this.getY();
            boolean hovered = DualTableCraftingScreen.this.lastDestinationGrid != 2 && localX >= 10 && localX <= 20 && localY >= 4 && localY <= 14 || DualTableCraftingScreen.this.lastDestinationGrid == 2 && localX >= 10 && localX <= 20 && localY >= 14 && localY <= 24;
            guiGraphics.blit(this.sprites.get(this.isStateTriggered, hovered), this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, 64, 64);
        }
    }
}

