/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.blocks;

import moonfather.workshop_for_handsome_adventurer.CommonConfig;
import moonfather.workshop_for_handsome_adventurer.Constants;
import moonfather.workshop_for_handsome_adventurer.block_entities.PotionShelfBlockEntity;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.Nullable;

public class PotionShelf
extends ToolRack {
    private final MutableComponent ShelfMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_invalid_item");
    private final MutableComponent MaxedMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_slot_maxed");
    private final MutableComponent RemainingRoomMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_remaining_room");
    private final MutableComponent RemainingItemsMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_remaining_items");
    private final MutableComponent WrongPotionMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_wrong_potion");
    private static final VoxelShape SHAPE_FRAME1N = Block.box((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)3.0);
    private static final VoxelShape SHAPE_FRAME1E = Block.box((double)13.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0);
    private static final VoxelShape SHAPE_FRAME1S = Block.box((double)1.0, (double)1.0, (double)13.0, (double)15.0, (double)15.0, (double)16.0);
    private static final VoxelShape SHAPE_FRAME1W = Block.box((double)0.0, (double)1.0, (double)1.0, (double)3.0, (double)15.0, (double)15.0);

    public PotionShelf() {
        super(6, "potion_shelf", null);
    }

    @Override
    protected boolean canDepositItem(ItemStack mainHandItem) {
        if (mainHandItem == null || mainHandItem.isEmpty()) {
            return true;
        }
        if (mainHandItem.get(DataComponents.POTION_CONTENTS) != null) {
            return true;
        }
        if (mainHandItem.is(Items.GLASS_BOTTLE)) {
            return true;
        }
        return mainHandItem.is(Constants.Tags.ALLOWED_ON_POTION_SHELF);
    }

    public static int getPotionShelfSlot(BlockHitResult blockHitResult) {
        return PotionShelf.getPotionShelfSlot((HitResult)blockHitResult, blockHitResult.getBlockPos(), blockHitResult.getDirection());
    }

    public static int getPotionShelfSlot(HitResult hitResult, BlockPos blockPos, Direction direction) {
        int aboveThisRow = 0;
        double frac = hitResult.getLocation().y - (double)blockPos.getY();
        if (frac < 0.5) {
            aboveThisRow = 3;
        }
        int integral = (int)hitResult.getLocation().z;
        frac = (hitResult.getLocation().z - (double)integral) * (double)direction.getStepX();
        integral = (int)hitResult.getLocation().x;
        int horizontalIndex = (frac -= (hitResult.getLocation().x - (double)integral) * (double)direction.getStepZ()) >= -0.3333333333333333 && frac < 0.0 || frac >= 0.6666666666666666 && frac < 1.0 ? 0 : (frac >= 0.3333333333333333 && frac < 0.6666666666666666 || frac - 1.0 >= 0.3333333333333333 && frac - 1.0 < 0.6666666666666666 || frac + 1.0 >= 0.3333333333333333 && frac + 1.0 < 0.6666666666666666 ? 1 : 2);
        return aboveThisRow + horizontalIndex;
    }

    @Override
    public InteractionResult useWithoutItem(BlockState blockState, Level level, BlockPos pos, Player player, BlockHitResult blockHitResult) {
        PotionShelfBlockEntity BE;
        ItemStack existing;
        if (!(this.canDepositItem(player.getMainHandItem()) || CommonConfig.OffhandInteractsWithPotionShelf.isTrue() && this.canDepositItem(player.getOffhandItem()))) {
            player.displayClientMessage((Component)this.ShelfMessage, true);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        int slot = PotionShelf.getPotionShelfSlot(blockHitResult);
        if (slot >= this.itemCount) {
            slot -= this.itemCount;
        }
        if ((existing = (BE = (PotionShelfBlockEntity)level.getBlockEntity(pos)).GetItem(slot)).isEmpty() && (!player.getMainHandItem().isEmpty() && this.canDepositItem(player.getMainHandItem()) || CommonConfig.OffhandInteractsWithPotionShelf.isTrue() && !player.getOffhandItem().isEmpty() && this.canDepositItem(player.getOffhandItem()))) {
            if (this.canDepositItem(player.getMainHandItem()) && !player.getMainHandItem().isEmpty()) {
                if (player.getMainHandItem().getMaxStackSize() > 1 && player.isCrouching()) {
                    BE.DepositPotionStack(slot, player.getMainHandItem());
                } else {
                    BE.DepositPotion(slot, player.getMainHandItem());
                }
            } else if (player.getOffhandItem().getMaxStackSize() > 1 && player.isCrouching()) {
                BE.DepositPotionStack(slot, player.getOffhandItem());
            } else {
                BE.DepositPotion(slot, player.getOffhandItem());
            }
            player.playSound(SoundEvents.WOOD_PLACE, 0.5f, 0.7f);
            MutableComponent remainingRoomMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_remaining_room");
            player.displayClientMessage((Component)remainingRoomMessage.append(BE.GetRemainingRoom(slot).toString()), true);
        } else if (!existing.isEmpty() || !player.getMainHandItem().isEmpty() || !CommonConfig.OffhandInteractsWithPotionShelf.isFalse() && !player.getOffhandItem().isEmpty()) {
            if (existing.isEmpty() && player.getMainHandItem().isEmpty() && CommonConfig.OffhandInteractsWithPotionShelf.isTrue()) {
                if (this.canDepositItem(player.getOffhandItem())) {
                    if (player.getOffhandItem().getMaxStackSize() > 1 && player.isCrouching()) {
                        BE.DepositPotionStack(slot, player.getOffhandItem());
                    } else {
                        BE.DepositPotion(slot, player.getOffhandItem());
                    }
                    player.playSound(SoundEvents.WOOD_PLACE, 0.5f, 0.7f);
                    MutableComponent remainingRoomMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_remaining_room");
                    player.displayClientMessage((Component)remainingRoomMessage.append(BE.GetRemainingRoom(slot).toString()), true);
                }
            } else if (!existing.isEmpty() && player.getMainHandItem().isEmpty()) {
                if (existing.getMaxStackSize() > 1 && player.isCrouching()) {
                    player.setItemInHand(InteractionHand.MAIN_HAND, BE.TakeOutPotionStack(slot));
                } else {
                    player.setItemInHand(InteractionHand.MAIN_HAND, BE.TakeOutPotion(slot));
                }
                player.playSound(SoundEvents.ITEM_PICKUP, 0.5f, 1.0f);
                if (BE.GetRemainingItems(slot) > 0) {
                    MutableComponent remainingItemsMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_remaining_items");
                    player.displayClientMessage((Component)remainingItemsMessage.append(BE.GetRemainingItems(slot).toString()), true);
                }
            } else if (ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)player.getMainHandItem())) {
                if (BE.IsSlotMaxed(slot)) {
                    player.displayClientMessage((Component)this.MaxedMessage, true);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                if (player.getMainHandItem().getMaxStackSize() > 1 && player.isCrouching()) {
                    BE.DepositPotionStack(slot, player.getMainHandItem());
                } else {
                    BE.DepositPotion(slot, player.getMainHandItem());
                }
                player.playSound(SoundEvents.WOOD_PLACE, 0.5f, 0.7f);
                MutableComponent remainingRoomMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_remaining_room");
                player.displayClientMessage((Component)remainingRoomMessage.append(BE.GetRemainingRoom(slot).toString()), true);
            } else if (player.getOffhandItem().isEmpty() && CommonConfig.OffhandInteractsWithPotionShelf.isTrue()) {
                if (existing.getMaxStackSize() > 1 && player.isCrouching()) {
                    player.setItemInHand(InteractionHand.OFF_HAND, BE.TakeOutPotionStack(slot));
                } else {
                    player.setItemInHand(InteractionHand.OFF_HAND, BE.TakeOutPotion(slot));
                }
                player.playSound(SoundEvents.ITEM_PICKUP, 0.5f, 1.0f);
                if (BE.GetRemainingItems(slot) > 0) {
                    MutableComponent remainingItemsMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_remaining_items");
                    player.displayClientMessage((Component)remainingItemsMessage.append(BE.GetRemainingItems(slot).toString()), true);
                }
            } else if (!player.getOffhandItem().isEmpty() && CommonConfig.OffhandInteractsWithPotionShelf.isTrue() && ItemStack.isSameItemSameComponents((ItemStack)existing, (ItemStack)player.getOffhandItem())) {
                if (BE.IsSlotMaxed(slot)) {
                    player.displayClientMessage((Component)this.MaxedMessage, true);
                    return InteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                if (player.getOffhandItem().getMaxStackSize() > 1 && player.isCrouching()) {
                    BE.DepositPotionStack(slot, player.getOffhandItem());
                } else {
                    BE.DepositPotion(slot, player.getOffhandItem());
                }
                player.playSound(SoundEvents.WOOD_PLACE, 0.5f, 0.7f);
                MutableComponent remainingRoomMessage = Component.translatable((String)"message.workshop_for_handsome_adventurer.shelf_remaining_room");
                player.displayClientMessage((Component)remainingRoomMessage.append(BE.GetRemainingRoom(slot).toString()), true);
            } else {
                player.displayClientMessage((Component)this.WrongPotionMessage, true);
            }
        }
        level.sendBlockUpdated(pos, blockState, blockState, 2);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockState state;
        if (event.getEntity().isCrouching() && (state = event.getLevel().getBlockState(event.getPos())).getBlock() instanceof PotionShelf && event.getFace() == ((Direction)state.getValue((Property)FACING)).getOpposite() && !event.getEntity().getMainHandItem().isEmpty()) {
            event.setUseBlock(TriState.TRUE);
        }
    }

    @Override
    protected void PrepareListOfShapes() {
        this.shapes.clear();
        this.shapes.put(Direction.NORTH, SHAPE_FRAME1N);
        this.shapes.put(Direction.EAST, SHAPE_FRAME1E);
        this.shapes.put(Direction.SOUTH, SHAPE_FRAME1S);
        this.shapes.put(Direction.WEST, SHAPE_FRAME1W);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return Registration.POTION_SHELF_BE.get().create(pos, blockState);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        PotionShelfBlockEntity BE = (PotionShelfBlockEntity)level.getBlockEntity(pos);
        if (BE == null || !state.hasProperty((Property)FACING)) {
            return Items.STICK.getDefaultInstance();
        }
        BlockHitResult bhr = new BlockHitResult(target.getLocation(), ((Direction)state.getValue((Property)FACING)).getOpposite(), pos, true);
        int slot = PotionShelf.getPotionShelfSlot(bhr);
        ItemStack existing = BE.GetItem(slot);
        if (!existing.isEmpty()) {
            return existing.copy();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }
}

