/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.initialization;

import java.util.List;
import java.util.function.Supplier;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomPrimary;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableBottomSecondary;
import moonfather.workshop_for_handsome_adventurer.blocks.AdvancedTableTopSecondary;
import moonfather.workshop_for_handsome_adventurer.blocks.BookShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.DualToolRack;
import moonfather.workshop_for_handsome_adventurer.blocks.PotionShelf;
import moonfather.workshop_for_handsome_adventurer.blocks.SimpleTable;
import moonfather.workshop_for_handsome_adventurer.blocks.ToolRack;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.MissingMappingsHandler;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.SecondCreativeTab;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.WoodTypeLister;
import moonfather.workshop_for_handsome_adventurer.dynamic_resources.config.DynamicAssetCommonConfig;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import moonfather.workshop_for_handsome_adventurer.items.BlockItemEx;
import moonfather.workshop_for_handsome_adventurer.items.WorkstationPlacerItem;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.RegisterEvent;

public class DynamicContentRegistration {
    public static void handleRegistryEvent(RegisterEvent event) {
        if (event.getRegistryKey().equals(Registries.ITEM)) {
            if (DynamicAssetCommonConfig.masterLeverOn()) {
                DynamicContentRegistration.registerBlocksForThirdPartyWood(event);
            }
            MissingMappingsHandler.prepareMappings();
            MissingMappingsHandler.storeForNextTime();
        }
        if (event.getRegistryKey().equals(Registries.CREATIVE_MODE_TAB) && DynamicAssetCommonConfig.masterLeverOn() && SecondCreativeTab.usingSecondTab()) {
            event.register(Registries.CREATIVE_MODE_TAB, ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"tab2"), SecondCreativeTab::getTab);
        }
    }

    private static void registerSinglePrimaryBlockForThirdPartyWood(Block block, String prefix, String wood, List<Supplier<Block>> listForBlockEntities, List<Item> listForCreativeTab) {
        BlockItemEx item = new BlockItemEx(block, new Item.Properties());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)(prefix + wood));
        Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)id, (Object)block);
        Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)id, (Object)((Object)item));
        listForCreativeTab.add((Item)item);
        if (listForBlockEntities != null) {
            listForBlockEntities.add(() -> block);
        }
    }

    private static void registerSingleSupportBlockForThirdPartyWood(Block block, String prefix, String wood) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)(prefix + wood));
        Registry.register((Registry)BuiltInRegistries.BLOCK, (ResourceLocation)id, (Object)block);
    }

    private static void registerBlocksForThirdPartyWood(RegisterEvent event) {
        try {
            boolean wasFrozen = ((MappedRegistry)BuiltInRegistries.BLOCK).frozen;
            ((MappedRegistry)BuiltInRegistries.BLOCK).unfreeze();
            for (String wood : WoodTypeLister.getWoodIds()) {
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new SimpleTable(), "simple_table_", wood, Registration.blocks_table1, SecondCreativeTab.items_table1);
                AdvancedTableBottomPrimary primary = new AdvancedTableBottomPrimary();
                DynamicContentRegistration.registerSingleSupportBlockForThirdPartyWood(primary, "dual_table_bottom_left_", wood);
                DynamicContentRegistration.registerSingleSupportBlockForThirdPartyWood(new AdvancedTableBottomSecondary(), "dual_table_bottom_right_", wood);
                DynamicContentRegistration.registerSingleSupportBlockForThirdPartyWood(new AdvancedTableTopSecondary(), "dual_table_top_left_", wood);
                DynamicContentRegistration.registerSingleSupportBlockForThirdPartyWood(new AdvancedTableTopSecondary(), "dual_table_top_right_", wood);
                WorkstationPlacerItem placer = new WorkstationPlacerItem(wood);
                Registry.register((Registry)BuiltInRegistries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)("workstation_placer_" + wood)), (Object)((Object)placer));
                Registration.blocks_table2.add(() -> primary);
                SecondCreativeTab.items_table2.add(placer);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(ToolRack.create(2, "single"), "tool_rack_single_", wood, Registration.blocks_rack, SecondCreativeTab.items_rack1);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(DualToolRack.create(6, "framed"), "tool_rack_framed_", wood, Registration.blocks_rack, SecondCreativeTab.items_rack2);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(DualToolRack.create(6, "pframed"), "tool_rack_pframed_", wood, Registration.blocks_rack, SecondCreativeTab.items_rack3);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(DualToolRack.create(6, "double"), "tool_rack_double_", wood, Registration.blocks_rack, SecondCreativeTab.items_rack4);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new PotionShelf(), "potion_shelf_", wood, Registration.blocks_pshelf, SecondCreativeTab.items_pshelf);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new BookShelf.Dual("double"), "book_shelf_double_", wood, Registration.blocks_bshelf, SecondCreativeTab.items_bshelf1);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new BookShelf.Dual("open_double"), "book_shelf_open_double_", wood, Registration.blocks_bshelf, SecondCreativeTab.items_bshelf2);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new BookShelf.TopSimple("minimal"), "book_shelf_minimal_", wood, Registration.blocks_bshelf, SecondCreativeTab.items_bshelf3);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new BookShelf.TopSimple("open_minimal"), "book_shelf_open_minimal_", wood, Registration.blocks_bshelf, SecondCreativeTab.items_bshelf4);
                DynamicContentRegistration.registerSinglePrimaryBlockForThirdPartyWood(new BookShelf.TopWithLanterns("with_lanterns"), "book_shelf_with_lanterns_", wood, Registration.blocks_bshelf, SecondCreativeTab.items_bshelf5);
            }
            if (wasFrozen) {
                BuiltInRegistries.BLOCK.freeze();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

