/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import moonfather.workshop_for_handsome_adventurer.items.task_list.items.moving_data.TaskListMessaging;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class TaskListComponent {
    public static final int MAX_PAGE_COUNT = 4;
    private int pageCount;
    private int lastPage;
    private final List<TaskListMessaging.TaskPageDTO> pages = new ArrayList<TaskListMessaging.TaskPageDTO>(4);
    public static final Codec<TaskListComponent> CODEC_FOR_COMPONENT = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("pageCount").forGetter(TaskListComponent::getPageCount), (App)Codec.INT.fieldOf("lastPage").forGetter(TaskListComponent::getLastPageNumber), (App)Codec.list(TaskListMessaging.CODEC_FOR_PAGE, (int)4, (int)4).fieldOf("pages").forGetter(TaskListComponent::getPages)).apply((Applicative)instance, TaskListComponent::new));
    public static final StreamCodec<ByteBuf, TaskListComponent> STREAM_CODEC_FOR_COMPONENT = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, TaskListComponent::getPageCount, (StreamCodec)ByteBufCodecs.INT, TaskListComponent::getLastPageNumber, (StreamCodec)TaskListMessaging.STREAM_CODEC_FOR_PAGE.apply(ByteBufCodecs.list((int)4)), TaskListComponent::getPages, TaskListComponent::new);

    public int getPageCount() {
        return this.pageCount;
    }

    public int getLastPageNumber() {
        return this.lastPage;
    }

    private List<TaskListMessaging.TaskPageDTO> getPages() {
        return this.pages;
    }

    public TaskListComponent(int pageCount, int lastPage, List<TaskListMessaging.TaskPageDTO> pages) {
        this.pageCount = pageCount;
        this.lastPage = lastPage;
        while (this.pages.size() < 4) {
            this.pages.add(null);
        }
        if (pages != null) {
            for (int i = 0; i < 4; ++i) {
                this.pages.set(i, new TaskListMessaging.TaskPageDTO(pages.get(i).pageNumber(), pages.get(i).items()));
            }
        } else {
            for (int i = 0; i < 4; ++i) {
                this.pages.set(i, new TaskListMessaging.TaskPageDTO(i + 1, null));
                for (int j = 0; j < 6; ++j) {
                    this.pages.get(i).items().set(j, TaskListMessaging.TaskItemDTO.empty());
                }
            }
        }
    }

    public int hashCode() {
        Integer base = this.pageCount * 100 + this.lastPage;
        if (this.pageCount == 1) {
            return Objects.hash(base, this.pages.get(0));
        }
        if (this.pageCount == 2) {
            return Objects.hash(base, this.pages.get(0), this.pages.get(1));
        }
        if (this.pageCount == 3) {
            return Objects.hash(base, this.pages.get(0), this.pages.get(1), this.pages.get(2));
        }
        if (this.pageCount == 4) {
            return Objects.hash(base, this.pages.get(0), this.pages.get(1), this.pages.get(2), this.pages.get(3));
        }
        if (this.pageCount == 5) {
            return Objects.hash(base, this.pages.get(0), this.pages.get(1), this.pages.get(2), this.pages.get(3), this.pages.get(3));
        }
        if (this.pageCount == 6) {
            return Objects.hash(base, this.pages.get(0), this.pages.get(1), this.pages.get(2), this.pages.get(3), this.pages.get(3), this.pages.get(5));
        }
        return -1;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TaskListComponent) {
            TaskListComponent comp2 = (TaskListComponent)obj;
            if (this.lastPage != comp2.lastPage) {
                return false;
            }
            if (this.pageCount == comp2.pageCount) {
                for (int i = 0; i < this.pageCount; ++i) {
                    if (this.pages.get(i).equals(comp2.pages.get(i))) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public TaskListComponent makeCopy(int skipPage, int lastPageFromScreen) {
        TaskListComponent copy = new TaskListComponent(this.pageCount, lastPageFromScreen, null);
        copy.pageCount = this.pageCount;
        copy.lastPage = this.lastPage;
        for (int i = 0; i < 4; ++i) {
            if (i + 1 != skipPage) {
                copy.pages.set(i, new TaskListMessaging.TaskPageDTO(this.pages.get(i).pageNumber(), this.pages.get(i).items()));
                continue;
            }
            copy.pages.set(i, new TaskListMessaging.TaskPageDTO(this.pages.get(i).pageNumber(), null));
        }
        return copy;
    }

    public void updatePage(int pageNumber, TaskListMessaging.TaskPageDTO value) {
        this.pages.set(pageNumber - 1, new TaskListMessaging.TaskPageDTO(pageNumber, value.items()));
    }

    public TaskListComponent addPages(int pagesToAdd) {
        return new TaskListComponent(this.pageCount + pagesToAdd, this.lastPage, this.pages);
    }

    public List<TaskListMessaging.TaskPageDTO> getAllPages() {
        return this.pages;
    }

    public void setLastPage(int pageNumber) {
        this.lastPage = pageNumber;
    }
}

