/*
 * Decompiled with CFR 0.152.
 */
package moonfather.workshop_for_handsome_adventurer.other;

import moonfather.workshop_for_handsome_adventurer.CommonConfig;
import moonfather.workshop_for_handsome_adventurer.initialization.Registration;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

public class UnsupportedWoodRecipe
extends CustomRecipe {
    private final TagKey<Item> supportedPlanks = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"workshop_for_handsome_adventurer", (String)"supported_planks"));

    public UnsupportedWoodRecipe() {
        super(CraftingBookCategory.MISC);
    }

    public UnsupportedWoodRecipe(CraftingBookCategory craftingBookCategory) {
        super(CraftingBookCategory.MISC);
    }

    public boolean matches(CraftingInput craftingInput, Level level) {
        if (!((Boolean)CommonConfig.SimpleTableReplacesVanillaTable.get()).booleanValue()) {
            return false;
        }
        if (craftingInput.height() < 2 || craftingInput.width() < 2) {
            return false;
        }
        for (int ys = 0; ys <= craftingInput.height() - 2; ++ys) {
            for (int xs = 0; xs <= craftingInput.width() - 2; ++xs) {
                boolean ok = true;
                for (int y = 0; y <= craftingInput.height() - 1; ++y) {
                    for (int x = 0; x <= craftingInput.width() - 1; ++x) {
                        boolean isPlank = this.isAnUnsupportedPlank(craftingInput.getItem(y * craftingInput.width() + x));
                        boolean isEmpty = craftingInput.getItem(y * craftingInput.width() + x).isEmpty();
                        ok = x >= xs && x <= xs + 1 && y >= ys && y <= ys + 1 ? ok && isPlank : ok && isEmpty;
                    }
                }
                if (!ok) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAnUnsupportedPlank(ItemStack item) {
        return item.is(ItemTags.PLANKS) && !item.is(this.supportedPlanks);
    }

    public ItemStack assemble(CraftingInput craftingInput, HolderLookup.Provider lookupProvider) {
        if (!((Boolean)CommonConfig.SimpleTableReplacesVanillaTable.get()).booleanValue()) {
            return null;
        }
        return new ItemStack((ItemLike)Blocks.CRAFTING_TABLE);
    }

    public boolean canCraftInDimensions(int d1, int d2) {
        return d1 >= 2 && d2 >= 2;
    }

    public RecipeSerializer<?> getSerializer() {
        return Registration.TABLE_RECIPE.get();
    }
}

