/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.blocks;

import net.enderitemc.enderitemod.blocks.RespawnAnchorUtils.EnderiteRespawnAnchorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RespawnAnchorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.BlockHitResult;

public class EnderiteRespawnAnchor
extends RespawnAnchorBlock
implements EntityBlock {
    public EnderiteRespawnAnchor(BlockBehaviour.Properties settings) {
        super(settings.mapColor(MapColor.COLOR_BLACK).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(50.0f, 1200.0f).lightLevel(state -> RespawnAnchorBlock.getScaledChargeLevel((BlockState)state, (int)15)));
    }

    private static boolean isChargeItem(ItemStack stack) {
        return stack.getItem() == Items.ENDER_PEARL;
    }

    protected InteractionResult useItemOn(ItemStack stack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (EnderiteRespawnAnchor.isChargeItem(stack) && EnderiteRespawnAnchor.canCharge(state)) {
            BlockEntity blockEntity;
            EnderiteRespawnAnchor.charge((Entity)player, (Level)world, (BlockPos)pos, (BlockState)state);
            stack.consume(1, (LivingEntity)player);
            if (world.isClientSide() && (blockEntity = world.getBlockEntity(pos)) instanceof EnderiteRespawnAnchorBlockEntity) {
                EnderiteRespawnAnchorBlockEntity eRA = (EnderiteRespawnAnchorBlockEntity)blockEntity;
                eRA.charge = (Integer)world.getBlockState(pos).getValue((Property)CHARGE);
            }
            return InteractionResult.SUCCESS;
        }
        if (hand == InteractionHand.MAIN_HAND && EnderiteRespawnAnchor.isChargeItem(player.getItemInHand(InteractionHand.OFF_HAND)) && EnderiteRespawnAnchor.canCharge(state)) {
            return InteractionResult.PASS;
        }
        return InteractionResult.TRY_WITH_EMPTY_HAND;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level world, BlockPos pos, Player player, BlockHitResult hit) {
        if ((Integer)state.getValue((Property)CHARGE) == 0) {
            return InteractionResult.PASS;
        }
        if (!EnderiteRespawnAnchor.isEnd(world)) {
            if (!world.isClientSide()) {
                this.explode(state, world, pos);
            }
            return InteractionResult.SUCCESS;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayerEntity = (ServerPlayer)player;
            ServerPlayer.RespawnConfig respawn = serverPlayerEntity.getRespawnConfig();
            ServerPlayer.RespawnConfig respawn2 = new ServerPlayer.RespawnConfig(LevelData.RespawnData.of((ResourceKey)world.dimension(), (BlockPos)pos, (float)0.0f, (float)0.0f), false);
            if (respawn == null || !respawn.isSamePosition(respawn2)) {
                serverPlayerEntity.setRespawnPosition(respawn2, true);
                world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.RESPAWN_ANCHOR_SET_SPAWN, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS_SERVER;
            }
        }
        return InteractionResult.CONSUME;
    }

    public static boolean isEnd(Level world) {
        return world.dimensionTypeRegistration().is(BuiltinDimensionTypes.END);
    }

    public static boolean shouldRespawnPlayer(Level world, boolean is_dead) {
        return EnderiteRespawnAnchor.isEnd(world) && is_dead;
    }

    private static boolean canCharge(BlockState state) {
        return (Integer)state.getValue((Property)CHARGE) < 4;
    }

    private void explode(BlockState state, Level world, BlockPos explodedPos) {
        world.removeBlock(explodedPos, false);
        world.explode(null, (double)explodedPos.getX(), (double)explodedPos.getY(), (double)explodedPos.getZ(), 6.9f, true, Level.ExplosionInteraction.BLOCK);
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EnderiteRespawnAnchorBlockEntity(pos, state);
    }

    protected boolean propagatesSkylightDown(BlockState state) {
        return false;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        if ((Integer)state.getValue((Property)CHARGE) == 0) {
            return;
        }
        if (world.getBlockState(pos.above()).isSolid()) {
            return;
        }
        double d = (double)pos.getX() + random.nextDouble();
        double e = (double)pos.getY() + 0.8;
        double f = (double)pos.getZ() + random.nextDouble();
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, d, e, f, 0.0, 0.0, 0.0);
    }
}

