/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.blocks.RespawnAnchorUtils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.enderitemc.enderitemod.blocks.RespawnAnchorUtils.EnderiteRespawnAnchorBlockEntity;
import net.enderitemc.enderitemod.blocks.RespawnAnchorUtils.EnderiteRespawnAnchorRenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class EnderiteRespawnAnchorRenderer<T extends EnderiteRespawnAnchorBlockEntity>
implements BlockEntityRenderer<T, EnderiteRespawnAnchorRenderState> {
    public EnderiteRespawnAnchorRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public EnderiteRespawnAnchorRenderState createRenderState() {
        return new EnderiteRespawnAnchorRenderState();
    }

    public void updateRenderState(T blockEntity, EnderiteRespawnAnchorRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(blockEntity, (BlockEntityRenderState)state, tickProgress, cameraPos, crumblingOverlay);
        state.shouldRenderPortal = ((EnderiteRespawnAnchorBlockEntity)((Object)blockEntity)).shouldRenderPortal() && ((EnderiteRespawnAnchorBlockEntity)((Object)blockEntity)).isCharged();
    }

    public void render(EnderiteRespawnAnchorRenderState state, PoseStack matrixStack, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.shouldRenderPortal && state.breakProgress == null) {
            queue.submitCustomGeometry(matrixStack, this.getLayer(), this::renderSides);
        }
    }

    private void renderSides(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
        Matrix4f matrix = matricesEntry.pose();
        float f = this.getSideOffset();
        float g = this.getTopYOffset();
        this.renderSide(matrix, vertexConsumer, f, 1.0f - f, g, g, 1.0f - f, 1.0f - f, f, f);
    }

    private void renderSide(Matrix4f model, VertexConsumer vertices, float x1, float x2, float y1, float y2, float z1, float z2, float z3, float z4) {
        vertices.addVertex(model, x1, y1, z1);
        vertices.addVertex(model, x2, y1, z2);
        vertices.addVertex(model, x2, y2, z3);
        vertices.addVertex(model, x1, y2, z4);
    }

    protected float getTopYOffset() {
        return 1.001f;
    }

    protected float getSideOffset() {
        return 0.125f;
    }

    protected RenderType getLayer() {
        return RenderType.endPortal();
    }
}

