/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.forge;

import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import net.enderitemc.enderitemod.EnderiteMod;
import net.enderitemc.enderitemod.blocks.RespawnAnchorUtils.EnderiteRespawnAnchorRenderer;
import net.enderitemc.enderitemod.forge.modIntegrations.ClothConfigImplementation;
import net.enderitemc.enderitemod.forge.modIntegrations.ShulkerBoxTooltipImplementation;
import net.enderitemc.enderitemod.renderer.RendererRegistries;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxBlockEntityRenderer;
import net.enderitemc.enderitemod.tools.EnderiteTools;
import net.minecraft.client.renderer.special.SpecialModelRenderers;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.ShearsDispenseItemBehavior;
import net.minecraft.core.dispenser.ShulkerBoxDispenseBehavior;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.client.event.RegisterConditionalItemModelPropertyEvent;
import net.neoforged.neoforge.client.event.RegisterItemModelsEvent;
import net.neoforged.neoforge.client.event.RegisterRangeSelectItemModelPropertyEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="enderitemod")
public class EnderiteModForge {
    private static final Logger LOGGER = LogManager.getLogger();

    public EnderiteModForge(IEventBus modBus) {
        EnderiteMod.init();
        modBus.addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)EnderiteMod.ENDERITE_SHULKER_BOX.get()), (DispenseItemBehavior)new ShulkerBoxDispenseBehavior());
            DispenserBlock.registerBehavior((ItemLike)((ItemLike)EnderiteTools.ENDERITE_SHEAR.get()), (DispenseItemBehavior)new ShearsDispenseItemBehavior());
        });
    }

    @EventBusSubscriber(value={Dist.CLIENT}, modid="enderitemod")
    public static class RegistryEventsClient {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EnderiteMod.clientInit();
            event.enqueueWork(() -> {
                BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EnderiteMod.ENDERITE_SHULKER_BOX_BLOCK_ENTITY.get()), EnderiteShulkerBoxBlockEntityRenderer::new);
                BlockEntityRendererRegistry.register((BlockEntityType)((BlockEntityType)EnderiteMod.ENDERITE_RESPAWN_ANCHOR_BLOCK_ENTITY.get()), EnderiteRespawnAnchorRenderer::new);
                if (ModList.get().isLoaded("cloth_config")) {
                    ClothConfigImplementation.registerEntryPoint(event);
                }
                if (ModList.get().isLoaded("shulkerboxtooltip")) {
                    ShulkerBoxTooltipImplementation.registerEntryPoint(event);
                }
            });
        }

        @SubscribeEvent
        public static void setupNumericProviders(RegisterRangeSelectItemModelPropertyEvent event) {
            event.register(RendererRegistries.ENDERITE_CHARGE.id(), RendererRegistries.ENDERITE_CHARGE.codec());
            event.register(RendererRegistries.ENDERITE_CROSSBOW_PULL.id(), RendererRegistries.ENDERITE_CROSSBOW_PULL.codec());
            event.register(RendererRegistries.ENDERITE_BOW_PULL.id(), RendererRegistries.ENDERITE_BOW_PULL.codec());
        }

        @SubscribeEvent
        public static void setupConditionalProviders(RegisterConditionalItemModelPropertyEvent event) {
            event.register(RendererRegistries.ENDERITE_PLAYER_SNEAKS.id(), RendererRegistries.ENDERITE_PLAYER_SNEAKS.codec());
        }

        @SubscribeEvent
        public static void registerItemModels(RegisterItemModelsEvent event) {
            SpecialModelRenderers.ID_MAPPER.put((Object)RendererRegistries.ENDERITE_SHIELD.id(), RendererRegistries.ENDERITE_SHIELD.codec());
        }
    }
}

