/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.mixin;

import java.util.Optional;
import net.enderitemc.enderitemod.blocks.EnderiteRespawnAnchor;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayer.class})
public class EnderiteRespawnAnchorMixin {
    @Inject(at={@At(value="HEAD")}, method={"findRespawnAndUseSpawnBlock(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/server/level/ServerPlayer$RespawnConfig;Z)Ljava/util/Optional;"}, cancellable=true)
    private static void isEnd(ServerLevel world, ServerPlayer.RespawnConfig respawn, boolean is_dead, CallbackInfoReturnable<Optional<ServerPlayer.RespawnPosAngle>> cir) {
        BlockPos pos = respawn.respawnData().pos();
        BlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        boolean spawnForced = respawn.forced();
        if (block instanceof EnderiteRespawnAnchor && (spawnForced || (Integer)blockState.getValue((Property)EnderiteRespawnAnchor.CHARGE) > 0) && EnderiteRespawnAnchor.shouldRespawnPlayer((Level)world, is_dead)) {
            Optional optional = EnderiteRespawnAnchor.findStandUpPosition((EntityType)EntityType.PLAYER, (CollisionGetter)world, (BlockPos)pos);
            if (!spawnForced && optional.isPresent()) {
                world.setBlock(pos, (BlockState)blockState.setValue((Property)EnderiteRespawnAnchor.CHARGE, (Comparable)Integer.valueOf((Integer)blockState.getValue((Property)EnderiteRespawnAnchor.CHARGE) - 1)), 3);
            }
            cir.setReturnValue(optional.map(respawnPos -> ServerPlayer.RespawnPosAngle.of((Vec3)respawnPos, (BlockPos)pos, (float)35.0f)));
        }
    }
}

