/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.renderer;

import com.mojang.serialization.MapCodec;
import net.enderitemc.enderitemod.EnderiteMod;
import net.enderitemc.enderitemod.component.EnderiteDataComponents;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public record EnderiteChargeProperty() implements RangeSelectItemModelProperty
{
    public static final MapCodec<EnderiteChargeProperty> CODEC = MapCodec.unit((Object)new EnderiteChargeProperty());

    public float get(ItemStack stack, @Nullable ClientLevel world, @Nullable ItemOwner context, int seed) {
        float charge = ((Number)stack.getOrDefault((DataComponentType)EnderiteDataComponents.TELEPORT_CHARGE.get(), (Object)0)).intValue();
        if (charge <= 0.0f || EnderiteMod.CONFIG.tools.maxTeleportCharge <= 0) {
            return -1.0f;
        }
        return charge / (float)EnderiteMod.CONFIG.tools.maxTeleportCharge;
    }

    public MapCodec<EnderiteChargeProperty> type() {
        return CODEC;
    }
}

