/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.renderer;

import com.mojang.serialization.MapCodec;
import net.enderitemc.enderitemod.tools.EnderiteCrossbow;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.client.renderer.item.properties.numeric.UseDuration;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class EnderiteCrossbowPullProperty
implements RangeSelectItemModelProperty {
    public static final MapCodec<EnderiteCrossbowPullProperty> CODEC = MapCodec.unit((Object)new EnderiteCrossbowPullProperty());

    public float get(ItemStack stack, @Nullable ClientLevel world, @Nullable ItemOwner context, int seed) {
        if (context == null || context.asLivingEntity() == null) {
            return 0.0f;
        }
        if (EnderiteCrossbow.isCharged((ItemStack)stack)) {
            return 0.0f;
        }
        LivingEntity holder = context.asLivingEntity();
        int i = EnderiteCrossbow.getPullTime(stack, holder);
        return (float)UseDuration.useDuration((ItemStack)stack, (LivingEntity)holder) / (float)i;
    }

    public MapCodec<EnderiteCrossbowPullProperty> type() {
        return CODEC;
    }
}

