/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Unit;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class EnderiteShieldRenderer
implements SpecialModelRenderer<DataComponentMap> {
    public static final Material ENDERITE_SHIELD_BASE = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)"enderitemod", (String)"entity/enderite_shield_base"));
    public static final Material ENDERITE_SHIELD_BASE_NO_PATTERN = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)"enderitemod", (String)"entity/enderite_shield_base_nopattern"));
    private final MaterialSet spriteHolder;
    private final ShieldModel model;
    private final boolean charged;

    public EnderiteShieldRenderer(MaterialSet spriteHolder, ShieldModel model, boolean charged) {
        this.spriteHolder = spriteHolder;
        this.model = model;
        this.charged = charged;
    }

    @Nullable
    public DataComponentMap getData(ItemStack itemStack) {
        return itemStack.immutableComponents();
    }

    public void render(@Nullable DataComponentMap componentMap, ItemDisplayContext displayContext, PoseStack matrixStack, SubmitNodeCollector queue, int light, int overlay, boolean glint, int i) {
        BannerPatternLayers bannerPatternsComponent = componentMap != null ? (BannerPatternLayers)componentMap.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY) : BannerPatternLayers.EMPTY;
        DyeColor dyeColor = componentMap != null ? (DyeColor)componentMap.get(DataComponents.BASE_COLOR) : null;
        boolean bl2 = !bannerPatternsComponent.layers().isEmpty() || dyeColor != null;
        matrixStack.pushPose();
        matrixStack.scale(1.0f, -1.0f, -1.0f);
        Material spriteIdentifier = bl2 ? ENDERITE_SHIELD_BASE : ENDERITE_SHIELD_BASE_NO_PATTERN;
        queue.submitModelPart(this.model.handle(), matrixStack, this.model.renderType(spriteIdentifier.atlasLocation()), light, overlay, this.spriteHolder.get(spriteIdentifier), false, glint, -1, null, i);
        if (bl2) {
            BannerRenderer.submitPatterns((MaterialSet)this.spriteHolder, (PoseStack)matrixStack, (SubmitNodeCollector)queue, (int)light, (int)overlay, (Model)this.model, (Object)Unit.INSTANCE, (Material)spriteIdentifier, (boolean)false, (DyeColor)Objects.requireNonNullElse(dyeColor, DyeColor.WHITE), (BannerPatternLayers)bannerPatternsComponent, (boolean)glint, null, (int)i);
        } else {
            queue.submitModelPart(this.model.plate(), matrixStack, this.model.renderType(spriteIdentifier.atlasLocation()), light, overlay, this.spriteHolder.get(spriteIdentifier), false, glint, -1, null, i);
        }
        if (this.charged && (displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND)) {
            queue.submitCustomGeometry(matrixStack, RenderType.endPortal(), this::renderSides);
        }
        matrixStack.popPose();
    }

    public void getExtents(Set<Vector3f> vertices) {
        PoseStack matrixStack = new PoseStack();
        matrixStack.scale(1.0f, -1.0f, -1.0f);
        this.model.root().getExtentsForGui(matrixStack, vertices);
    }

    private void renderSides(PoseStack.Pose matrixEntry, VertexConsumer vertexConsumer) {
        Matrix4f matrix = matrixEntry.pose();
        float border = 1.0f;
        float f = (-6.0f + border) / 16.0f;
        float g = (-11.0f + border) / 16.0f;
        float h = -0.125f;
        float df = (12.0f - 2.0f * border) / 16.0f;
        float dg = (22.0f - 2.0f * border) / 16.0f;
        float dh = -6.25E-5f;
        this.renderSide(matrix, vertexConsumer, f, f + df, g + dg, g, h + dh);
    }

    private void renderSide(Matrix4f model, VertexConsumer vertices, float x1, float x2, float y1, float y2, float z) {
        vertices.addVertex(model, x1, y1, z);
        vertices.addVertex(model, x2, y1, z);
        vertices.addVertex(model, x2, y2, z);
        vertices.addVertex(model, x1, y2, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(boolean charged) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("charged", (Object)false).forGetter(Unbaked::charged)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return CODEC;
        }

        public SpecialModelRenderer<?> bake(SpecialModelRenderer.BakingContext context) {
            return new EnderiteShieldRenderer(context.materials(), new ShieldModel(context.entityModelSet().bakeLayer(ModelLayers.SHIELD)), this.charged);
        }
    }
}

