/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.shulker;

import java.util.List;
import java.util.stream.IntStream;
import net.enderitemc.enderitemod.EnderiteMod;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxBlock;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxScreenHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.ContainerUser;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EnderiteShulkerBoxBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private static final int[] AVAILABLE_SLOTS = IntStream.range(0, 45).toArray();
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)45, (Object)ItemStack.EMPTY);
    private int viewerCount;
    private AnimationStage animationStage = AnimationStage.CLOSED;
    private float animationProgress;
    private float prevAnimationProgress;

    public EnderiteShulkerBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EnderiteMod.ENDERITE_SHULKER_BOX_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, EnderiteShulkerBoxBlockEntity be) {
        be.updateAnimation(world, pos, state);
    }

    protected void updateAnimation(Level world, BlockPos pos, BlockState state) {
        this.prevAnimationProgress = this.animationProgress;
        switch (this.animationStage.ordinal()) {
            case 0: {
                this.animationProgress = 0.0f;
                break;
            }
            case 1: {
                this.animationProgress += 0.1f;
                if (this.prevAnimationProgress == 0.0f) {
                    this.updateNeighborStates(world, pos, state);
                }
                if (this.animationProgress >= 1.0f) {
                    this.animationStage = AnimationStage.OPENED;
                    this.animationProgress = 1.0f;
                    this.updateNeighborStates(world, pos, state);
                }
                this.pushEntities(world, pos, state);
                break;
            }
            case 3: {
                this.animationProgress -= 0.1f;
                if (this.prevAnimationProgress == 1.0f) {
                    this.updateNeighborStates(world, pos, state);
                }
                if (!(this.animationProgress <= 0.0f)) break;
                this.animationStage = AnimationStage.CLOSED;
                this.animationProgress = 0.0f;
                this.updateNeighborStates(world, pos, state);
                break;
            }
            case 2: {
                this.animationProgress = 1.0f;
            }
        }
    }

    public AnimationStage getAnimationStage() {
        return this.animationStage;
    }

    public AABB getBoundingBox(BlockState state) {
        Vec3 vec3d = new Vec3(0.5, 0.0, 0.5);
        return Shulker.getProgressAabb((float)1.0f, (Direction)((Direction)state.getValue((Property)EnderiteShulkerBoxBlock.FACING)), (float)(0.5f * this.getAnimationProgress(1.0f)), (Vec3)vec3d);
    }

    private void pushEntities(Level world, BlockPos pos, BlockState state) {
        Direction direction;
        AABB box;
        List list;
        if (state.getBlock() instanceof EnderiteShulkerBoxBlock && !(list = world.getEntities(null, box = Shulker.getProgressDeltaAabb((float)1.0f, (Direction)(direction = (Direction)state.getValue((Property)EnderiteShulkerBoxBlock.FACING)), (float)this.prevAnimationProgress, (float)this.animationProgress, (Vec3)pos.getBottomCenter()))).isEmpty()) {
            for (Entity entity : list) {
                if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                entity.move(MoverType.SHULKER_BOX, new Vec3((box.getXsize() + 0.01) * (double)direction.getStepX(), (box.getYsize() + 0.01) * (double)direction.getStepY(), (box.getZsize() + 0.01) * (double)direction.getStepZ()));
            }
        }
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean triggerEvent(int type, int data) {
        if (type == 1) {
            this.viewerCount = data;
            if (data == 0) {
                this.animationStage = AnimationStage.CLOSING;
            }
            if (data == 1) {
                this.animationStage = AnimationStage.OPENING;
            }
            return true;
        }
        return super.triggerEvent(type, data);
    }

    private void updateNeighborStates(Level world, BlockPos pos, BlockState state) {
        state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
        world.updateNeighborsAt(pos, state.getBlock());
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
    }

    public void startOpen(ContainerUser player) {
        if (!this.remove && !player.getLivingEntity().isSpectator()) {
            if (this.viewerCount < 0) {
                this.viewerCount = 0;
            }
            ++this.viewerCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.viewerCount);
            if (this.viewerCount == 1) {
                this.level.gameEvent((Entity)player.getLivingEntity(), (Holder)GameEvent.CONTAINER_OPEN, this.worldPosition);
                this.level.playSound((Entity)((Player)null), this.worldPosition, SoundEvents.SHULKER_BOX_OPEN, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.72f);
            }
        }
    }

    public void stopOpen(ContainerUser player) {
        if (!this.remove && !player.getLivingEntity().isSpectator()) {
            --this.viewerCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.viewerCount);
            if (this.viewerCount <= 0) {
                this.level.gameEvent((Entity)player.getLivingEntity(), (Holder)GameEvent.CONTAINER_CLOSE, this.worldPosition);
                this.level.playSound((Entity)((Player)null), this.worldPosition, SoundEvents.SHULKER_BOX_CLOSE, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.72f);
            }
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.enderitemod.enderiteShulkerBox");
    }

    public void loadAdditional(ValueInput nbt) {
        super.loadAdditional(nbt);
        this.readInventoryNbt(nbt);
    }

    public void saveAdditional(ValueOutput nbt) {
        super.saveAdditional(nbt);
        if (!this.trySaveLootTable(nbt)) {
            ContainerHelper.saveAllItems((ValueOutput)nbt, this.inventory, (boolean)false);
        }
    }

    public void readInventoryNbt(ValueInput readView) {
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(readView)) {
            ContainerHelper.loadAllItems((ValueInput)readView, this.inventory);
        }
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    public int[] getSlotsForFace(Direction side) {
        return AVAILABLE_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return !(Block.byItem((Item)stack.getItem()) instanceof EnderiteShulkerBoxBlock) && !(Block.byItem((Item)stack.getItem()) instanceof ShulkerBoxBlock);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return true;
    }

    public float getAnimationProgress(float f) {
        return Mth.lerp((float)f, (float)this.prevAnimationProgress, (float)this.animationProgress);
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new EnderiteShulkerBoxScreenHandler(syncId, playerInventory, (Container)this);
    }

    public boolean suffocates() {
        return this.animationStage == AnimationStage.CLOSED;
    }

    public static enum AnimationStage {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

