/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.shulker;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Set;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxBlockEntity;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.blockentity.state.ShulkerBoxRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.MaterialSet;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class EnderiteShulkerBoxBlockEntityRenderer
implements BlockEntityRenderer<EnderiteShulkerBoxBlockEntity, ShulkerBoxRenderState> {
    private final MaterialSet materials;
    private final ShulkerBoxBlockModel model;
    private static final ResourceLocation ENDERITE_SHULKER_TEXTURE = ResourceLocation.parse((String)"entity/shulker/enderite_shulker");

    public EnderiteShulkerBoxBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.materials = ctx.materials();
        this.model = new ShulkerBoxBlockModel(ctx.bakeLayer(ModelLayers.SHULKER_BOX));
    }

    public ShulkerBoxRenderState createRenderState() {
        return new ShulkerBoxRenderState();
    }

    public void updateRenderState(EnderiteShulkerBoxBlockEntity shulkerBoxBlockEntity, ShulkerBoxRenderState shulkerBoxBlockEntityRenderState, float f, Vec3 vec3d, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlayCommand) {
        super.extractRenderState((BlockEntity)shulkerBoxBlockEntity, (BlockEntityRenderState)shulkerBoxBlockEntityRenderState, f, vec3d, crumblingOverlayCommand);
        shulkerBoxBlockEntityRenderState.direction = (Direction)shulkerBoxBlockEntity.getBlockState().getValueOrElse((Property)ShulkerBoxBlock.FACING, (Comparable)Direction.UP);
        shulkerBoxBlockEntityRenderState.progress = shulkerBoxBlockEntity.getAnimationProgress(f);
    }

    public void render(ShulkerBoxRenderState shulkerBoxBlockEntityRenderState, PoseStack matrixStack, SubmitNodeCollector orderedRenderCommandQueue, CameraRenderState cameraRenderState) {
        Material spriteIdentifier = new Material(Sheets.SHULKER_SHEET, ENDERITE_SHULKER_TEXTURE);
        this.render(matrixStack, orderedRenderCommandQueue, shulkerBoxBlockEntityRenderState.lightCoords, OverlayTexture.NO_OVERLAY, shulkerBoxBlockEntityRenderState.direction, shulkerBoxBlockEntityRenderState.progress, shulkerBoxBlockEntityRenderState.breakProgress, spriteIdentifier, 0);
    }

    public void render(PoseStack matrices, SubmitNodeCollector queue, int light, int overlay, Direction facing, float openness, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay, Material spriteId, int i) {
        matrices.pushPose();
        this.setTransforms(matrices, facing, openness);
        queue.submitModel((Model)this.model, (Object)Float.valueOf(openness), matrices, spriteId.renderType(arg_0 -> ((ShulkerBoxBlockModel)this.model).renderType(arg_0)), light, overlay, -1, this.materials.get(spriteId), i, crumblingOverlay);
        matrices.popPose();
    }

    private void setTransforms(PoseStack matrices, Direction facing, float openness) {
        matrices.translate(0.5f, 0.5f, 0.5f);
        float f = 0.9995f;
        matrices.scale(0.9995f, 0.9995f, 0.9995f);
        matrices.mulPose((Quaternionfc)facing.getRotation());
        matrices.scale(1.0f, -1.0f, -1.0f);
        matrices.translate(0.0f, -1.0f, 0.0f);
        this.model.setAngles(Float.valueOf(openness));
    }

    public void collectVertices(Direction facing, float openness, Set<Vector3f> vertices) {
        PoseStack matrixStack = new PoseStack();
        this.setTransforms(matrixStack, facing, openness);
        this.model.root().getExtentsForGui(matrixStack, vertices);
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ShulkerBoxBlockModel
    extends Model<Float> {
        private final ModelPart lid;

        public ShulkerBoxBlockModel(ModelPart root) {
            super(root, RenderType::entityCutoutNoCull);
            this.lid = root.getChild("lid");
        }

        public void setAngles(Float float_) {
            super.setupAnim((Object)float_);
            this.lid.setPos(0.0f, 24.0f - float_.floatValue() * 0.5f * 16.0f, 0.0f);
            this.lid.yRot = 270.0f * float_.floatValue() * ((float)Math.PI / 180);
        }
    }
}

