/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.tools;

import java.util.List;
import java.util.Optional;
import net.enderitemc.enderitemod.EnderiteMod;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EnderiteCrossbow
extends CrossbowItem {
    private boolean charged = false;
    private boolean loaded = false;
    private static final CrossbowItem.ChargingSounds DEFAULT_LOADING_SOUNDS = new CrossbowItem.ChargingSounds(Optional.of(SoundEvents.CROSSBOW_LOADING_START), Optional.of(SoundEvents.CROSSBOW_LOADING_MIDDLE), Optional.of(SoundEvents.CROSSBOW_LOADING_END));

    public EnderiteCrossbow(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        ChargedProjectiles chargedProjectilesComponent = (ChargedProjectiles)itemStack.get(DataComponents.CHARGED_PROJECTILES);
        if (chargedProjectilesComponent != null && !chargedProjectilesComponent.isEmpty()) {
            this.performShooting(world, (LivingEntity)user, hand, itemStack, EnderiteCrossbow.getSpeed(chargedProjectilesComponent), 1.0f, null);
            return InteractionResult.CONSUME.heldItemTransformedTo(itemStack);
        }
        if (!user.getProjectile(itemStack).isEmpty()) {
            this.charged = false;
            this.loaded = false;
            user.startUsingItem(hand);
            return InteractionResult.CONSUME.heldItemTransformedTo(itemStack);
        }
        return InteractionResult.FAIL;
    }

    private static float getSpeed(ChargedProjectiles stack) {
        return stack.contains(Items.FIREWORK_ROCKET) ? 2.1f : EnderiteMod.CONFIG.tools.enderiteCrossbowArrowSpeed;
    }

    public boolean releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        int i = this.getUseDuration(stack, user) - remainingUseTicks;
        float f = EnderiteCrossbow.getPullProgress(i, stack, user);
        if (f >= 1.0f && !EnderiteCrossbow.isCharged((ItemStack)stack) && EnderiteCrossbow.loadProjectiles(user, stack)) {
            CrossbowItem.ChargingSounds loadingSounds = this.getChargingSounds(stack);
            loadingSounds.end().ifPresent(sound -> world.playSound(null, user.getX(), user.getY(), user.getZ(), (SoundEvent)sound.value(), user.getSoundSource(), 1.0f, 1.0f / (world.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f));
            return true;
        }
        return false;
    }

    private static boolean loadProjectiles(LivingEntity shooter, ItemStack crossbow) {
        List list = EnderiteCrossbow.draw((ItemStack)crossbow, (ItemStack)shooter.getProjectile(crossbow), (LivingEntity)shooter);
        if (!list.isEmpty()) {
            crossbow.set(DataComponents.CHARGED_PROJECTILES, (Object)ChargedProjectiles.of((List)list));
            return true;
        }
        return false;
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float speed, float divergence, float yaw, @Nullable LivingEntity target) {
        Vector3f vector3f;
        if (target != null) {
            double d = target.getX() - shooter.getX();
            double e = target.getZ() - shooter.getZ();
            double f = Math.sqrt(d * d + e * e);
            double g = target.getY(0.3333333333333333) - projectile.getY() + f * (double)0.2f;
            vector3f = EnderiteCrossbow.calcVelocity(shooter, new Vec3(d, g, e), yaw);
        } else {
            Vec3 vec3d = shooter.getUpVector(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(yaw * ((float)Math.PI / 180)), vec3d.x, vec3d.y, vec3d.z);
            Vec3 vec3d2 = shooter.getViewVector(1.0f);
            vector3f = vec3d2.toVector3f().rotate((Quaternionfc)quaternionf);
        }
        projectile.shoot((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), speed, divergence);
        float h = EnderiteCrossbow.getSoundPitch(shooter.getRandom(), index);
        shooter.level().playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), SoundEvents.CROSSBOW_SHOOT, shooter.getSoundSource(), 1.0f, h);
    }

    private static Vector3f calcVelocity(LivingEntity shooter, Vec3 direction, float yaw) {
        Vector3f vector3f = direction.toVector3f().normalize();
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f2.lengthSquared() <= 1.0E-7) {
            Vec3 vec3d = shooter.getUpVector(1.0f);
            vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3d.toVector3f());
        }
        Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f2.x, vector3f2.y, vector3f2.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(yaw * ((float)Math.PI / 180), vector3f3.x, vector3f3.y, vector3f3.z);
    }

    protected Projectile createProjectile(Level world, LivingEntity shooter, ItemStack weaponStack, ItemStack projectileStack, boolean critical) {
        Projectile weakArrow = super.createProjectile(world, shooter, weaponStack, projectileStack, critical);
        if (weakArrow instanceof AbstractArrow) {
            AbstractArrow projectileEntity = (AbstractArrow)weakArrow;
            projectileEntity.setCustomName((Component)Component.literal((String)"Enderite Arrow"));
            projectileEntity.setBaseDamage((double)EnderiteMod.CONFIG.tools.enderiteCrossbowAD);
            return projectileEntity;
        }
        return weakArrow;
    }

    private static float getSoundPitch(RandomSource random, int index) {
        if (index == 0) {
            return 1.0f;
        }
        return EnderiteCrossbow.getSoundPitch((index & 1) == 1, random);
    }

    private static float getSoundPitch(boolean flag, RandomSource random) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (random.nextFloat() * 0.5f + 1.8f) + f;
    }

    public void onUseTick(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.isClientSide()) {
            CrossbowItem.ChargingSounds loadingSounds = this.getChargingSounds(stack);
            float f = (float)(stack.getUseDuration(user) - remainingUseTicks) / (float)EnderiteCrossbow.getPullTime(stack, user);
            if (f < 0.2f) {
                this.charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f && !this.charged) {
                this.charged = true;
                loadingSounds.start().ifPresent(sound -> world.playSound(null, user.getX(), user.getY(), user.getZ(), (SoundEvent)sound.value(), SoundSource.PLAYERS, 0.5f, 1.0f));
            }
            if (f >= 0.5f && !this.loaded) {
                this.loaded = true;
                loadingSounds.mid().ifPresent(sound -> world.playSound(null, user.getX(), user.getY(), user.getZ(), (SoundEvent)sound.value(), SoundSource.PLAYERS, 0.5f, 1.0f));
            }
            if (f >= 1.0f && !EnderiteCrossbow.isCharged((ItemStack)stack) && EnderiteCrossbow.loadProjectiles(user, stack)) {
                loadingSounds.end().ifPresent(sound -> world.playSound(null, user.getX(), user.getY(), user.getZ(), (SoundEvent)sound.value(), user.getSoundSource(), 1.0f, 1.0f / (world.getRandom().nextFloat() * 0.5f + 1.0f) + 0.2f));
            }
        }
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return EnderiteCrossbow.getPullTime(stack, user) + 3;
    }

    public static int getPullTime(ItemStack stack, LivingEntity user) {
        float f = EnchantmentHelper.modifyCrossbowChargingTime((ItemStack)stack, (LivingEntity)user, (float)1.25f);
        return Mth.floor((float)(f * EnderiteMod.CONFIG.tools.enderiteCrossBowChargeTime));
    }

    CrossbowItem.ChargingSounds getChargingSounds(ItemStack stack) {
        return EnchantmentHelper.pickHighestLevel((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.CROSSBOW_CHARGING_SOUNDS).orElse(DEFAULT_LOADING_SOUNDS);
    }

    private static float getPullProgress(int useTicks, ItemStack stack, LivingEntity user) {
        float f = (float)useTicks / (float)EnderiteCrossbow.getPullTime(stack, user);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

