/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.tools;

import java.util.List;
import java.util.Optional;
import net.enderitemc.enderitemod.EnderiteMod;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_9278;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EnderiteCrossbow
extends class_1764 {
    private boolean charged = false;
    private boolean loaded = false;
    private static final class_1764.class_9693 DEFAULT_LOADING_SOUNDS = new class_1764.class_9693(Optional.of(class_3417.field_14765), Optional.of(class_3417.field_14860), Optional.of(class_3417.field_14626));

    public EnderiteCrossbow(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        class_9278 chargedProjectilesComponent = (class_9278)itemStack.method_58694(class_9334.field_49649);
        if (chargedProjectilesComponent != null && !chargedProjectilesComponent.method_57442()) {
            this.method_7777(world, (class_1309)user, hand, itemStack, EnderiteCrossbow.getSpeed(chargedProjectilesComponent), 1.0f, null);
            return class_1269.field_21466.method_61393(itemStack);
        }
        if (!user.method_18808(itemStack).method_7960()) {
            this.charged = false;
            this.loaded = false;
            user.method_6019(hand);
            return class_1269.field_21466.method_61393(itemStack);
        }
        return class_1269.field_5814;
    }

    private static float getSpeed(class_9278 stack) {
        return stack.method_57438(class_1802.field_8639) ? 2.1f : EnderiteMod.CONFIG.tools.enderiteCrossbowArrowSpeed;
    }

    public boolean method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        int i = this.method_7881(stack, user) - remainingUseTicks;
        float f = EnderiteCrossbow.getPullProgress(i, stack, user);
        if (f >= 1.0f && !EnderiteCrossbow.method_7781((class_1799)stack) && EnderiteCrossbow.loadProjectiles(user, stack)) {
            class_1764.class_9693 loadingSounds = this.method_59976(stack);
            loadingSounds.comp_2675().ifPresent(sound -> world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), (class_3414)sound.comp_349(), user.method_5634(), 1.0f, 1.0f / (world.method_8409().method_43057() * 0.5f + 1.0f) + 0.2f));
            return true;
        }
        return false;
    }

    private static boolean loadProjectiles(class_1309 shooter, class_1799 crossbow) {
        List list = EnderiteCrossbow.method_57390((class_1799)crossbow, (class_1799)shooter.method_18808(crossbow), (class_1309)shooter);
        if (!list.isEmpty()) {
            crossbow.method_57379(class_9334.field_49649, (Object)class_9278.method_57441((List)list));
            return true;
        }
        return false;
    }

    protected void method_7763(class_1309 shooter, class_1676 projectile, int index, float speed, float divergence, float yaw, @Nullable class_1309 target) {
        Vector3f vector3f;
        if (target != null) {
            double d = target.method_23317() - shooter.method_23317();
            double e = target.method_23321() - shooter.method_23321();
            double f = Math.sqrt(d * d + e * e);
            double g = target.method_23323(0.3333333333333333) - projectile.method_23318() + f * (double)0.2f;
            vector3f = EnderiteCrossbow.calcVelocity(shooter, new class_243(d, g, e), yaw);
        } else {
            class_243 vec3d = shooter.method_18864(1.0f);
            Quaternionf quaternionf = new Quaternionf().setAngleAxis((double)(yaw * ((float)Math.PI / 180)), vec3d.field_1352, vec3d.field_1351, vec3d.field_1350);
            class_243 vec3d2 = shooter.method_5828(1.0f);
            vector3f = vec3d2.method_46409().rotate((Quaternionfc)quaternionf);
        }
        projectile.method_7485((double)vector3f.x(), (double)vector3f.y(), (double)vector3f.z(), speed, divergence);
        float h = EnderiteCrossbow.getSoundPitch(shooter.method_59922(), index);
        shooter.method_37908().method_43128(null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), class_3417.field_15187, shooter.method_5634(), 1.0f, h);
    }

    private static Vector3f calcVelocity(class_1309 shooter, class_243 direction, float yaw) {
        Vector3f vector3f = direction.method_46409().normalize();
        Vector3f vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f));
        if ((double)vector3f2.lengthSquared() <= 1.0E-7) {
            class_243 vec3d = shooter.method_18864(1.0f);
            vector3f2 = new Vector3f((Vector3fc)vector3f).cross((Vector3fc)vec3d.method_46409());
        }
        Vector3f vector3f3 = new Vector3f((Vector3fc)vector3f).rotateAxis(1.5707964f, vector3f2.x, vector3f2.y, vector3f2.z);
        return new Vector3f((Vector3fc)vector3f).rotateAxis(yaw * ((float)Math.PI / 180), vector3f3.x, vector3f3.y, vector3f3.z);
    }

    protected class_1676 method_57344(class_1937 world, class_1309 shooter, class_1799 weaponStack, class_1799 projectileStack, boolean critical) {
        class_1676 weakArrow = super.method_57344(world, shooter, weaponStack, projectileStack, critical);
        if (weakArrow instanceof class_1665) {
            class_1665 projectileEntity = (class_1665)weakArrow;
            projectileEntity.method_5665((class_2561)class_2561.method_43470((String)"Enderite Arrow"));
            projectileEntity.method_7438((double)EnderiteMod.CONFIG.tools.enderiteCrossbowAD);
            return projectileEntity;
        }
        return weakArrow;
    }

    private static float getSoundPitch(class_5819 random, int index) {
        if (index == 0) {
            return 1.0f;
        }
        return EnderiteCrossbow.getSoundPitch((index & 1) == 1, random);
    }

    private static float getSoundPitch(boolean flag, class_5819 random) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (random.method_43057() * 0.5f + 1.8f) + f;
    }

    public int method_7881(class_1799 stack, class_1309 user) {
        return EnderiteCrossbow.getPullTime(stack, user) + 3;
    }

    public static int getPullTime(class_1799 stack, class_1309 user) {
        float f = class_1890.method_60159((class_1799)stack, (class_1309)user, (float)1.25f);
        return class_3532.method_15375((float)(f * EnderiteMod.CONFIG.tools.enderiteCrossBowChargeTime));
    }

    class_1764.class_9693 method_59976(class_1799 stack) {
        return class_1890.method_60165((class_1799)stack, (class_9331)class_9701.field_51653).orElse(DEFAULT_LOADING_SOUNDS);
    }

    private static float getPullProgress(int useTicks, class_1799 stack, class_1309 user) {
        float f = (float)useTicks / (float)EnderiteCrossbow.getPullTime(stack, user);
        if (f > 1.0f) {
            f = 1.0f;
        }
        return f;
    }
}

