/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod;

import com.google.common.base.Suppliers;
import dev.architectury.event.events.client.ClientTooltipEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.registry.CreativeTabRegistry;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.enderitemc.enderitemod.blocks.EnderiteOre;
import net.enderitemc.enderitemod.blocks.EnderiteRespawnAnchor;
import net.enderitemc.enderitemod.blocks.RespawnAnchorUtils.EnderiteRespawnAnchorBlockEntity;
import net.enderitemc.enderitemod.component.EnderiteDataComponents;
import net.enderitemc.enderitemod.config.Config;
import net.enderitemc.enderitemod.config.ConfigLoader;
import net.enderitemc.enderitemod.materials.EnderiteArmorMaterial;
import net.enderitemc.enderitemod.misc.EnderiteElytraSpecialRecipe;
import net.enderitemc.enderitemod.misc.EnderiteTag;
import net.enderitemc.enderitemod.misc.EnderiteUpgradeSmithingTemplate;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxBlock;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxBlockEntity;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxScreenHandler;
import net.enderitemc.enderitemod.tools.BlockEntityTypeBuilder;
import net.enderitemc.enderitemod.tools.EnderiteTools;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.TooltipProvider;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class EnderiteMod {
    public static final String MOD_ID = "enderitemod";
    public static final Supplier<RegistrarManager> REGISTRIES = Suppliers.memoize(() -> RegistrarManager.get((String)MOD_ID));
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((String)"enderitemod", (ResourceKey)Registries.ITEM);
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((String)"enderitemod", (ResourceKey)Registries.BLOCK);
    public static final DeferredRegister<RecipeSerializer<?>> RECIPES = DeferredRegister.create((String)"enderitemod", (ResourceKey)Registries.RECIPE_SERIALIZER);
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((String)"enderitemod", (ResourceKey)Registries.BLOCK_ENTITY_TYPE);
    public static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((String)"enderitemod", (ResourceKey)Registries.CREATIVE_MODE_TAB);
    public static final DeferredRegister<DataComponentType<?>> DATA_COMPONENT_TYPES = DeferredRegister.create((String)"enderitemod", (ResourceKey)Registries.DATA_COMPONENT_TYPE);
    public static Config CONFIG = ConfigLoader.get();
    public static final RegistrySupplier<CreativeModeTab> ENDERITE_TAB = TABS.register("enderite_group", () -> CreativeTabRegistry.create((Component)Component.translatable((String)"itemGroup.enderitemod.enderite_group"), () -> new ItemStack((ItemLike)ENDERITE_INGOT.get())));
    public static final Supplier<Item.Properties> BASE_ENDERITE_ITEM_SETTINGS = () -> new Item.Properties().arch$tab(ENDERITE_TAB).fireResistant();
    public static final RegistrySupplier<Item> ENDERITE_INGOT = ITEMS.register("enderite_ingot", () -> new Item(EnderiteMod.getItemSettings("enderite_ingot", BASE_ENDERITE_ITEM_SETTINGS.get())));
    public static final RegistrySupplier<Item> ENDERITE_SCRAP = ITEMS.register("enderite_scrap", () -> new Item(EnderiteMod.getItemSettings("enderite_scrap", BASE_ENDERITE_ITEM_SETTINGS.get())));
    public static final RegistrySupplier<Block> ENDERITE_BLOCK = BLOCKS.register("enderite_block", () -> new Block(EnderiteMod.getBlockSettings("enderite_block").mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().strength(66.0f, 1200.0f).sound(SoundType.NETHERITE_BLOCK)));
    public static final RegistrySupplier<Item> ENDERITE_BLOCK_ITEM = ITEMS.register("enderite_block", () -> new BlockItem((Block)ENDERITE_BLOCK.get(), EnderiteMod.getItemSettings("enderite_block", BASE_ENDERITE_ITEM_SETTINGS.get()).useBlockDescriptionPrefix()));
    public static final RegistrySupplier<Block> ENDERITE_ORE = BLOCKS.register("enderite_ore", () -> new EnderiteOre(EnderiteMod.getBlockSettings("enderite_ore")));
    public static final RegistrySupplier<Item> ENDERITE_ORE_ITEM = ITEMS.register("enderite_ore", () -> new BlockItem((Block)ENDERITE_ORE.get(), EnderiteMod.getItemSettings("enderite_ore", BASE_ENDERITE_ITEM_SETTINGS.get()).useBlockDescriptionPrefix()));
    public static final RegistrySupplier<Block> CRACKED_ENDERITE_ORE = BLOCKS.register("cracked_enderite_ore", () -> new Block(EnderiteMod.getBlockSettings("cracked_enderite_ore").mapColor(MapColor.COLOR_BLACK).requiresCorrectToolForDrops().sound(SoundType.ANCIENT_DEBRIS).strength(20.0f, 1200.0f)));
    public static final RegistrySupplier<Item> CRACKED_ENDERITE_ORE_ITEM = ITEMS.register("cracked_enderite_ore", () -> new BlockItem((Block)CRACKED_ENDERITE_ORE.get(), EnderiteMod.getItemSettings("cracked_enderite_ore", BASE_ENDERITE_ITEM_SETTINGS.get()).useBlockDescriptionPrefix()));
    public static final RegistrySupplier<Block> ENDERITE_RESPAWN_ANCHOR = BLOCKS.register("enderite_respawn_anchor", () -> new EnderiteRespawnAnchor(EnderiteMod.getBlockSettings("enderite_respawn_anchor")));
    public static final RegistrySupplier<Item> ENDERITE_RESPAWN_ANCHOR_ITEM = ITEMS.register("enderite_respawn_anchor", () -> new BlockItem((Block)ENDERITE_RESPAWN_ANCHOR.get(), EnderiteMod.getItemSettings("enderite_respawn_anchor", BASE_ENDERITE_ITEM_SETTINGS.get()).useBlockDescriptionPrefix()));
    public static final RegistrySupplier<BlockEntityType<EnderiteRespawnAnchorBlockEntity>> ENDERITE_RESPAWN_ANCHOR_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("enderite_respawn_anchor", () -> BlockEntityTypeBuilder.create(EnderiteRespawnAnchorBlockEntity::new, (Block)ENDERITE_RESPAWN_ANCHOR.get()));
    public static final RegistrySupplier<Item> ENDERITE_HELMET = ITEMS.register("enderite_helmet", () -> new Item(EnderiteMod.getItemSettings("enderite_helmet", BASE_ENDERITE_ITEM_SETTINGS.get()).durability(ArmorType.HELMET.getDurability(EnderiteMod.CONFIG.armor.durabilityMultiplier)).humanoidArmor(EnderiteArmorMaterial.ENDERITE, ArmorType.HELMET)));
    public static final RegistrySupplier<Item> ENDERITE_CHESTPLATE = ITEMS.register("enderite_chestplate", () -> new Item(EnderiteMod.getItemSettings("enderite_chestplate", BASE_ENDERITE_ITEM_SETTINGS.get()).durability(ArmorType.CHESTPLATE.getDurability(EnderiteMod.CONFIG.armor.durabilityMultiplier)).humanoidArmor(EnderiteArmorMaterial.ENDERITE, ArmorType.CHESTPLATE)));
    public static final RegistrySupplier<Item> ENDERITE_LEGGINGS = ITEMS.register("enderite_leggings", () -> new Item(EnderiteMod.getItemSettings("enderite_leggings", BASE_ENDERITE_ITEM_SETTINGS.get()).durability(ArmorType.LEGGINGS.getDurability(EnderiteMod.CONFIG.armor.durabilityMultiplier)).humanoidArmor(EnderiteArmorMaterial.ENDERITE, ArmorType.LEGGINGS)));
    public static final RegistrySupplier<Item> ENDERITE_BOOTS = ITEMS.register("enderite_boots", () -> new Item(EnderiteMod.getItemSettings("enderite_boots", BASE_ENDERITE_ITEM_SETTINGS.get()).durability(ArmorType.BOOTS.getDurability(EnderiteMod.CONFIG.armor.durabilityMultiplier)).humanoidArmor(EnderiteArmorMaterial.ENDERITE, ArmorType.BOOTS)));
    public static final RegistrySupplier<Item> ENDERITE_ELYTRA = ITEMS.register("enderite_elytra", () -> new Item(EnderiteMod.getItemSettings("enderite_elytra", ENDERITE_ELYTRA_ITEM_SETTINGS.get()).humanoidArmor(EnderiteArmorMaterial.ENDERITE_ELYTRA, ArmorType.CHESTPLATE)));
    public static final RegistrySupplier<Item> ENDERITE_ELYTRA_SEPERATED = ITEMS.register("enderite_elytra_seperated", () -> new Item(EnderiteMod.getItemSettings("enderite_elytra_seperated", ENDERITE_ELYTRA_SEPERATED_ITEM_SETTINGS.get())));
    public static final Supplier<Item.Properties> ENDERITE_ELYTRA_SEPERATED_ITEM_SETTINGS = () -> new Item.Properties().arch$tab(ENDERITE_TAB).fireResistant().stacksTo(1).durability(1024).rarity(Rarity.EPIC).component(DataComponents.GLIDER, (Object)Unit.INSTANCE).component(DataComponents.EQUIPPABLE, (Object)Equippable.builder((EquipmentSlot)EquipmentSlot.CHEST).setEquipSound(SoundEvents.ARMOR_EQUIP_ELYTRA).setAsset(EnderiteArmorMaterial.ENDERITE_ELYTRA_SEPERATED_ARMOR_MODEL_ID).setDamageOnHurt(false).build()).repairable(EnderiteTag.REPAIRS_ENDERITE_EQUIPMENT);
    public static final Supplier<Item.Properties> ENDERITE_ELYTRA_ITEM_SETTINGS = () -> new Item.Properties().arch$tab(ENDERITE_TAB).fireResistant().stacksTo(1).durability(1024).rarity(Rarity.EPIC).component(DataComponents.GLIDER, (Object)Unit.INSTANCE);
    public static RegistrySupplier<RecipeSerializer<? extends CustomRecipe>> ENDERITE_EYLTRA_SPECIAL_RECIPE = RECIPES.register("crafting_special_enderiteelytra", () -> new CustomRecipe.Serializer(EnderiteElytraSpecialRecipe::new));
    public static final RegistrySupplier<Block> ENDERITE_SHULKER_BOX = BLOCKS.register("enderite_shulker_box", () -> new EnderiteShulkerBoxBlock("enderite_shulker_box"));
    public static final RegistrySupplier<Item> ENDERITE_SHULKER_BOX_ITEM = ITEMS.register("enderite_shulker_box", () -> new BlockItem((Block)ENDERITE_SHULKER_BOX.get(), EnderiteMod.getItemSettings("enderite_shulker_box", BASE_ENDERITE_ITEM_SETTINGS.get()).stacksTo(1).component(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY).useBlockDescriptionPrefix()));
    public static final RegistrySupplier<BlockEntityType<EnderiteShulkerBoxBlockEntity>> ENDERITE_SHULKER_BOX_BLOCK_ENTITY = BLOCK_ENTITY_TYPES.register("enderite_shulker_box_block_entity", () -> BlockEntityTypeBuilder.create(EnderiteShulkerBoxBlockEntity::new, (Block)ENDERITE_SHULKER_BOX.get()));
    public static MenuType<EnderiteShulkerBoxScreenHandler> ENDERITE_SHULKER_BOX_SCREEN_HANDLER;
    public static ResourceLocation VOID_FLOATING_ENCHANTMENT_ID;
    public static final RegistrySupplier<Item> ENDERITE_UPGRADE_SMITHING_TEMPLATE;

    public static void init() {
        EnderiteTools.init();
        EnderiteDataComponents.init();
        BLOCKS.register();
        ITEMS.register();
        RECIPES.register();
        BLOCK_ENTITY_TYPES.register();
        TABS.register();
        LifecycleEvent.SETUP.register(() -> {
            BiomeModifications.addProperties(ctx -> ctx.hasTag(BiomeTags.IS_END), (ctx, mutable) -> {
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"ore_enderite_large")));
                mutable.getGenerationProperties().addFeature(GenerationStep.Decoration.UNDERGROUND_ORES, ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"ore_enderite_small")));
            });
            CreativeTabRegistry.append(ENDERITE_TAB, (ItemLike[])new ItemLike[]{(ItemLike)ENDERITE_UPGRADE_SMITHING_TEMPLATE.get()});
        });
        EnderiteUpgradeSmithingTemplate.registerLoottables();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientInit() {
        ClientTooltipEvent.ITEM.register((stack, lines, tooltipContext, flag) -> {
            Object patt1$temp;
            TooltipProvider tta;
            ArrayList component_tooltip = new ArrayList();
            Object patt0$temp = stack.get((DataComponentType)EnderiteDataComponents.TELEPORT_CHARGE.get());
            if (patt0$temp instanceof TooltipProvider) {
                tta = (TooltipProvider)patt0$temp;
                tta.addToTooltip(tooltipContext, component_tooltip::add, flag, (DataComponentGetter)stack.getComponents());
            }
            if ((patt1$temp = stack.get((DataComponentType)EnderiteDataComponents.ENDERITE_TOOLTIP.get())) instanceof TooltipProvider) {
                tta = (TooltipProvider)patt1$temp;
                tta.addToTooltip(tooltipContext, component_tooltip::add, flag, (DataComponentGetter)stack.getComponents());
            }
            lines.addAll(1, component_tooltip);
        });
    }

    public static BlockBehaviour.Properties getBlockSettings(String id) {
        return BlockBehaviour.Properties.of().setId(ResourceKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id)));
    }

    public static Item.Properties getItemSettings(String id) {
        return new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id)));
    }

    public static Item.Properties getItemSettings(String id, Item.Properties settings) {
        return settings.setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)id)));
    }

    static {
        VOID_FLOATING_ENCHANTMENT_ID = ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"void_floating");
        ENDERITE_UPGRADE_SMITHING_TEMPLATE = ITEMS.register("enderite_upgrade_smithing_template", () -> new SmithingTemplateItem((Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"smithing_template.enderite_upgrade.applies_to"))).withStyle(ChatFormatting.BLUE), (Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"smithing_template.enderite_upgrade.ingredients"))).withStyle(ChatFormatting.BLUE), (Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"smithing_template.enderite_upgrade.base_slot_description"))), (Component)Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)"smithing_template.enderite_upgrade.additions_slot_description"))), SmithingTemplateItem.createNetheriteUpgradeIconList(), SmithingTemplateItem.createNetheriteUpgradeMaterialList(), EnderiteMod.getItemSettings("enderite_upgrade_smithing_template").rarity(Rarity.UNCOMMON)));
    }
}

