/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.blocks.RespawnAnchorUtils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.enderitemc.enderitemod.blocks.RespawnAnchorUtils.EnderiteRespawnAnchorBlockEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class EnderiteRespawnAnchorRenderer<T extends EnderiteRespawnAnchorBlockEntity>
implements BlockEntityRenderer<T> {
    public EnderiteRespawnAnchorRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(T entity, float tickProgress, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, Vec3 cameraPos) {
        Matrix4f matrix4f = matrices.last().pose();
        if (((EnderiteRespawnAnchorBlockEntity)((Object)entity)).isCharged() && ((EnderiteRespawnAnchorBlockEntity)((Object)entity)).shouldRenderPortal()) {
            this.renderSides(entity, matrix4f, vertexConsumers.getBuffer(this.getLayer()));
        }
    }

    private void renderSides(T entity, Matrix4f matrix, VertexConsumer vertexConsumer) {
        float f = this.getSideOffset();
        float g = this.getTopYOffset();
        this.renderSide(entity, matrix, vertexConsumer, f, 1.0f - f, g, g, 1.0f - f, 1.0f - f, f, f, Direction.UP);
    }

    private void renderSide(T entity, Matrix4f model, VertexConsumer vertices, float x1, float x2, float y1, float y2, float z1, float z2, float z3, float z4, Direction side) {
        vertices.addVertex(model, x1, y1, z1);
        vertices.addVertex(model, x2, y1, z2);
        vertices.addVertex(model, x2, y2, z3);
        vertices.addVertex(model, x1, y2, z4);
    }

    protected float getTopYOffset() {
        return 1.001f;
    }

    protected float getSideOffset() {
        return 0.125f;
    }

    protected RenderType getLayer() {
        return RenderType.endPortal();
    }
}

