/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.mixin;

import java.util.Optional;
import net.enderitemc.enderitemod.EnderiteMod;
import net.enderitemc.enderitemod.misc.EnderiteTag;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class EnderiteDropDamageMixin
extends Entity {
    @Shadow
    public abstract ItemStack getItem();

    protected EnderiteDropDamageMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick()V"})
    private void damageItem(CallbackInfo info) {
        if (this.getY() < (double)this.level().getMinY()) {
            float r;
            boolean survives;
            ArmorTrim trim;
            int i = 0;
            Optional enchant = this.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(EnderiteMod.VOID_FLOATING_ENCHANTMENT_ID);
            if (enchant.isPresent()) {
                i += EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)enchant.get()), (ItemStack)this.getItem());
            }
            if ((trim = (ArmorTrim)this.getItem().get(DataComponents.TRIM)) != null && trim.material().getRegisteredName().equals("enderitemod:enderite")) {
                ++i;
            }
            boolean bl = survives = (r = this.random.nextFloat()) < (float)i / 3.0f;
            if (this.getItem().is(EnderiteTag.ENDERITE_ITEM) || survives) {
                this.unsetRemoved();
                this.teleportTo(this.getX(), this.level().getMinY() + 10, this.getZ());
                this.setDeltaMovement(0.0, 0.0, 0.0);
                this.setNoGravity(true);
                this.setGlowingTag(true);
            }
        }
    }
}

