/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.mixin;

import net.enderitemc.enderitemod.tools.EnderiteTools;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Sheep.class})
public abstract class EnderiteShearsSheepMixin
extends LivingEntity {
    protected EnderiteShearsSheepMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    public abstract boolean readyForShearing();

    @Shadow
    public abstract void shear(ServerLevel var1, SoundSource var2, ItemStack var3);

    /*
     * Enabled aggressive block sorting
     */
    @Inject(at={@At(value="HEAD")}, method={"mobInteract(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;"}, cancellable=true)
    private void onShear(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> info) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (!itemStack.is((Item)EnderiteTools.ENDERITE_SHEAR.get())) return;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            if (this.readyForShearing()) {
                this.shear(serverWorld, SoundSource.PLAYERS, itemStack);
                itemStack.hurtAndBreak(1, (LivingEntity)player, Sheep.getSlotForHand((InteractionHand)hand));
                info.setReturnValue((Object)InteractionResult.SUCCESS);
                return;
            }
        }
        info.setReturnValue((Object)InteractionResult.CONSUME);
    }
}

