/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.mixin;

import net.enderitemc.enderitemod.component.EnderiteChargeComponent;
import net.enderitemc.enderitemod.component.EnderiteDataComponents;
import net.enderitemc.enderitemod.tools.EnderiteShield;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public abstract class EnderiteShieldPlayerEntityMixin
extends LivingEntity {
    protected EnderiteShieldPlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Shadow
    public abstract ItemCooldowns getCooldowns();

    @Inject(at={@At(value="HEAD")}, method={"blockUsingItem(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V"})
    private void portIt(ServerLevel world, LivingEntity attacker, CallbackInfo ci) {
        if (this.isShiftKeyDown() && this.useItem.getItem() instanceof EnderiteShield && !this.getCooldowns().isOnCooldown(this.useItem)) {
            int charge = ((Number)this.useItem.getOrDefault((DataComponentType)EnderiteDataComponents.TELEPORT_CHARGE.get(), (Object)0)).intValue();
            if (!(world.isClientSide() || charge <= 0 || attacker instanceof EnderDragon || attacker instanceof WitherBoss || attacker instanceof ElderGuardian)) {
                double d = attacker.getX();
                double e = attacker.getY();
                double f = attacker.getZ();
                double yaw = this.yHeadRot;
                double pitch = this.getXRot();
                double temp = Math.cos(Math.toRadians(pitch));
                double dX = temp * -Math.sin(Math.toRadians(yaw));
                double dY = -Math.sin(Math.toRadians(pitch));
                double dZ = temp * Math.cos(Math.toRadians(yaw));
                double distance = 10.0;
                for (int i = 0; i < 16; ++i) {
                    double g = attacker.getX() + dX * distance + (attacker.getRandom().nextDouble() - 0.5) * 16.0;
                    double h = Mth.clamp((double)(attacker.getY() + dY * distance + (double)(attacker.getRandom().nextInt(16) - 8)), (double)0.0, (double)(world.getHeight() - 1));
                    double j = attacker.getZ() + dZ * distance + (attacker.getRandom().nextDouble() - 0.5) * 16.0;
                    if (attacker.isPassenger()) {
                        attacker.stopRiding();
                    }
                    if (!attacker.randomTeleport(g, h, j, true)) continue;
                    SoundEvent soundEvent = attacker instanceof Fox ? SoundEvents.FOX_TELEPORT : SoundEvents.CHORUS_FRUIT_TELEPORT;
                    world.playSound((Entity)((Player)null), d, e, f, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
                    attacker.playSound(soundEvent, 1.0f, 1.0f);
                    this.useItem.set((DataComponentType)EnderiteDataComponents.TELEPORT_CHARGE.get(), (Object)EnderiteChargeComponent.of(charge - 1));
                    this.getCooldowns().addCooldown(this.useItem, 128);
                    break;
                }
            }
        }
    }
}

