/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.client.model.ShieldModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class EnderiteShieldRenderer
implements SpecialModelRenderer<DataComponentMap> {
    public static final Material ENDERITE_SHIELD_BASE = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)"enderitemod", (String)"entity/enderite_shield_base"));
    public static final Material ENDERITE_SHIELD_BASE_NO_PATTERN = new Material(Sheets.SHIELD_SHEET, ResourceLocation.fromNamespaceAndPath((String)"enderitemod", (String)"entity/enderite_shield_base_nopattern"));
    private final ShieldModel model;
    private final boolean charged;

    public EnderiteShieldRenderer(ShieldModel model, boolean charged) {
        this.model = model;
        this.charged = charged;
    }

    @Nullable
    public DataComponentMap getData(ItemStack itemStack) {
        return itemStack.immutableComponents();
    }

    public void render(@Nullable DataComponentMap componentMap, ItemDisplayContext modelTransformationMode, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i, int j, boolean bl) {
        BannerPatternLayers bannerPatternsComponent = componentMap != null ? (BannerPatternLayers)componentMap.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY) : BannerPatternLayers.EMPTY;
        DyeColor dyeColor = componentMap != null ? (DyeColor)componentMap.get(DataComponents.BASE_COLOR) : null;
        boolean bl2 = !bannerPatternsComponent.layers().isEmpty() || dyeColor != null;
        matrixStack.pushPose();
        matrixStack.scale(1.0f, -1.0f, -1.0f);
        Material spriteIdentifier = bl2 ? ENDERITE_SHIELD_BASE : ENDERITE_SHIELD_BASE_NO_PATTERN;
        VertexConsumer vertexConsumer = spriteIdentifier.sprite().wrap(ItemRenderer.getFoilBuffer((MultiBufferSource)vertexConsumerProvider, (RenderType)this.model.renderType(spriteIdentifier.atlasLocation()), (modelTransformationMode == ItemDisplayContext.GUI ? 1 : 0) != 0, (boolean)bl));
        this.model.handle().render(matrixStack, vertexConsumer, i, j);
        if (bl2) {
            BannerRenderer.renderPatterns((PoseStack)matrixStack, (MultiBufferSource)vertexConsumerProvider, (int)i, (int)j, (ModelPart)this.model.plate(), (Material)spriteIdentifier, (boolean)false, (DyeColor)Objects.requireNonNullElse(dyeColor, DyeColor.WHITE), (BannerPatternLayers)bannerPatternsComponent, (boolean)bl, (boolean)false);
        } else {
            this.model.plate().render(matrixStack, vertexConsumer, i, j);
        }
        if (this.charged && (modelTransformationMode == ItemDisplayContext.THIRD_PERSON_LEFT_HAND || modelTransformationMode == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND)) {
            this.renderSides(matrixStack.last().pose(), vertexConsumerProvider.getBuffer(RenderType.endPortal()));
        }
        matrixStack.popPose();
    }

    private void renderSides(Matrix4f matrix, VertexConsumer vertexConsumer) {
        float border = 1.0f;
        float f = (-6.0f + border) / 16.0f;
        float g = (-11.0f + border) / 16.0f;
        float h = -0.125f;
        float df = (12.0f - 2.0f * border) / 16.0f;
        float dg = (22.0f - 2.0f * border) / 16.0f;
        float dh = -6.25E-5f;
        this.renderSide(matrix, vertexConsumer, f, f + df, g + dg, g, h + dh);
    }

    private void renderSide(Matrix4f model, VertexConsumer vertices, float x1, float x2, float y1, float y2, float z) {
        vertices.addVertex(model, x1, y1, z);
        vertices.addVertex(model, x2, y1, z);
        vertices.addVertex(model, x2, y2, z);
        vertices.addVertex(model, x1, y2, z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public record Unbaked(boolean charged) implements SpecialModelRenderer.Unbaked
    {
        public static final MapCodec<Unbaked> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("charged", (Object)false).forGetter(Unbaked::charged)).apply((Applicative)instance, Unbaked::new));

        public MapCodec<Unbaked> type() {
            return CODEC;
        }

        public SpecialModelRenderer<?> bake(EntityModelSet entityModels) {
            return new EnderiteShieldRenderer(new ShieldModel(entityModels.bakeLayer(ModelLayers.SHIELD)), this.charged);
        }
    }
}

