/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.shulker;

import java.util.List;
import java.util.stream.IntStream;
import net.enderitemc.enderitemod.EnderiteMod;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxBlock;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxScreenHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class EnderiteShulkerBoxBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private static final int[] AVAILABLE_SLOTS = IntStream.range(0, 45).toArray();
    private NonNullList<ItemStack> inventory = NonNullList.withSize((int)45, (Object)ItemStack.EMPTY);
    private int viewerCount;
    private AnimationStage animationStage = AnimationStage.CLOSED;
    private float animationProgress;
    private float prevAnimationProgress;

    public EnderiteShulkerBoxBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)EnderiteMod.ENDERITE_SHULKER_BOX_BLOCK_ENTITY.get(), pos, state);
    }

    public static void tick(Level world, BlockPos pos, BlockState state, EnderiteShulkerBoxBlockEntity be) {
        be.tick2();
    }

    public void tick2() {
        this.updateAnimation();
        if (this.animationStage == AnimationStage.OPENING || this.animationStage == AnimationStage.CLOSING) {
            this.pushEntities();
        }
    }

    protected void updateAnimation() {
        this.prevAnimationProgress = this.animationProgress;
        switch (this.animationStage.ordinal()) {
            case 0: {
                this.animationProgress = 0.0f;
                break;
            }
            case 1: {
                this.animationProgress += 0.1f;
                if (!(this.animationProgress >= 1.0f)) break;
                this.pushEntities();
                this.animationStage = AnimationStage.OPENED;
                this.animationProgress = 1.0f;
                this.updateNeighborStates();
                break;
            }
            case 3: {
                this.animationProgress -= 0.1f;
                if (!(this.animationProgress <= 0.0f)) break;
                this.animationStage = AnimationStage.CLOSED;
                this.animationProgress = 0.0f;
                this.updateNeighborStates();
                break;
            }
            case 2: {
                this.animationProgress = 1.0f;
            }
        }
    }

    public AnimationStage getAnimationStage() {
        return this.animationStage;
    }

    public AABB getBoundingBox(BlockState state) {
        return this.getBoundingBox((Direction)state.getValue((Property)EnderiteShulkerBoxBlock.FACING));
    }

    public AABB getBoundingBox(Direction openDirection) {
        float f = this.getAnimationProgress(1.0f);
        return Shapes.block().bounds().expandTowards((double)(0.5f * f * (float)openDirection.getStepX()), (double)(0.5f * f * (float)openDirection.getStepY()), (double)(0.5f * f * (float)openDirection.getStepZ()));
    }

    private AABB getCollisionBox(Direction facing) {
        Direction direction = facing.getOpposite();
        return this.getBoundingBox(facing).contract((double)direction.getStepX(), (double)direction.getStepY(), (double)direction.getStepZ());
    }

    private void pushEntities() {
        Direction direction;
        AABB box;
        List list;
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        if (blockState.getBlock() instanceof EnderiteShulkerBoxBlock && !(list = this.level.getEntities((Entity)null, box = this.getCollisionBox(direction = (Direction)blockState.getValue((Property)EnderiteShulkerBoxBlock.FACING)).move(this.worldPosition))).isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity entity = (Entity)list.get(i);
                if (entity.getPistonPushReaction() == PushReaction.IGNORE) continue;
                double d = 0.0;
                double e = 0.0;
                double f = 0.0;
                AABB box2 = entity.getBoundingBox();
                switch (direction.getAxis()) {
                    case X: {
                        d = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ? box.maxX - box2.minX : box2.maxX - box.minX;
                        d += 0.01;
                        break;
                    }
                    case Y: {
                        e = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ? box.maxY - box2.minY : box2.maxY - box.minY;
                        e += 0.01;
                        break;
                    }
                    case Z: {
                        f = direction.getAxisDirection() == Direction.AxisDirection.POSITIVE ? box.maxZ - box2.minZ : box2.maxZ - box.minZ;
                        f += 0.01;
                    }
                }
                entity.move(MoverType.SHULKER_BOX, new Vec3(d * (double)direction.getStepX(), e * (double)direction.getStepY(), f * (double)direction.getStepZ()));
            }
        }
    }

    public int getContainerSize() {
        return this.inventory.size();
    }

    public boolean triggerEvent(int type, int data) {
        if (type == 1) {
            this.viewerCount = data;
            if (data == 0) {
                this.animationStage = AnimationStage.CLOSING;
                this.updateNeighborStates();
            }
            if (data == 1) {
                this.animationStage = AnimationStage.OPENING;
                this.updateNeighborStates();
            }
            return true;
        }
        return super.triggerEvent(type, data);
    }

    private void updateNeighborStates() {
        this.getBlockState().updateNeighbourShapes((LevelAccessor)this.getLevel(), this.getBlockPos(), 3);
    }

    public void preRemoveSideEffects(BlockPos pos, BlockState oldState) {
    }

    public void startOpen(Player player) {
        if (!player.isSpectator()) {
            if (this.viewerCount < 0) {
                this.viewerCount = 0;
            }
            ++this.viewerCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.viewerCount);
            if (this.viewerCount == 1) {
                this.level.playSound((Entity)((Player)null), this.worldPosition, SoundEvents.SHULKER_BOX_OPEN, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public void stopOpen(Player player) {
        if (!player.isSpectator()) {
            --this.viewerCount;
            this.level.blockEvent(this.worldPosition, this.getBlockState().getBlock(), 1, this.viewerCount);
            if (this.viewerCount <= 0) {
                this.level.playSound((Entity)((Player)null), this.worldPosition, SoundEvents.SHULKER_BOX_CLOSE, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.enderitemod.enderiteShulkerBox");
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        super.loadAdditional(nbt, lookup);
        this.readInventoryNbt(nbt, lookup);
    }

    public void saveAdditional(CompoundTag nbt, HolderLookup.Provider lookup) {
        super.saveAdditional(nbt, lookup);
        if (!this.trySaveLootTable(nbt)) {
            ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (boolean)false, (HolderLookup.Provider)lookup);
        }
    }

    public void readInventoryNbt(CompoundTag nbt, HolderLookup.Provider lookup) {
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(nbt)) {
            ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)lookup);
        }
    }

    protected NonNullList<ItemStack> getInvStackList() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    public int[] getSlotsForFace(Direction side) {
        return AVAILABLE_SLOTS;
    }

    public boolean canPlaceItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return !(Block.byItem((Item)stack.getItem()) instanceof EnderiteShulkerBoxBlock) && !(Block.byItem((Item)stack.getItem()) instanceof ShulkerBoxBlock);
    }

    public boolean canTakeItemThroughFace(int slot, ItemStack stack, Direction dir) {
        return true;
    }

    public float getAnimationProgress(float f) {
        return Mth.lerp((float)f, (float)this.prevAnimationProgress, (float)this.animationProgress);
    }

    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return new EnderiteShulkerBoxScreenHandler(syncId, playerInventory, (Container)this);
    }

    public boolean suffocates() {
        return this.animationStage == AnimationStage.CLOSED;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public static enum AnimationStage {
        CLOSED,
        OPENING,
        OPENED,
        CLOSING;

    }
}

