/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.tools;

import java.util.List;
import java.util.Optional;
import net.enderitemc.enderitemod.EnderiteMod;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class EnderiteBow
extends BowItem {
    public EnderiteBow(Item.Properties settings) {
        super(settings);
    }

    public boolean releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            int i;
            float f;
            Player playerEntity = (Player)user;
            boolean bl = EnderiteBow.canUseWithoutArrow(stack, playerEntity);
            ItemStack itemStack = playerEntity.getProjectile(stack);
            if (bl && itemStack.isEmpty()) {
                itemStack = Items.ARROW.getDefaultInstance().copyWithCount(64);
            }
            if (!itemStack.isEmpty() && !((double)(f = EnderiteBow.getPullProgress(i = this.getUseDuration(stack, user) - remainingUseTicks)) < 0.1)) {
                int proj_count;
                ServerLevel serverWorld;
                List list = EnderiteBow.draw((ItemStack)stack, (ItemStack)itemStack, (LivingEntity)playerEntity);
                Level level = playerEntity.level();
                if (level instanceof ServerLevel) {
                    serverWorld = (ServerLevel)level;
                    v0 = EnchantmentHelper.processProjectileCount((ServerLevel)serverWorld, (ItemStack)stack, (Entity)playerEntity, (int)1);
                } else {
                    v0 = proj_count = 1;
                }
                if (bl) {
                    for (int proj_idx = 0; proj_idx < proj_count - list.size(); ++proj_idx) {
                        list.add(Items.ARROW.getDefaultInstance());
                    }
                }
                if (world instanceof ServerLevel) {
                    serverWorld = (ServerLevel)world;
                    if (!list.isEmpty()) {
                        this.shoot(serverWorld, (LivingEntity)playerEntity, playerEntity.getUsedItemHand(), stack, list, f * this.getSpeedMultiplier(), 1.0f, f == 1.0f, null);
                    }
                }
                world.playSound(null, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (world.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                playerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
                return true;
            }
        }
        return false;
    }

    protected void shoot(ServerLevel world, LivingEntity shooter, InteractionHand hand, ItemStack stack, List<ItemStack> projectiles, float speed, float divergence, boolean critical, @Nullable LivingEntity target) {
        float f = EnchantmentHelper.processProjectileSpread((ServerLevel)world, (ItemStack)stack, (Entity)shooter, (float)0.0f);
        float g = projectiles.size() == 1 ? 0.0f : 2.0f * f / (float)(projectiles.size() - 1);
        float h = (float)((projectiles.size() - 1) % 2) * g / 2.0f;
        float i = 1.0f;
        for (int j = 0; j < projectiles.size(); ++j) {
            ItemStack itemStack = projectiles.get(j);
            if (itemStack.isEmpty()) continue;
            float k = h + i * (float)((j + 1) / 2) * g;
            i = -i;
            AbstractArrow projectileEntity = (AbstractArrow)this.createProjectile((Level)world, shooter, stack, itemStack, critical);
            projectileEntity.setCustomName((Component)Component.literal((String)"Enderite Arrow"));
            projectileEntity.setBaseDamage((double)this.getBaseDamage());
            if (shooter instanceof Player && EnderiteBow.canUseWithoutArrow(stack, (Player)shooter)) {
                projectileEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            this.shootProjectile(shooter, (Projectile)projectileEntity, j, speed, divergence, k, target);
            world.addFreshEntity((Entity)projectileEntity);
            stack.hurtAndBreak(this.getDurabilityUse(itemStack), shooter, LivingEntity.getSlotForHand((InteractionHand)hand));
            if (stack.isEmpty()) break;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static ItemStack getProjectile(ItemStack stack, ItemStack projectileStack, LivingEntity shooter, boolean multishot) {
        v0 = no_ammo_use = shooter instanceof Player != false && EnderiteBow.canUseWithoutArrow(stack, (Player)shooter) != false;
        if (multishot || shooter.hasInfiniteMaterials() || !((var7_5 = shooter.level()) instanceof ServerLevel)) ** GOTO lbl-1000
        serverWorld = (ServerLevel)var7_5;
        if (!no_ammo_use) {
            v1 = EnchantmentHelper.processAmmoUse((ServerLevel)serverWorld, (ItemStack)stack, (ItemStack)projectileStack, (int)1);
        } else lbl-1000:
        // 2 sources

        {
            v1 = i = 0;
        }
        if (i > projectileStack.getCount()) {
            return ItemStack.EMPTY;
        }
        if (i == 0) {
            itemStack = projectileStack.copyWithCount(1);
            itemStack.set(DataComponents.INTANGIBLE_PROJECTILE, (Object)Unit.INSTANCE);
            return itemStack;
        }
        itemStack = projectileStack.split(i);
        if (projectileStack.isEmpty() && shooter instanceof Player) {
            playerEntity = (Player)shooter;
            playerEntity.getInventory().removeItem(projectileStack);
        }
        return itemStack;
    }

    public static float getPullProgress(int useTicks) {
        float f = (float)useTicks / EnderiteMod.CONFIG.tools.enderiteBowChargeTime;
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    public InteractionResult use(Level world, Player user, InteractionHand hand) {
        boolean bl;
        ItemStack itemStack = user.getItemInHand(hand);
        boolean bl2 = bl = !user.getProjectile(itemStack).isEmpty();
        if (!bl && !EnderiteBow.canUseWithoutArrow(itemStack, user)) {
            return InteractionResult.FAIL;
        }
        user.startUsingItem(hand);
        return InteractionResult.CONSUME.heldItemTransformedTo(itemStack);
    }

    private static boolean canUseWithoutArrow(ItemStack bow, Player user) {
        Optional inf_enchant = user.level().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.INFINITY.location());
        return user.getAbilities().instabuild || !EnderiteMod.CONFIG.tools.enderiteBowNeedsArrow || !EnderiteMod.CONFIG.tools.enderiteBowWithInfinityNeedsArrow && inf_enchant.isPresent() && EnchantmentHelper.getItemEnchantmentLevel((Holder)((Holder)inf_enchant.get()), (ItemStack)bow) > 0;
    }

    public float getBaseDamage() {
        return EnderiteMod.CONFIG.tools.enderiteBowAD;
    }

    public float getSpeedMultiplier() {
        return EnderiteMod.CONFIG.tools.enderiteBowArrowSpeed;
    }
}

