/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.tools;

import dev.architectury.event.events.common.LootEvent;
import net.enderitemc.enderitemod.tools.EnderiteTools;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class EnderiteShears
extends ShearsItem {
    public EnderiteShears(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        BlockPos blockPos;
        Level world = context.getLevel();
        BlockState blockstate = world.getBlockState(blockPos = context.getClickedPos());
        Block block = blockstate.getBlock();
        if (block instanceof BeehiveBlock && (Integer)blockstate.getValue((Property)BeehiveBlock.HONEY_LEVEL) >= 5) {
            Player playerEntity = context.getPlayer();
            ItemStack itemStack = context.getItemInHand();
            BeehiveBlock beehiveBlock = (BeehiveBlock)block;
            if (playerEntity instanceof ServerPlayer) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger((ServerPlayer)playerEntity, blockPos, itemStack);
            }
            BeehiveBlock.dropHoneycomb((Level)world, (BlockPos)blockPos);
            beehiveBlock.resetHoneyLevel(world, blockstate, blockPos);
            world.playSound((Entity)playerEntity, blockPos, SoundEvents.BEEHIVE_SHEAR, SoundSource.NEUTRAL, 1.0f, 1.0f);
            world.gameEvent((Entity)playerEntity, (Holder)GameEvent.SHEAR, blockPos);
            if (playerEntity != null) {
                itemStack.hurtAndBreak(1, (LivingEntity)playerEntity, LivingEntity.getSlotForHand((InteractionHand)context.getHand()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.useOn(context);
    }

    public static void registerLoottables_Fabric() {
        LootEvent.MODIFY_LOOT_TABLE.register((key, context, builtin) -> {
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.ACACIA_LEAVES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.AZALEA_LEAVES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.BIRCH_LEAVES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.CAVE_VINES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.CAVE_VINES_PLANT);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.COBWEB);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.DARK_OAK_LEAVES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.DEAD_BUSH);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.FERN);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.FLOWERING_AZALEA_LEAVES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.GLOW_LICHEN);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.SHORT_GRASS);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.JUNGLE_LEAVES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.LARGE_FERN);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.NETHER_SPROUTS);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.OAK_LEAVES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.SEAGRASS);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.SPRUCE_LEAVES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.TALL_GRASS);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.TALL_SEAGRASS);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.TWISTING_VINES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.TWISTING_VINES_PLANT);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.VINE);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.WEEPING_VINES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.WEEPING_VINES_PLANT);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.SMALL_DRIPLEAF);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.MANGROVE_LEAVES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.HANGING_ROOTS);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.CHERRY_LEAVES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.PALE_OAK_LEAVES);
            EnderiteShears.tryBuildLootTable((ResourceKey<LootTable>)key, context, Blocks.PALE_HANGING_MOSS);
        });
    }

    public static void tryBuildLootTable(ResourceKey<LootTable> key, LootEvent.LootTableModificationContext context, Block block) {
        if (block.getLootTable().isPresent() && ((ResourceKey)block.getLootTable().get()).equals(key)) {
            LootPool.Builder pool = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(MatchTool.toolMatches((ItemPredicate.Builder)ItemPredicate.Builder.item().of((HolderGetter)BuiltInRegistries.ITEM, new ItemLike[]{(ItemLike)EnderiteTools.ENDERITE_SHEAR.get()}))).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block.asItem()));
            context.addPool(pool);
        }
    }
}

