/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.tools;

import net.enderitemc.enderitemod.component.EnderiteChargeComponent;
import net.enderitemc.enderitemod.component.EnderiteDataComponents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ToolMaterial;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EnderiteSword
extends Item {
    public int superAufladung;

    public EnderiteSword(ToolMaterial material, int attackDamage, float attackSpeed, Item.Properties settings) {
        super(settings.sword(material, (float)attackDamage, attackSpeed));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult use(Level world, Player playerEntity, InteractionHand hand) {
        if (!playerEntity.isShiftKeyDown()) return InteractionResult.FAIL;
        Double distance = 30.0;
        double yaw = playerEntity.yHeadRot;
        double pitch = playerEntity.getXRot();
        double temp = Math.cos(Math.toRadians(pitch));
        double dX = temp * -Math.sin(Math.toRadians(yaw));
        double dY = -Math.sin(Math.toRadians(pitch));
        double dZ = temp * Math.cos(Math.toRadians(yaw));
        Vec3 position = playerEntity.position().add(0.0, playerEntity.getEyeY() - playerEntity.getY(), 0.0);
        Vec3 endPosition = new Vec3(position.x + dX * distance, position.y + dY * distance, position.z + dZ * distance);
        BlockPos blockPos = BlockPos.containing((double)endPosition.x, (double)endPosition.y, (double)endPosition.z);
        BlockPos[] blockPoses = new BlockPos[]{blockPos, blockPos.above(), blockPos};
        double down = endPosition.y;
        double maxDown = down - distance - 1.0 > (double)world.getMinY() ? down - distance - 1.0 : (double)world.getMinY();
        double up = endPosition.y + 1.0;
        double maxUp = 128.0;
        maxUp = playerEntity.getCommandSenderWorld().dimensionType().respawnAnchorWorks() ? (up + distance - 1.0 < 127.0 ? up + distance - 1.0 : 127.0) : (up + distance - 1.0 < (double)world.getMaxY() ? up + distance - 1.0 : (double)world.getMaxY());
        double near = distance;
        int slot = ((Number)playerEntity.getItemInHand(hand).getOrDefault((DataComponentType)EnderiteDataComponents.TELEPORT_CHARGE.get(), (Object)0)).intValue();
        if (!world.hasChunkAt(blockPos) || slot <= 0 && !playerEntity.getAbilities().instabuild) return InteractionResult.FAIL;
        int foundSpace = 0;
        while (foundSpace == 0 && ((double)blockPoses[0].getY() > maxDown || (double)blockPoses[1].getY() < maxUp)) {
            if ((double)blockPoses[0].getY() > maxDown) {
                if (this.checkBlocks(world, blockPoses[0])) {
                    foundSpace = 1;
                } else {
                    down -= 1.0;
                    blockPoses[0] = blockPoses[0].below();
                }
            }
            if ((double)blockPoses[1].getY() < maxUp) {
                if (this.checkBlocks(world, blockPoses[1])) {
                    foundSpace = 2;
                } else {
                    up += 1.0;
                    blockPoses[1] = blockPoses[1].above();
                }
            }
            if (!(near > 2.0)) continue;
            if (this.checkBlocks(world, blockPoses[2])) {
                foundSpace = 3;
                continue;
            }
            near -= 1.0;
            blockPoses[2] = blockPoses[2].offset((int)Math.floor(-dX), (int)Math.floor(-dY), (int)Math.floor(-dZ));
        }
        if (foundSpace == 0 && !world.getBlockState(blockPos).blocksMotion() && !world.getBlockState(blockPos.above()).blocksMotion()) {
            foundSpace = 4;
        }
        if (foundSpace <= 0 || !(position.y + dY * near < maxUp) || !(position.y + dY * near > maxDown)) return InteractionResult.SUCCESS.heldItemTransformedTo(playerEntity.getItemInHand(hand));
        playerEntity.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
        switch (foundSpace) {
            case 1: {
                playerEntity.randomTeleport(endPosition.x, down > maxDown ? down : maxDown, endPosition.z, true);
                break;
            }
            case 2: {
                playerEntity.randomTeleport(endPosition.x, up < maxUp ? up : maxUp, endPosition.z, true);
                break;
            }
            case 4: {
                near = distance / 2.0;
            }
            case 3: {
                down = position.y + dY * near;
                down = down > (double)world.getMinY() ? down : (double)(world.getMinY() + 1);
                playerEntity.randomTeleport(position.x + dX * near, down, position.z + dZ * near, true);
            }
        }
        playerEntity.getCooldowns().addCooldown(this.arch$registryName(), 30);
        if (!playerEntity.getAbilities().instabuild) {
            playerEntity.getItemInHand(hand).set((DataComponentType)EnderiteDataComponents.TELEPORT_CHARGE.get(), (Object)EnderiteChargeComponent.of(slot - 1));
        }
        world.broadcastEntityEvent((Entity)playerEntity, (byte)46);
        world.playSound(null, playerEntity.getX(), playerEntity.getY(), playerEntity.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
        playerEntity.playSound(SoundEvents.ENDERMAN_TELEPORT, 1.0f, 1.0f);
        return InteractionResult.SUCCESS.heldItemTransformedTo(playerEntity.getItemInHand(hand));
    }

    protected boolean checkBlocks(Level world, BlockPos pos) {
        return world.getBlockState(pos.below()).blocksMotion() && !world.getBlockState(pos).blocksMotion() && !world.getBlockState(pos.above()).blocksMotion();
    }
}

