/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.misc;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.enderitemc.enderitemod.ComponentHolderWrapper;
import net.enderitemc.enderitemod.EnderiteMod;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EnderiteElytraSpecialRecipe
extends CustomRecipe {
    public EnderiteElytraSpecialRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingInventory, Level world) {
        ItemStack itemStack = ItemStack.EMPTY;
        ItemStack itemStack2 = ItemStack.EMPTY;
        for (int i = 0; i < craftingInventory.size(); ++i) {
            ItemStack itemStack3 = craftingInventory.getItem(i);
            if (itemStack3.isEmpty()) continue;
            if (itemStack3.is((Item)EnderiteMod.ENDERITE_CHESTPLATE.get())) {
                if (!itemStack2.isEmpty()) {
                    return false;
                }
                itemStack2 = itemStack3;
                continue;
            }
            if (!ComponentHolderWrapper.contains(itemStack3, DataComponents.GLIDER).booleanValue()) {
                return false;
            }
            if (!itemStack.isEmpty()) {
                return false;
            }
            itemStack = itemStack3;
        }
        return !itemStack.isEmpty() && !itemStack2.isEmpty();
    }

    public ItemStack craft(CraftingInput craftingInventory, HolderLookup.Provider registryManager) {
        ItemStack chestplate_stack = ItemStack.EMPTY;
        ItemStack elytra_stack = ItemStack.EMPTY;
        for (int i = 0; i < craftingInventory.size(); ++i) {
            ItemStack itemStack3 = craftingInventory.getItem(i);
            if (itemStack3.isEmpty()) continue;
            if (itemStack3.is((Item)EnderiteMod.ENDERITE_CHESTPLATE.get())) {
                chestplate_stack = itemStack3;
                continue;
            }
            if (!ComponentHolderWrapper.contains(itemStack3, DataComponents.GLIDER).booleanValue()) continue;
            elytra_stack = itemStack3.copy();
        }
        if (elytra_stack.isEmpty()) {
            return elytra_stack;
        }
        ItemStack result_stack = new ItemStack((ItemLike)EnderiteMod.ENDERITE_ELYTRA.get());
        ItemEnchantments map1 = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)chestplate_stack);
        ItemEnchantments map2 = EnchantmentHelper.getEnchantmentsForCrafting((ItemStack)elytra_stack);
        ItemEnchantments.Mutable builder = new ItemEnchantments.Mutable(map1);
        for (Object2IntMap.Entry entry2 : map2.entrySet()) {
            int level2;
            Holder enchant = (Holder)entry2.getKey();
            int level1 = entry2.getIntValue();
            int level = level1 == (level2 = builder.getLevel(enchant)) ? Math.min(level1 + 1, ((Enchantment)enchant.value()).getMaxLevel()) : Math.max(level1, level2);
            builder.set(enchant, level);
        }
        EnchantmentHelper.setEnchantments((ItemStack)result_stack, (ItemEnchantments)builder.toImmutable());
        ArmorTrim trim = (ArmorTrim)chestplate_stack.getOrDefault(DataComponents.TRIM, (Object)((ArmorTrim)elytra_stack.getOrDefault(DataComponents.TRIM, null)));
        if (trim != null) {
            result_stack.set(DataComponents.TRIM, (Object)trim);
        }
        return result_stack;
    }

    public boolean fits(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)EnderiteMod.ENDERITE_EYLTRA_SPECIAL_RECIPE.get();
    }
}

