/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.misc;

import net.enderitemc.enderitemod.tools.EnderiteShield;
import net.enderitemc.enderitemod.tools.EnderiteTools;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerPatternLayers;

public class EnderiteShieldDecorationRecipe
extends CustomRecipe {
    public EnderiteShieldDecorationRecipe(CraftingBookCategory category) {
        super(category);
    }

    public boolean matches(CraftingInput craftingRecipeInput, Level world) {
        if (craftingRecipeInput.ingredientCount() != 2) {
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < craftingRecipeInput.size(); ++i) {
            ItemStack itemStack = craftingRecipeInput.getItem(i);
            if (itemStack.isEmpty()) continue;
            if (itemStack.getItem() instanceof BannerItem) {
                if (bl2) {
                    return false;
                }
                bl2 = true;
                continue;
            }
            if (!(itemStack.getItem() instanceof EnderiteShield)) {
                return false;
            }
            if (bl) {
                return false;
            }
            BannerPatternLayers bannerPatternsComponent = (BannerPatternLayers)itemStack.getOrDefault(DataComponents.BANNER_PATTERNS, (Object)BannerPatternLayers.EMPTY);
            if (!bannerPatternsComponent.layers().isEmpty()) {
                return false;
            }
            bl = true;
        }
        return bl && bl2;
    }

    public ItemStack craft(CraftingInput craftingInventory, HolderLookup.Provider registryManager) {
        ItemStack itemStack = ItemStack.EMPTY;
        ItemStack itemStack2 = ItemStack.EMPTY;
        for (int i = 0; i < craftingInventory.size(); ++i) {
            ItemStack itemStack3 = craftingInventory.getItem(i);
            if (itemStack3.isEmpty()) continue;
            if (itemStack3.getItem() instanceof BannerItem) {
                itemStack = itemStack3;
                continue;
            }
            if (!(itemStack3.getItem() instanceof EnderiteShield)) continue;
            itemStack2 = itemStack3.copy();
        }
        if (itemStack2.isEmpty()) {
            return itemStack2;
        }
        itemStack2.set(DataComponents.BANNER_PATTERNS, (Object)((BannerPatternLayers)itemStack.get(DataComponents.BANNER_PATTERNS)));
        itemStack2.set(DataComponents.BASE_COLOR, (Object)((BannerItem)itemStack.getItem()).getColor());
        return itemStack2;
    }

    public boolean fits(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<? extends CustomRecipe> getSerializer() {
        return (RecipeSerializer)EnderiteTools.ENDERITE_SHIELD_DECORATION_RECIPE.get();
    }
}

