/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.mixin;

import net.enderitemc.enderitemod.EnderiteMod;
import net.enderitemc.enderitemod.component.EnderiteChargeComponent;
import net.enderitemc.enderitemod.component.EnderiteDataComponents;
import net.enderitemc.enderitemod.tools.EnderiteTools;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.ItemCombinerMenuSlotDefinition;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SmithingMenu.class})
public abstract class SmithingEnderiteSwordMixin
extends ItemCombinerMenu {
    @Final
    @Shadow
    private Level level;

    @Shadow
    public abstract void shrinkStackInSlot(int var1);

    public SmithingEnderiteSwordMixin(int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super(MenuType.SMITHING, syncId, playerInventory, context, ItemCombinerMenuSlotDefinition.create().build());
    }

    @Inject(at={@At(value="TAIL")}, cancellable=true, method={"createResult()V"})
    private void update(CallbackInfo info) {
        ItemStack sword = this.inputSlots.getItem(1);
        ItemStack pearls1 = this.inputSlots.getItem(0);
        ItemStack pearls2 = this.inputSlots.getItem(2);
        if ((sword.is((Item)EnderiteTools.ENDERITE_SWORD.get()) || sword.is((Item)EnderiteTools.ENDERITE_SHIELD.get())) && (pearls1.is(Items.ENDER_PEARL) || pearls1.isEmpty()) && pearls2.is(Items.ENDER_PEARL)) {
            ItemStack newSword = sword.copy();
            int pearls = pearls1.getCount() + pearls2.getCount();
            int teleport_charge = ((Number)sword.getOrDefault((DataComponentType)EnderiteDataComponents.TELEPORT_CHARGE.get(), (Object)0)).intValue();
            if (teleport_charge < EnderiteMod.CONFIG.tools.maxTeleportCharge) {
                teleport_charge = Math.min(teleport_charge + pearls, EnderiteMod.CONFIG.tools.maxTeleportCharge);
                newSword.set((DataComponentType)EnderiteDataComponents.TELEPORT_CHARGE.get(), (Object)EnderiteChargeComponent.of(teleport_charge));
                this.resultSlots.setItem(0, newSword);
            } else {
                this.resultSlots.clearContent();
            }
        }
    }

    @Unique
    private void superDecrement(int i, int amount) {
        ItemStack itemStack = this.inputSlots.getItem(i);
        if (!itemStack.isEmpty()) {
            itemStack.shrink(amount);
            this.inputSlots.setItem(i, itemStack);
        }
    }

    @Inject(at={@At(value="HEAD")}, cancellable=true, method={"onTake(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/item/ItemStack;)V"})
    private void nowTake(Player player, ItemStack itemStack, CallbackInfo info) {
        ItemStack sword = this.inputSlots.getItem(1);
        ItemStack pearls1 = this.inputSlots.getItem(0);
        ItemStack pearls2 = this.inputSlots.getItem(2);
        if ((sword.is((Item)EnderiteTools.ENDERITE_SWORD.get()) || sword.is((Item)EnderiteTools.ENDERITE_SHIELD.get())) && (pearls1.is(Items.ENDER_PEARL) || pearls1.isEmpty()) && pearls2.is(Items.ENDER_PEARL)) {
            int amountToSubstract = pearls1.getCount() + pearls2.getCount();
            int tp_charge = ((Number)sword.getOrDefault((DataComponentType)EnderiteDataComponents.TELEPORT_CHARGE.get(), (Object)0)).intValue();
            int allowableSubstract = EnderiteMod.CONFIG.tools.maxTeleportCharge - tp_charge;
            amountToSubstract = Math.min(allowableSubstract, amountToSubstract);
            int half = amountToSubstract / 2;
            int subtract1 = Math.min(half, pearls1.getCount());
            int subtract2 = Math.min(amountToSubstract - subtract1, pearls2.getCount());
            subtract1 = Math.min(amountToSubstract - subtract2, pearls1.getCount());
            this.superDecrement(0, subtract1 - 1);
            this.superDecrement(2, subtract2 - 1);
        }
    }
}

