/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.shulker;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxBlock;
import net.enderitemc.enderitemod.shulker.EnderiteShulkerBoxBlockEntity;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Quaternionfc;

public class EnderiteShulkerBoxBlockEntityRenderer
implements BlockEntityRenderer<EnderiteShulkerBoxBlockEntity> {
    private final ShulkerBoxBlockModel model;
    private static final ResourceLocation TEXTURE = ResourceLocation.parse((String)"textures/entity/shulker/enderite_shulker.png");
    private static final RenderType ENDERITE_SHULKER = RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE);

    public EnderiteShulkerBoxBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.model = new ShulkerBoxBlockModel(ctx.bakeLayer(ModelLayers.SHULKER_BOX));
    }

    public void render(EnderiteShulkerBoxBlockEntity shulkerBoxBlockEntity, float tickProgress, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light, int overlay, Vec3 cameraPos) {
        BlockState blockState;
        Direction direction = Direction.UP;
        if (shulkerBoxBlockEntity.hasLevel() && (blockState = shulkerBoxBlockEntity.getLevel().getBlockState(shulkerBoxBlockEntity.getBlockPos())).getBlock() instanceof EnderiteShulkerBoxBlock) {
            direction = (Direction)blockState.getValue((Property)EnderiteShulkerBoxBlock.FACING);
        }
        Material spriteIdentifier = new Material(Sheets.SHULKER_SHEET, ResourceLocation.parse((String)"entity/shulker/enderite_shulker"));
        matrixStack.pushPose();
        matrixStack.translate(0.5f, 0.5f, 0.5f);
        float g = 0.9995f;
        matrixStack.scale(0.9995f, 0.9995f, 0.9995f);
        matrixStack.mulPose((Quaternionfc)direction.getRotation());
        matrixStack.scale(1.0f, -1.0f, -1.0f);
        matrixStack.translate(0.0f, -1.0f, 0.0f);
        this.model.animateLid(shulkerBoxBlockEntity, tickProgress);
        VertexConsumer vertexConsumer = spriteIdentifier.buffer(vertexConsumers, RenderType::entityCutoutNoCull);
        this.model.renderToBuffer(matrixStack, vertexConsumer, light, overlay);
        matrixStack.popPose();
    }

    @OnlyIn(value=Dist.CLIENT)
    static class ShulkerBoxBlockModel
    extends Model {
        private final ModelPart lid;

        public ShulkerBoxBlockModel(ModelPart root) {
            super(root, RenderType::entityCutoutNoCull);
            this.lid = root.getChild("lid");
        }

        public void animateLid(EnderiteShulkerBoxBlockEntity blockEntity, float delta) {
            this.lid.setPos(0.0f, 24.0f - blockEntity.getAnimationProgress(delta) * 0.5f * 16.0f, 0.0f);
            this.lid.yRot = 270.0f * blockEntity.getAnimationProgress(delta) * ((float)Math.PI / 180);
        }
    }
}

