/*
 * Decompiled with CFR 0.152.
 */
package net.enderitemc.enderitemod.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.enderitemc.enderitemod.EnderiteMod;
import net.enderitemc.enderitemod.blocks.EnderiteRespawnAnchor;
import net.enderitemc.enderitemod.blocks.RespawnAnchorUtils.EnderiteRespawnAnchorBlockEntity;
import net.enderitemc.enderitemod.tools.EnderiteTools;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterials;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class EnderiteTests {
    public static final String TMPL_MI = "enderitemod:";
    public static final String TMPL_NS = "enderitetests.";
    public static final String TMPL_PRE = "enderitemod:enderitetests.";

    public static void explodeEnderiteOreTest(GameTestHelper ctx) {
        ctx.spawn(EntityType.TNT, new BlockPos(1, 1, 0));
        ctx.runAfterDelay(99L, () -> ctx.assertBlock(new BlockPos(1, 1, 1), block -> block.equals(EnderiteMod.CRACKED_ENDERITE_ORE.get()), a -> Component.nullToEmpty((String)"TnT didn't crack the enderite ore")));
        ctx.succeedWhenBlockPresent((Block)EnderiteMod.CRACKED_ENDERITE_ORE.get(), new BlockPos(1, 1, 1));
    }

    public static void enderiteShulkerboxRecipeTest(GameTestHelper ctx) {
        EnderiteTests.crafterRecipeTest(ctx, stack -> {
            ItemContainerContents component = (ItemContainerContents)stack.get(DataComponents.CONTAINER);
            if (component != null) {
                ctx.assertTrue(component.copyOne().is(Items.DIRT), Component.nullToEmpty((String)"No items found in Enderite Shulkerbox item"));
            } else {
                ctx.assertTrue(false, Component.nullToEmpty((String)("No Container Component in stack" + stack.toString())));
            }
        });
    }

    public static void enderiteElytraRecipeTest(GameTestHelper ctx) {
        EnderiteTests.crafterRecipeTest(ctx, stack -> {
            ItemEnchantments component = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
            if (component != null) {
                Optional enchant0 = ctx.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.UNBREAKING.location());
                ctx.assertTrue(enchant0.isPresent() && component.getLevel((Holder)enchant0.get()) == 3, Component.nullToEmpty((String)"Enchantment wrong on Enderite Elytra"));
                Optional enchant1 = ctx.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.PROTECTION.location());
                ctx.assertTrue(enchant1.isPresent() && component.getLevel((Holder)enchant1.get()) == 1, Component.nullToEmpty((String)"Enchantment wrong on Enderite Elytra"));
            } else {
                ctx.assertTrue(false, Component.nullToEmpty((String)("No Container Component in stack" + stack.toString())));
            }
        });
    }

    public static void enderiteShieldDecoRecipeTest(GameTestHelper ctx) {
        EnderiteTests.crafterRecipeTest(ctx, stack -> {
            ItemEnchantments component = (ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS);
            if (component != null) {
                Optional enchant0 = ctx.getLevel().registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(Enchantments.UNBREAKING.location());
                ctx.assertTrue(enchant0.isPresent() && component.getLevel((Holder)enchant0.get()) == 3, Component.nullToEmpty((String)"Enchantment wrong on decorated Enderite Shield"));
            } else {
                ctx.assertTrue(false, Component.nullToEmpty((String)("No Enchantment Component in stack" + stack.toString())));
            }
        });
    }

    public static void enderiteRespawnAnchorTest(GameTestHelper ctx) {
        BlockPos anchor_pos = new BlockPos(0, 1, 0);
        BlockPos dirt_pos = new BlockPos(1, 1, 0);
        BlockEntity be = ctx.getBlockEntity(anchor_pos, EnderiteRespawnAnchorBlockEntity.class);
        ctx.assertTrue(be instanceof EnderiteRespawnAnchorBlockEntity, Component.nullToEmpty((String)"Enderite Respawn Anchor Block Entity is missing"));
        ctx.assertBlockPresent(Blocks.DIRT, dirt_pos);
        Player player = ctx.makeMockPlayer(GameType.SURVIVAL);
        player.setPos(ctx.absoluteVec(Vec3.ZERO));
        player.getInventory().add(Items.ENDER_PEARL.getDefaultInstance().copyWithCount(4));
        for (int expected_charge = 1; expected_charge <= 4; ++expected_charge) {
            ctx.useBlock(anchor_pos, player);
            ctx.placeAt(player, Items.ENDER_PEARL.getDefaultInstance(), anchor_pos, Direction.NORTH);
            ctx.assertValueEqual((Object)((Integer)ctx.getBlockState(anchor_pos).getValue((Property)EnderiteRespawnAnchor.CHARGE)), (Object)expected_charge, Component.nullToEmpty((String)"Enderite Respawn anchor has wrong amount of charge"));
        }
        ctx.useBlock(anchor_pos, player);
        if (EnderiteRespawnAnchor.isEnd((Level)ctx.getLevel())) {
            ctx.assertBlockPresent((Block)EnderiteMod.ENDERITE_RESPAWN_ANCHOR.get(), anchor_pos);
            ctx.assertBlockPresent(Blocks.DIRT, dirt_pos);
        } else {
            ctx.assertBlockNotPresent((Block)EnderiteMod.ENDERITE_RESPAWN_ANCHOR.get(), anchor_pos);
            ctx.assertBlockNotPresent(Blocks.DIRT, dirt_pos);
        }
        ctx.succeed();
    }

    public static void voidDeathWithEnderiteTest(GameTestHelper ctx) {
        Vec3 relative_pos = new Vec3(0.0, 0.0, 0.0);
        Vec3 absolute_pos = ctx.absoluteVec(relative_pos);
        ItemEntity ie = ctx.spawnItem((Item)EnderiteMod.ENDERITE_HELMET.get(), ctx.relativeVec(new Vec3(absolute_pos.x(), (double)(ctx.getLevel().getMinY() - 64), absolute_pos.z())));
        ctx.runAfterDelay(1L, () -> {
            ctx.assertEntityPresent(EntityType.ITEM, ctx.relativePos(new BlockPos((int)absolute_pos.x(), ctx.getLevel().getMinY() + 10, (int)absolute_pos.z())), 2.0);
            ie.kill(ctx.getLevel());
            ctx.succeed();
        });
    }

    public static void enderiteArmorTrimsTest(GameTestHelper ctx) {
        BlockPos pos1 = ctx.absolutePos(new BlockPos(-1, 0, -1));
        BlockPos pos2 = ctx.absolutePos(new BlockPos(4, 46, 1));
        List stands = ctx.getLevel().getEntitiesOfClass(ArmorStand.class, AABB.encapsulatingFullBlocks((BlockPos)pos1, (BlockPos)pos2));
        stands.forEach(Entity::discard);
        if (!ctx.getLevel().getNearestPlayer(TargetingConditions.forNonCombat(), (double)pos1.getX(), (double)pos1.getY(), (double)pos1.getZ()).getMainHandItem().getItem().equals(Items.ARMOR_STAND)) {
            ctx.succeed();
            return;
        }
        BlockPos pos = ctx.absolutePos(new BlockPos(0, 3, 0));
        ArrayList<ArmorStand> armor_stands = new ArrayList<ArmorStand>();
        for (int i = 0; i < 4; ++i) {
            pos = pos.relative(Direction.Axis.X, 1);
            HashMap<EquipmentSlot, Item> equip_map = new HashMap<EquipmentSlot, Item>();
            ResourceLocation material_id = ResourceLocation.fromNamespaceAndPath((String)"enderitemod", (String)"enderite");
            switch (i) {
                case 0: {
                    equip_map.put(EquipmentSlot.HEAD, (Item)EnderiteMod.ENDERITE_HELMET.get());
                    equip_map.put(EquipmentSlot.CHEST, (Item)EnderiteMod.ENDERITE_CHESTPLATE.get());
                    equip_map.put(EquipmentSlot.LEGS, (Item)EnderiteMod.ENDERITE_LEGGINGS.get());
                    equip_map.put(EquipmentSlot.FEET, (Item)EnderiteMod.ENDERITE_BOOTS.get());
                    break;
                }
                case 1: {
                    equip_map.put(EquipmentSlot.CHEST, (Item)EnderiteMod.ENDERITE_ELYTRA.get());
                    material_id = TrimMaterials.GOLD.location();
                    break;
                }
                case 2: {
                    equip_map.put(EquipmentSlot.CHEST, (Item)EnderiteMod.ENDERITE_ELYTRA_SEPERATED.get());
                    break;
                }
                case 3: {
                    equip_map.put(EquipmentSlot.HEAD, Items.GOLDEN_HELMET);
                    equip_map.put(EquipmentSlot.CHEST, Items.GOLDEN_CHESTPLATE);
                    equip_map.put(EquipmentSlot.LEGS, Items.GOLDEN_LEGGINGS);
                    equip_map.put(EquipmentSlot.FEET, Items.GOLDEN_BOOTS);
                }
            }
            Holder material = (Holder)ctx.getLevel().registryAccess().lookupOrThrow(Registries.TRIM_MATERIAL).get(material_id).get();
            int idx = 0;
            for (Holder pattern : ctx.getLevel().registryAccess().lookupOrThrow(Registries.TRIM_PATTERN).asHolderIdMap()) {
                BlockPos new_pos = pos.above(idx);
                idx += 2;
                ArmorStand e = new ArmorStand((Level)ctx.getLevel(), (double)new_pos.getX(), (double)new_pos.getY(), (double)new_pos.getZ());
                int equip_idx = ctx.getLevel().getRandom().nextInt(equip_map.keySet().toArray().length);
                EquipmentSlot slot = (EquipmentSlot)equip_map.keySet().stream().toList().get(equip_idx);
                for (Map.Entry entry : equip_map.entrySet()) {
                    ItemStack stack = ((Item)entry.getValue()).getDefaultInstance();
                    stack.set(DataComponents.TRIM, (Object)new ArmorTrim(material, pattern));
                    e.setItemSlot((EquipmentSlot)entry.getKey(), stack);
                    if (!((EquipmentSlot)entry.getKey()).equals((Object)slot)) continue;
                    e.setItemSlot(EquipmentSlot.MAINHAND, stack);
                    e.setShowArms(true);
                }
                e.setNoGravity(true);
                e.setNoBasePlate(true);
                armor_stands.add(e);
            }
        }
        ctx.getLevel().addWorldGenChunkEntities(armor_stands.stream());
        ctx.succeed();
    }

    public static void enderiteElytraTrimRecipeTest(GameTestHelper ctx) {
        EnderiteTests.crafterRecipeTest(ctx, stack -> {
            ArmorTrim component = (ArmorTrim)stack.get(DataComponents.TRIM);
            if (component != null) {
                String trim = component.material().getRegisteredName();
                ctx.assertValueEqual((Object)trim, (Object)"minecraft:gold", Component.nullToEmpty((String)"Wrong trim was applied."));
            } else {
                ctx.assertTrue(false, Component.nullToEmpty((String)("No Trim Component in stack" + stack.toString())));
            }
        });
    }

    public static void endermanEnderiteTest(GameTestHelper ctx) {
        ServerLevel world = ctx.getLevel();
        BlockPos pos = ctx.absolutePos(new BlockPos(0, 1, 0));
        EnderMan enderman = new EnderMan(EntityType.ENDERMAN, (Level)world);
        enderman.setPos(pos.getBottomCenter());
        world.addFreshEntity((Entity)enderman);
        Player player = ctx.makeMockPlayer(GameType.CREATIVE);
        AbstractArrow persistentProjectileEntity2 = ((ArrowItem)Items.ARROW).createArrow((Level)world, Items.ARROW.getDefaultInstance(), (LivingEntity)player, ((Item)EnderiteTools.ENDERITE_BOW.get()).getDefaultInstance());
        persistentProjectileEntity2.setCustomName((Component)Component.literal((String)"Enderite Arrow"));
        DamageSource source2 = world.damageSources().arrow(persistentProjectileEntity2, (Entity)player);
        int damage = 10;
        enderman.hurtServer(world, source2, (float)damage);
        ctx.assertValueEqual((Object)Float.valueOf(enderman.getHealth()), (Object)Float.valueOf(enderman.getMaxHealth() - (float)damage), Component.nullToEmpty((String)"Enderman not damaged from enderite arrow!"));
        AbstractArrow persistentProjectileEntity = ((ArrowItem)Items.ARROW).createArrow((Level)world, Items.ARROW.getDefaultInstance(), (LivingEntity)player, Items.BOW.getDefaultInstance());
        DamageSource source = world.damageSources().arrow(persistentProjectileEntity, (Entity)player);
        enderman.hurtServer(world, source, (float)damage);
        ctx.assertValueEqual((Object)Float.valueOf(enderman.getHealth()), (Object)Float.valueOf(enderman.getMaxHealth() - (float)damage), Component.nullToEmpty((String)"Enderman damaged from default arrow!"));
        enderman.discard();
        ctx.succeed();
    }

    public static void enderiteSmeltingTest(GameTestHelper ctx) {
        BlockPos pos = new BlockPos(0, 1, 0);
        ctx.runAfterDelay(15L, () -> {
            BlockEntity be = ctx.getBlockEntity(pos, BlastFurnaceBlockEntity.class);
            if (be instanceof BlastFurnaceBlockEntity) {
                BlastFurnaceBlockEntity bfbe = (BlastFurnaceBlockEntity)be;
                ItemStack stack = bfbe.getItem(2);
                ctx.assertTrue(stack.is((Item)EnderiteMod.ENDERITE_SCRAP.get()), Component.nullToEmpty((String)"No scrap produced"));
            } else {
                ctx.assertTrue(false, Component.nullToEmpty((String)"No Chest Block Entity found"));
            }
            ctx.succeed();
        });
    }

    public static void enderiteDispenserShearsTest(GameTestHelper ctx) {
        ServerLevel world = ctx.getLevel();
        BlockPos pos = ctx.absolutePos(new BlockPos(0, 1, 0));
        BlockPos button_pos = new BlockPos(1, 1, 1);
        ctx.pressButton(button_pos);
        ctx.runAfterDelay(3L, () -> {
            ctx.setBlock(button_pos, Blocks.OAK_BUTTON);
            ctx.pressButton(button_pos);
        });
        ctx.runAfterDelay(5L, () -> {
            LivingEntity entity = world.getNearestEntity(Sheep.class, TargetingConditions.DEFAULT, null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), AABB.encapsulatingFullBlocks((BlockPos)pos, (BlockPos)pos));
            if (entity instanceof Sheep) {
                Sheep sheep = (Sheep)entity;
                ctx.assertTrue(sheep.isSheared(), Component.nullToEmpty((String)"Sheep is not sheared!"));
            } else {
                ctx.assertTrue(false, Component.nullToEmpty((String)"No sheep spawned!"));
            }
            ctx.succeed();
        });
    }

    public static void enderiteDispenserShulkerboxTest(GameTestHelper ctx) {
        BlockPos pos = new BlockPos(0, 1, 0);
        BlockPos button_pos = new BlockPos(1, 1, 1);
        ctx.pressButton(button_pos);
        ctx.runAfterDelay(15L, () -> {
            ctx.assertBlockPresent((Block)EnderiteMod.ENDERITE_SHULKER_BOX.get(), pos);
            ctx.succeed();
        });
    }

    public static void crafterRecipeTest(GameTestHelper ctx, Consumer<ItemStack> stackVerifier) {
        ctx.pressButton(1, 1, 1);
        ctx.runAfterDelay(15L, () -> {
            BlockEntity be = ctx.getBlockEntity(new BlockPos(0, 1, 0), ChestBlockEntity.class);
            if (be instanceof ChestBlockEntity) {
                ChestBlockEntity cbe = (ChestBlockEntity)be;
                ItemStack stack = cbe.getItem(0);
                stackVerifier.accept(stack);
            } else {
                ctx.assertTrue(false, Component.nullToEmpty((String)"No Chest Block Entity found"));
            }
            ctx.succeed();
        });
    }
}

