/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.creeperhost.polylib.client.modulargui.ModularGui;
import net.creeperhost.polylib.client.modulargui.lib.GuiProvider;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

public class ModularGuiInjector<T extends class_437> {
    private static Map<Predicate<class_437>, Function<? extends class_437, GuiProvider>> providerMap = new HashMap<Predicate<class_437>, Function<? extends class_437, GuiProvider>>();
    private static ModularGui activeGui = null;
    private static double prevMouseX = 0.0;
    private static double prevMouseY = 0.0;

    public static void registerInjection(Predicate<class_437> screenPredicate, Function<class_437, GuiProvider> guiFunction) {
        providerMap.put(screenPredicate, guiFunction);
    }

    public static void init() {
        ClientGuiEvent.INIT_POST.register(ModularGuiInjector::initPost);
        ClientGuiEvent.RENDER_POST.register(ModularGuiInjector::renderPost);
        ClientScreenInputEvent.KEY_PRESSED_PRE.register(ModularGuiInjector::keyPressed);
        ClientScreenInputEvent.KEY_RELEASED_PRE.register(ModularGuiInjector::keyReleased);
        ClientScreenInputEvent.CHAR_TYPED_PRE.register(ModularGuiInjector::charTyped);
        ClientScreenInputEvent.MOUSE_SCROLLED_PRE.register(ModularGuiInjector::mouseScrolled);
        ClientScreenInputEvent.MOUSE_RELEASED_PRE.register(ModularGuiInjector::mouseReleased);
        ClientScreenInputEvent.MOUSE_CLICKED_PRE.register(ModularGuiInjector::mouseClicked);
        ClientTickEvent.CLIENT_POST.register(ModularGuiInjector::tick);
    }

    private static void initPost(class_437 screen, ScreenAccess access) {
        Predicate key;
        if (activeGui != null) {
            activeGui = null;
        }
        if ((key = (Predicate)providerMap.keySet().stream().filter(e -> e.test(screen)).findAny().orElse(null)) == null) {
            return;
        }
        activeGui = new ModularGui(providerMap.get(key).apply((class_437)((class_437)ModularGuiInjector.unsafeCast(screen))));
        activeGui.setScreen(screen);
        activeGui.onScreenInit(class_310.method_1551(), class_310.method_1551().field_1772, screen.field_22789, screen.field_22790);
        prevMouseX = activeGui.computeMouseX();
        prevMouseY = activeGui.computeMouseY();
    }

    public static <T> T unsafeCast(@Nullable Object object) {
        return (T)object;
    }

    private static void renderPost(class_437 screen, class_332 graphics, int mouseX, int mouseY, class_9779 delta) {
        if (activeGui == null) {
            return;
        }
        GuiRender render = new GuiRender(graphics);
        activeGui.render(render, delta.method_60636());
        activeGui.renderOverlay(render, delta.method_60636());
    }

    private static EventResult keyPressed(class_310 client, class_437 screen, int keyCode, int scanCode, int modifiers) {
        if (activeGui == null) {
            return EventResult.pass();
        }
        return activeGui.keyPressed(keyCode, scanCode, modifiers) ? EventResult.interruptFalse() : EventResult.pass();
    }

    private static EventResult keyReleased(class_310 client, class_437 screen, int keyCode, int scanCode, int modifiers) {
        if (activeGui == null) {
            return EventResult.pass();
        }
        return activeGui.keyReleased(keyCode, scanCode, modifiers) ? EventResult.interruptFalse() : EventResult.pass();
    }

    private static EventResult charTyped(class_310 client, class_437 screen, char character, int keyCode) {
        if (activeGui == null) {
            return EventResult.pass();
        }
        return activeGui.charTyped(character, keyCode) ? EventResult.interruptFalse() : EventResult.pass();
    }

    private static EventResult mouseScrolled(class_310 client, class_437 screen, double mouseX, double mouseY, double amountX, double amountY) {
        if (activeGui == null) {
            return EventResult.pass();
        }
        return activeGui.mouseScrolled(mouseX, mouseY, amountX, amountY) ? EventResult.interruptFalse() : EventResult.pass();
    }

    private static EventResult mouseReleased(class_310 client, class_437 screen, double mouseX, double mouseY, int button) {
        if (activeGui == null) {
            return EventResult.pass();
        }
        return activeGui.mouseReleased(mouseX, mouseY, button) ? EventResult.interruptFalse() : EventResult.pass();
    }

    private static EventResult mouseClicked(class_310 client, class_437 screen, double mouseX, double mouseY, int button) {
        if (activeGui == null) {
            return EventResult.pass();
        }
        return activeGui.mouseClicked(mouseX, mouseY, button) ? EventResult.interruptFalse() : EventResult.pass();
    }

    private static void tick(class_310 instance) {
        if (activeGui == null) {
            return;
        }
        double newX = activeGui.computeMouseX();
        double newY = activeGui.computeMouseY();
        if (newX != prevMouseX || newY != prevMouseY) {
            activeGui.mouseMoved(newX, newY);
            prevMouseX = newX;
            prevMouseY = newY;
        }
        activeGui.tick();
    }

    @Nullable
    public static ModularGui getActiveGui() {
        return activeGui;
    }
}

