/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.elements;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.creeperhost.polylib.client.modulargui.elements.GuiElement;
import net.creeperhost.polylib.client.modulargui.elements.GuiRectangle;
import net.creeperhost.polylib.client.modulargui.lib.Assembly;
import net.creeperhost.polylib.client.modulargui.lib.BackgroundRender;
import net.creeperhost.polylib.client.modulargui.lib.Constraints;
import net.creeperhost.polylib.client.modulargui.lib.GuiRender;
import net.creeperhost.polylib.client.modulargui.lib.geometry.GuiParent;
import net.creeperhost.polylib.client.modulargui.sprite.Material;
import net.creeperhost.polylib.client.modulargui.sprite.PolyTextures;
import net.creeperhost.polylib.helpers.FormatHelper;
import net.creeperhost.polylib.inventory.fluid.FluidManager;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiFluidTank
extends GuiElement<GuiFluidTank>
implements BackgroundRender {
    public static final Material DEFAULT_WINDOW = PolyTextures.getUncached("widgets/tank_window");
    private int gaugeColour = -7303024;
    private boolean drawGauge = true;
    private Material window = null;
    private Supplier<Long> capacity = () -> 10000L;
    private Supplier<FluidStack> fluidStack = FluidStack::empty;
    private BiFunction<FluidStack, Long, List<class_2561>> toolTipFormatter;

    public GuiFluidTank(@NotNull GuiParent<?> parent) {
        super(parent);
        this.setTooltipDelay(0);
        this.setToolTipFormatter(GuiFluidTank.defaultFormatter());
    }

    public GuiFluidTank setCapacity(long capacity) {
        return this.setCapacity(() -> capacity);
    }

    public GuiFluidTank setCapacity(Supplier<Long> capacity) {
        this.capacity = capacity;
        return this;
    }

    public GuiFluidTank setFluidStack(FluidStack fluidStack) {
        return this.setFluidStack(() -> fluidStack);
    }

    public GuiFluidTank setFluidStack(Supplier<FluidStack> fluidStack) {
        this.fluidStack = fluidStack;
        return this;
    }

    public GuiFluidTank setToolTipFormatter(BiFunction<FluidStack, Long, List<class_2561>> toolTipFormatter) {
        this.toolTipFormatter = toolTipFormatter;
        this.setTooltip(() -> this.toolTipFormatter.apply(this.getFluidStack(), this.getCapacity()));
        return this;
    }

    public GuiFluidTank setWindow(@Nullable Material window) {
        this.window = window;
        return this;
    }

    public GuiFluidTank setDrawGauge(boolean drawGauge) {
        this.drawGauge = drawGauge;
        return this;
    }

    public GuiFluidTank setGaugeColour(int gaugeColour) {
        this.gaugeColour = gaugeColour;
        return this;
    }

    public Long getCapacity() {
        return this.capacity.get();
    }

    public FluidStack getFluidStack() {
        return this.fluidStack.get();
    }

    @Override
    public void renderBehind(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        FluidStack stack = this.getFluidStack();
        Material fluidMat = Material.fromSprite(FluidStackHooks.getStillTexture((FluidStack)stack));
        if (!stack.isEmpty() && fluidMat != null) {
            int fluidColor = FluidStackHooks.getColor((FluidStack)stack);
            float height = this.getCapacity() <= 0L ? 0.0f : (float)this.ySize() * ((float)stack.getAmount() / (float)this.getCapacity().longValue());
            render.tileSprite(GuiRender.guiTexPipe(), this.xMin(), this.yMax() - (double)height, this.xMax(), this.yMax(), fluidMat.sprite(), fluidColor);
        }
        if (this.window != null) {
            render.tileSprite(GuiRender.guiTexPipe(), this.xMin(), this.yMin(), this.xMax(), this.yMax(), this.window.sprite(), -1);
        }
        this.gaugeColour = -16777216;
        if (this.drawGauge) {
            double spacing = this.computeGaugeSpacing();
            if (spacing == 0.0) {
                return;
            }
            double pos = spacing;
            while (pos + 1.0 < this.ySize()) {
                double width = this.xSize() / 4.0;
                double yPos = this.yMax() - 1.0 - pos;
                render.fill(this.xMax() - width, yPos, this.xMax(), yPos + 1.0, this.gaugeColour);
                pos += spacing;
            }
        }
    }

    private double computeGaugeSpacing() {
        double capacity;
        double ySize = this.ySize();
        if (ySize / ((capacity = (double)this.getCapacity().longValue()) / 100.0) > 3.0) {
            return ySize / (capacity / 100.0);
        }
        if (ySize / (capacity / 500.0) > 3.0) {
            return ySize / (capacity / 500.0);
        }
        if (ySize / (capacity / 1000.0) > 3.0) {
            return ySize / (capacity / 1000.0);
        }
        if (ySize / (capacity / 5000.0) > 3.0) {
            return ySize / (capacity / 5000.0);
        }
        if (ySize / (capacity / 10000.0) > 3.0) {
            return ySize / (capacity / 10000.0);
        }
        if (ySize / (capacity / 50000.0) > 3.0) {
            return ySize / (capacity / 50000.0);
        }
        if (ySize / (capacity / 100000.0) > 3.0) {
            return ySize / (capacity / 100000.0);
        }
        return 0.0;
    }

    public static Assembly<GuiRectangle, GuiFluidTank> simpleTank(@NotNull GuiParent<?> parent) {
        GuiRectangle container = GuiRectangle.vanillaSlot(parent);
        GuiFluidTank energyBar = new GuiFluidTank(container);
        Constraints.bind(energyBar, container, 1.0);
        return new Assembly<GuiRectangle, GuiFluidTank>(container, energyBar);
    }

    public static BiFunction<FluidStack, Long, List<class_2561>> defaultFormatter() {
        return (fluidStack, capacity) -> {
            ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
            tooltip.add(class_2561.method_43471((String)"fluid_tank.polylib.fluid_storage").method_27692(class_124.field_1062));
            if (!fluidStack.isEmpty()) {
                tooltip.add(class_2561.method_43471((String)"fluid_tank.polylib.contains").method_27692(class_124.field_1065).method_27693(" ").method_10852((class_2561)fluidStack.getName().method_27661().method_10862(class_2583.field_24360.method_36139(FluidStackHooks.getColor((FluidStack)fluidStack)))));
            }
            tooltip.add(class_2561.method_43471((String)"fluid_tank.polylib.capacity").method_27692(class_124.field_1065).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)FormatHelper.addCommas(capacity / FluidManager.MILLIBUCKET)).method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"fluid_tank.polylib.mb").method_27692(class_124.field_1080))));
            tooltip.add(class_2561.method_43471((String)"fluid_tank.polylib.stored").method_27692(class_124.field_1065).method_27693(" ").method_10852((class_2561)class_2561.method_43470((String)FormatHelper.addCommas(fluidStack.getAmount() / FluidManager.MILLIBUCKET)).method_27692(class_124.field_1080)).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"fluid_tank.polylib.mb").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)String.format(" (%.2f%%)", (double)fluidStack.getAmount() / (double)capacity.longValue() * 100.0)).method_27692(class_124.field_1080)));
            return tooltip;
        };
    }
}

