/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.client.modulargui.sprite;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1047;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7654;
import net.minecraft.class_7764;
import net.minecraft.class_7948;
import net.minecraft.class_7952;
import net.minecraft.class_8684;
import org.slf4j.Logger;

public class ModSpriteResourceLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_7654 ATLAS_INFO_CONVERTER = new class_7654("atlases", ".json");
    private final List<class_7948> sources;
    private final String modid;

    private ModSpriteResourceLoader(List<class_7948> list, String modid) {
        this.sources = list;
        this.modid = modid;
    }

    public List<Function<class_8684, class_7764>> list(class_3300 arg) {
        final HashMap map = new HashMap();
        class_7948.class_7949 output = new class_7948.class_7949(){

            public void method_47670(class_2960 location, class_7948.class_7950 arg2) {
                class_7948.class_7950 spriteSupplier;
                if (location.method_12836().equals(ModSpriteResourceLoader.this.modid) && (spriteSupplier = map.put(location, arg2)) != null) {
                    spriteSupplier.method_47676();
                }
            }

            public void method_47671(Predicate<class_2960> predicate) {
                Iterator iterator = map.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (!predicate.test((class_2960)entry.getKey())) continue;
                    ((class_7948.class_7950)entry.getValue()).method_47676();
                    iterator.remove();
                }
            }
        };
        this.sources.forEach(arg3 -> arg3.method_47673(arg, output));
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add(spriteResourceLoader -> class_1047.method_45805());
        builder.addAll(map.values());
        return builder.build();
    }

    public static ModSpriteResourceLoader load(class_3300 arg, class_2960 arg2, String modid) {
        class_2960 resourceLocation = ATLAS_INFO_CONVERTER.method_45112(arg2);
        ArrayList<class_7948> list = new ArrayList<class_7948>();
        for (class_3298 resource : arg.method_14489(resourceLocation)) {
            try {
                BufferedReader bufferedReader = resource.method_43039();
                try {
                    Dynamic dynamic = new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)bufferedReader));
                    DataResult var10001 = class_7952.field_41397.parse(dynamic);
                    Logger var10003 = LOGGER;
                    Objects.requireNonNull(var10003);
                    list.addAll((Collection)var10001.getOrThrow());
                }
                finally {
                    if (bufferedReader == null) continue;
                    bufferedReader.close();
                }
            }
            catch (Exception var11) {
                LOGGER.warn("Failed to parse atlas definition {} in pack {}", new Object[]{resourceLocation, resource.method_14480(), var11});
            }
        }
        return new ModSpriteResourceLoader(list, modid);
    }
}

