/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.containers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.creeperhost.polylib.client.modulargui.lib.container.DataSync;
import net.creeperhost.polylib.client.modulargui.lib.container.SlotGroup;
import net.creeperhost.polylib.network.PolyLibNetwork;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_9129;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModularGuiContainerMenu
extends class_1703 {
    private static final Logger LOGGER = LogManager.getLogger();
    public final class_1661 inventory;
    public final List<SlotGroup> slotGroups = new ArrayList<SlotGroup>();
    public final Map<class_1735, SlotGroup> slotGroupMap = new HashMap<class_1735, SlotGroup>();
    public final Map<Integer, List<class_1735>> zonedSlots = new HashMap<Integer, List<class_1735>>();
    public final List<DataSync<?>> dataSyncs = new ArrayList();

    protected ModularGuiContainerMenu(@Nullable class_3917<?> menuType, int containerId, class_1661 inventory) {
        super(menuType, containerId);
        this.inventory = inventory;
    }

    protected SlotGroup createSlotGroup(int zoneId, int ... quickMoveTo) {
        SlotGroup group = new SlotGroup(this, zoneId, quickMoveTo);
        this.slotGroups.add(group);
        return group;
    }

    protected SlotGroup playerSlotGroup() {
        return this.createSlotGroup(0, 1);
    }

    protected SlotGroup remoteSlotGroup() {
        return this.createSlotGroup(1, 0);
    }

    @Deprecated(forRemoval=true)
    public void setServerToClientPacketHandler(BiConsumer<class_3222, Consumer<class_9129>> serverToClientPacketHandler) {
    }

    @Deprecated(forRemoval=true)
    public void setClientToServerPacketHandler(Consumer<Consumer<class_9129>> clientToServerPacketHandler) {
    }

    public void sendPacketToClient(int packetId, Consumer<class_9129> packetWriter) {
        class_1657 class_16572 = this.inventory.field_7546;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            PolyLibNetwork.sendContainerPacketToClient(serverPlayer, buf -> {
                buf.method_52997(this.field_7763);
                buf.method_52997((int)((byte)packetId));
                packetWriter.accept((class_9129)buf);
            });
        }
    }

    public void sendPacketToServer(int packetId, Consumer<class_9129> packetWriter) {
        PolyLibNetwork.sendContainerPacketToServer(this.inventory.field_7546.method_56673(), buf -> {
            buf.method_52997(this.field_7763);
            buf.method_52997((int)((byte)packetId));
            packetWriter.accept((class_9129)buf);
        });
    }

    public static void handlePacketFromClient(class_1657 player, class_9129 packet) {
        byte containerId = packet.readByte();
        int packetId = packet.readByte() & 0xFF;
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof ModularGuiContainerMenu) {
            ModularGuiContainerMenu menu = (ModularGuiContainerMenu)class_17032;
            if (menu.field_7763 == containerId) {
                menu.handlePacketFromClient(player, packetId, packet);
            }
        }
    }

    public void handlePacketFromClient(class_1657 player, int packetId, class_9129 packet) {
    }

    public static void handlePacketFromServer(class_1657 player, class_9129 packet) {
        byte containerId = packet.readByte();
        int packetId = packet.readByte() & 0xFF;
        class_1703 class_17032 = player.field_7512;
        if (class_17032 instanceof ModularGuiContainerMenu) {
            ModularGuiContainerMenu menu = (ModularGuiContainerMenu)class_17032;
            if (menu.field_7763 == containerId) {
                menu.handlePacketFromServer(player, packetId, packet);
            }
        }
    }

    public void handlePacketFromServer(class_1657 player, int packetId, class_9129 packet) {
        if (packetId == 255) {
            int index = packet.readByte() & 0xFF;
            if (this.dataSyncs.size() > index) {
                this.dataSyncs.get(index).handleSyncPacket(packet);
            }
        }
    }

    public static boolean canStacksMerge(class_1799 stack1, class_1799 stack2) {
        if (stack1.method_7960() || stack2.method_7960()) {
            return false;
        }
        return class_1799.method_7973((class_1799)stack1, (class_1799)stack2);
    }

    public class_1799 method_7601(@NotNull class_1657 player, int slotIndex) {
        class_1735 slot = this.method_7611(slotIndex);
        if (slot == null || !slot.method_7681()) {
            return class_1799.field_8037;
        }
        SlotGroup group = this.slotGroupMap.get(slot);
        if (group == null) {
            return class_1799.field_8037;
        }
        class_1799 stack = slot.method_7677();
        class_1799 result = stack.method_7972();
        boolean movedAnything = false;
        for (Integer zone : group.quickMoveTo) {
            if (!this.zonedSlots.containsKey(zone)) {
                LOGGER.warn("Attempted to quick move to zone id {} but there are no slots assigned to this zone! This is a bug!", (Object)zone);
                continue;
            }
            if (!this.moveItemStackTo(stack, this.zonedSlots.get(zone), false)) continue;
            movedAnything = true;
            break;
        }
        if (!movedAnything) {
            return class_1799.field_8037;
        }
        if (stack.method_7960()) {
            slot.method_7673(class_1799.field_8037);
        } else {
            slot.method_7668();
        }
        slot.method_7667(player, stack);
        return result;
    }

    protected boolean moveItemStackTo(class_1799 stack, List<class_1735> targets, boolean reverse) {
        class_1799 itemStack2;
        class_1735 slot;
        int start = 0;
        int end = targets.size();
        boolean moved = false;
        int position = start;
        if (reverse) {
            position = end - 1;
        }
        if (stack.method_7946()) {
            while (!stack.method_7960() && !(!reverse ? position >= end : position < start)) {
                slot = targets.get(position);
                itemStack2 = slot.method_7677();
                if (!itemStack2.method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)itemStack2)) {
                    int l = itemStack2.method_7947() + stack.method_7947();
                    if (l <= Math.min(stack.method_7914(), slot.method_7676(stack))) {
                        stack.method_7939(0);
                        itemStack2.method_7939(l);
                        slot.method_7668();
                        moved = true;
                    } else if (itemStack2.method_7947() < Math.min(stack.method_7914(), slot.method_7676(stack))) {
                        stack.method_7934(stack.method_7914() - itemStack2.method_7947());
                        itemStack2.method_7939(stack.method_7914());
                        slot.method_7668();
                        moved = true;
                    }
                }
                if (reverse) {
                    --position;
                    continue;
                }
                ++position;
            }
        }
        if (!stack.method_7960()) {
            position = reverse ? end - 1 : start;
            while (!(!reverse ? position >= end : position < start)) {
                slot = targets.get(position);
                itemStack2 = slot.method_7677();
                if (itemStack2.method_7960() && slot.method_7680(stack)) {
                    if (stack.method_7947() > slot.method_7676(stack)) {
                        slot.method_53512(stack.method_7971(slot.method_7676(stack)));
                    } else {
                        slot.method_53512(stack.method_7971(stack.method_7947()));
                    }
                    slot.method_7668();
                    moved = true;
                    break;
                }
                if (reverse) {
                    --position;
                    continue;
                }
                ++position;
            }
        }
        return moved;
    }

    public void mapSlot(class_1735 slot, SlotGroup slotGroup) {
        this.slotGroupMap.put(slot, slotGroup);
        this.zonedSlots.computeIfAbsent(slotGroup.zone, e -> new ArrayList()).add(slot);
    }

    public void method_7623() {
        super.method_7623();
        this.dataSyncs.forEach(DataSync::detectAndSend);
    }
}

