/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.polylib.data.serializable;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_9129;

public abstract class AbstractDataStore<T> {
    private boolean isDirty = true;
    protected T value;
    protected Predicate<T> validator = value -> true;

    public AbstractDataStore(T defaultValue) {
        this.value = defaultValue;
    }

    public AbstractDataStore<T> setValidator(Predicate<T> validator) {
        this.validator = validator;
        return this;
    }

    @Deprecated
    public T getValue() {
        return this.get();
    }

    public T get() {
        return this.value;
    }

    @Deprecated
    public void setValue(T value) {
        this.set(value);
    }

    public T set(T value) {
        if (!Objects.equals(value, this.value) && this.validator.test(value)) {
            this.value = value;
            this.markDirty();
        }
        return this.value;
    }

    public void markDirty() {
        this.isDirty = true;
    }

    public boolean isDirty(boolean reset) {
        if (this.isDirty) {
            this.isDirty = !reset;
            return true;
        }
        return false;
    }

    public abstract void toBytes(class_9129 var1);

    public abstract void fromBytes(class_9129 var1);

    public abstract void toTag(class_11372 var1);

    public abstract void fromTag(class_11368 var1);

    public boolean isSameValue(T newValue) {
        return Objects.equals(this.value, newValue);
    }

    protected T validValue(T value, T fallBack) {
        return this.validator.test(value) ? value : fallBack;
    }
}

